/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core.util;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntityBlockHelper {
    public static final ResourceLocation ITEM_TRADER_TYPE = VersionUtil.lcResource("item_trader");
    public static final ResourceLocation FREEZER_TRADER_TYPE = VersionUtil.lcResource("freezer_trader");
    public static final ResourceLocation BOOKSHELF_TRADER_TYPE = VersionUtil.lcResource("bookshelf_trader");
    public static final ResourceLocation SLOT_MACHINE_TRADER_TYPE = VersionUtil.lcResource("slot_machine_trader");
    public static final ResourceLocation CAPABILITY_INTERFACE_TYPE = VersionUtil.lcResource("capability_interface");
    public static final ResourceLocation AUCTION_STAND_TYPE = VersionUtil.lcResource("auction_stand");
    public static final ResourceLocation GACHA_MACHINE_TYPE = VersionUtil.lcResource("gacha_machine");
    private static final Map<ResourceLocation, List<Supplier<Block>>> blockList = new HashMap<ResourceLocation, List<Supplier<Block>>>();

    public static Block[] getBlocksForBlockEntity(ResourceLocation beType) {
        ArrayList<Block> result = new ArrayList<Block>();
        for (Supplier blockSource : (List)blockList.getOrDefault(beType, new ArrayList())) {
            try {
                Block b = (Block)blockSource.get();
                if (b == null) continue;
                result.add(b);
            }
            catch (Throwable throwable) {}
        }
        return (Block[])result.toArray(Block[]::new);
    }

    public static <T extends Block> void addBlockToBlockEntity(ResourceLocation beType, Supplier<T> blockSource) {
        BlockEntityBlockHelper.addBlocksToBlockEntity(beType, Lists.newArrayList((Object[])new Supplier[]{blockSource}));
    }

    public static <T extends Block> void addBlocksToBlockEntity(ResourceLocation beType, RegistryObjectBundle<T, ?> blocks) {
        BlockEntityBlockHelper.addBlocksToBlockEntity(beType, blocks.getSupplier());
    }

    public static <T extends Block> void addBlocksToBlockEntity(ResourceLocation beType, RegistryObjectBiBundle<T, ?, ?> blocks) {
        BlockEntityBlockHelper.addBlocksToBlockEntity(beType, blocks.getSupplier());
    }

    @SafeVarargs
    public static <T extends Block> void addBlocksToBlockEntity(ResourceLocation beType, RegistryObject<T> ... blocks) {
        ArrayList<Supplier<T>> blockSources = new ArrayList<Supplier<T>>();
        for (RegistryObject<T> block : blocks) {
            if (block == null) continue;
            blockSources.add(() -> block.get());
        }
        BlockEntityBlockHelper.addBlocksToBlockEntity(beType, blockSources);
    }

    public static <T extends Block> void addBlocksToBlockEntity(ResourceLocation beType, List<Supplier<T>> blockSources) {
        List list = blockList.getOrDefault(beType, new ArrayList());
        for (Supplier<T> s : blockSources) {
            list.add(s::get);
        }
        blockList.put(beType, list);
    }

    static {
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.ITEM_NETWORK_TRADER_1, ModBlocks.ITEM_NETWORK_TRADER_2, ModBlocks.ITEM_NETWORK_TRADER_3, ModBlocks.ITEM_NETWORK_TRADER_4);
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.DISPLAY_CASE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.VENDING_MACHINE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.VENDING_MACHINE_LARGE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.SHELF);
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.SHELF_2x2);
        BlockEntityBlockHelper.addBlocksToBlockEntity(ITEM_TRADER_TYPE, ModBlocks.CARD_DISPLAY);
        BlockEntityBlockHelper.addBlocksToBlockEntity(FREEZER_TRADER_TYPE, ModBlocks.FREEZER);
        BlockEntityBlockHelper.addBlocksToBlockEntity(BOOKSHELF_TRADER_TYPE, ModBlocks.BOOKSHELF_TRADER);
        BlockEntityBlockHelper.addBlocksToBlockEntity(SLOT_MACHINE_TRADER_TYPE, ModBlocks.SLOT_MACHINE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(GACHA_MACHINE_TYPE, ModBlocks.GACHA_MACHINE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(CAPABILITY_INTERFACE_TYPE, ModBlocks.VENDING_MACHINE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(CAPABILITY_INTERFACE_TYPE, ModBlocks.VENDING_MACHINE_LARGE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(CAPABILITY_INTERFACE_TYPE, ModBlocks.FREEZER);
        BlockEntityBlockHelper.addBlocksToBlockEntity(CAPABILITY_INTERFACE_TYPE, ModBlocks.ARMOR_DISPLAY);
        BlockEntityBlockHelper.addBlocksToBlockEntity(CAPABILITY_INTERFACE_TYPE, ModBlocks.TICKET_KIOSK);
        BlockEntityBlockHelper.addBlocksToBlockEntity(CAPABILITY_INTERFACE_TYPE, ModBlocks.SLOT_MACHINE);
        BlockEntityBlockHelper.addBlocksToBlockEntity(AUCTION_STAND_TYPE, ModBlocks.AUCTION_STAND);
    }
}

