/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core.groups;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.groups.BundleRequestFilter;
import io.github.lightman314.lightmanscurrency.util.TriConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.registries.RegistryObject;

public class RegistryObjectBiBundle<T, L, M> {
    private final Comparator<L> sorter1;
    private final Comparator<M> sorter2;
    private boolean locked = false;
    private final Map<L, Map<M, RegistryObject<T>>> values = new HashMap<L, Map<M, RegistryObject<T>>>();

    public RegistryObjectBiBundle<T, L, M> lock() {
        this.locked = true;
        return this;
    }

    public RegistryObjectBiBundle(@Nonnull Comparator<L> sorter1, @Nonnull Comparator<M> sorter2) {
        this.sorter1 = sorter1;
        this.sorter2 = sorter2;
    }

    public void put(L key1, M key2, RegistryObject<T> value) {
        if (this.locked) {
            LightmansCurrency.LogWarning("Attempted to put an object in the bundle after it's been locked.");
            return;
        }
        Map childMap = this.values.getOrDefault(key1, new HashMap());
        if (childMap.containsKey(key2)) {
            LightmansCurrency.LogWarning("Attempted to put a second object with key '" + key1.toString() + "," + key2.toString() + "' into the registry bundle.");
            return;
        }
        childMap.put(key2, value);
        this.values.put(key1, childMap);
    }

    public RegistryObject<T> getRegistryObject(L key1, M key2) {
        Map<M, RegistryObject<T>> childMap;
        if (this.values.containsKey(key1) && (childMap = this.values.get(key1)).containsKey(key2)) {
            return childMap.get(key2);
        }
        return null;
    }

    public T get(L key1, M key2) {
        RegistryObject<T> result = this.getRegistryObject(key1, key2);
        if (result != null) {
            return (T)result.get();
        }
        return null;
    }

    public Collection<RegistryObject<T>> getAllRegistryObjects() {
        ArrayList result = new ArrayList();
        this.values.values().forEach((? super T childMap) -> result.addAll(childMap.values()));
        return result;
    }

    public Collection<RegistryObject<T>> getAllRegistryObjects(@Nonnull L section) {
        ArrayList result = new ArrayList();
        ((Map)this.values.getOrDefault(section, new HashMap())).forEach((? super K m, ? super V v) -> result.add((RegistryObject)v));
        return result;
    }

    public List<T> getAll() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (RegistryObject<T> value : this.getAllRegistryObjects()) {
            values.add(value.get());
        }
        return values;
    }

    public List<T> getAll(@Nonnull L section) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (RegistryObject<T> value : this.getAllRegistryObjects(section)) {
            values.add(value.get());
        }
        return values;
    }

    public List<L> getKey1Sorted() {
        return this.getKey1Sorted(this.sorter1);
    }

    private List<L> getKey1Sorted(Comparator<L> sorter) {
        ArrayList<L> keys = new ArrayList<L>(this.values.keySet());
        keys.sort(sorter);
        return keys;
    }

    private List<M> getKey2Sorted(Map<M, RegistryObject<T>> map) {
        return this.getKey2Sorted(map, this.sorter2);
    }

    private List<M> getKey2Sorted(Map<M, RegistryObject<T>> map, Comparator<M> sorter) {
        ArrayList<M> keys = new ArrayList<M>(map.keySet());
        keys.sort(sorter);
        return keys;
    }

    public List<T> getAllSorted() {
        return this.getAllSorted(BundleRequestFilter.ALL);
    }

    public List<T> getAllSorted(@Nonnull BundleRequestFilter filter) {
        return this.getAllSorted(filter, this.sorter1, this.sorter2);
    }

    public List<T> getAllSorted(@Nonnull Comparator<L> sorter1, @Nonnull Comparator<M> sorter2) {
        return this.getAllSorted(BundleRequestFilter.ALL, sorter1, sorter2);
    }

    public List<T> getAllSorted(@Nonnull BundleRequestFilter filter, @Nonnull Comparator<L> sorter1, @Nonnull Comparator<M> sorter2) {
        List<Object> keys1 = this.getKey1Sorted(sorter1).stream().filter(filter::filterKey).toList();
        ArrayList<T> result = new ArrayList<T>();
        for (Object key1 : keys1) {
            List<Object> keys2 = this.getKey2Sorted(this.values.get(key1), sorter2).stream().filter(filter::filterKey).toList();
            for (Object key2 : keys2) {
                result.add(this.get(key1, key2));
            }
        }
        return result;
    }

    public List<Supplier<T>> getSupplier() {
        ArrayList<Supplier<T>> result = new ArrayList<Supplier<T>>();
        for (L key1 : this.values.keySet()) {
            Map<M, RegistryObject<T>> childMap = this.values.get(key1);
            for (M key2 : childMap.keySet()) {
                result.add(() -> this.get(key1, key2));
            }
        }
        return result;
    }

    public void forEachKey1(@Nonnull Consumer<L> consumer) {
        for (L key : this.getKey1Sorted()) {
            consumer.accept(key);
        }
    }

    public void forEach(TriConsumer<L, M, RegistryObject<T>> consumer) {
        List<L> key1 = this.getKey1Sorted();
        for (L k1 : key1) {
            Map<M, RegistryObject<T>> map = this.values.get(k1);
            List<M> key2 = this.getKey2Sorted(map);
            for (M k2 : key2) {
                consumer.accept(k1, k2, map.get(k2));
            }
        }
    }
}

