/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.ColorArgument;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.data.types.TicketDataCache;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class CommandTicket {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tickets").requires(commandSource -> commandSource.m_230897_() && commandSource.m_6761_(2))).then(Commands.m_82127_((String)"changeColor").then(Commands.m_82129_((String)"color", (ArgumentType)ColorArgument.argument()).executes(CommandTicket::changeColor)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create").executes(CommandTicket::createTicketNonColored)).then(Commands.m_82129_((String)"color", (ArgumentType)ColorArgument.argument()).executes(CommandTicket::createTicketColored)));
        dispatcher.register(command);
    }

    static int changeColor(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer player = source.m_81375_();
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof TicketItem) {
            int color = ColorArgument.getColor(commandContext, "color");
            TicketItem.SetTicketColor(heldItem, color);
        } else {
            EasyText.sendCommandFail(source, (Component)LCText.COMMAND_TICKETS_COLOR_NOT_HELD.get(new Object[0]));
        }
        return 0;
    }

    static int createTicketNonColored(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        ItemStack ticket = TicketItem.CreateTicket((Item)ModItems.TICKET_MASTER.get(), TicketDataCache.TYPE.get(false).createNextID());
        CommandTicket.giveItemToPlayer(player, ticket);
        return 1;
    }

    static int createTicketColored(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).m_81375_();
        int color = ColorArgument.getColor(commandContext, "color");
        ItemStack ticket = TicketItem.CreateTicket((Item)ModItems.TICKET_MASTER.get(), TicketDataCache.TYPE.get(false).createNextID(), color);
        CommandTicket.giveItemToPlayer(player, ticket);
        return 1;
    }

    private static void giveItemToPlayer(ServerPlayer player, ItemStack item) {
        Inventory inv = player.m_150109_();
        if (inv.m_8020_(inv.f_35977_).m_41619_()) {
            player.m_150109_().m_6836_(inv.f_35977_, item);
        } else {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item);
        }
    }
}

