/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.blockentity.MoneyBagBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Range;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MoneyBagBlock
extends FallingBlock
implements IRotatableBlock,
IEasyEntityBlock {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)0, (int)3);
    public static final ImmutableList<VoxelShape> SHAPES = ImmutableList.of((Object)MoneyBagBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (Object)MoneyBagBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), (Object)MoneyBagBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), (Object)LazyShapes.BOX_T);

    public MoneyBagBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{SIZE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)SIZE, (Comparable)Integer.valueOf(MoneyBagItem.getSize(context.m_43722_())));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    protected VoxelShape shapeForSize(int size) {
        return (VoxelShape)SHAPES.get(size);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeForSize((Integer)state.m_61143_((Property)SIZE));
    }

    @Override
    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return Lists.newArrayList((Object[])new BlockEntityType[]{(BlockEntityType)ModBlockEntities.MONEY_BAG.get()});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MoneyBagBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            be.loadFromItem(stack);
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_()) {
                ItemStack taken = be.removeRandomItem();
                if (!taken.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)taken);
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
                }
                level.m_5594_(null, pos, SoundEvents.f_11678_, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                if (be.tryInsertItem(stack, player)) {
                    stack.m_41774_(1);
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
                }
                level.m_5594_(null, pos, SoundEvents.f_11678_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            if (be.shouldDropItem) {
                int size = be.getBlockSize();
                List<ItemStack> contents = be.clearContents();
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)MoneyBagItem.createItem((ItemLike)this, contents));
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (player.m_7500_() && player.m_6047_() && (blockEntity = level.m_7702_(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            be.copyContentsTo(stack);
        }
        return stack;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (MoneyBagBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_() && (blockEntity = level.m_7702_(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            be.shouldDropItem = false;
            FallingBlockEntity fallingBlock = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
            fallingBlock.f_31944_ = be.m_187482_();
            int size = be.getBlockSize();
            float damagePerDistance = ((Float)LCConfig.SERVER.moneyBagBaseFallDamage.get()).floatValue() + (float)size * ((Float)LCConfig.SERVER.moneyBagFallDamagerPerSize.get()).floatValue();
            int damageLimit = (Integer)LCConfig.SERVER.moneyBagMaxFallDamageBase.get() + size * (Integer)LCConfig.SERVER.moneyBagMaxFallDamagePerSize.get();
            if (damagePerDistance > 0.0f && damageLimit > 0) {
                fallingBlock.m_149656_(damagePerDistance, damageLimit);
            }
            this.m_6788_(fallingBlock);
        }
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        BlockEntity blockEntity;
        BlockPos startPos = fallingBlock.m_31978_();
        int fall = startPos.m_123342_() - pos.m_123342_();
        LightmansCurrency.LogDebug("Money Bag fell " + fall + "m");
        if (fall >= (Integer)LCConfig.SERVER.moneyBagCoinLossFallDistance.get() && (blockEntity = level.m_7702_(pos)) instanceof MoneyBagBlockEntity) {
            MoneyBagBlockEntity be = (MoneyBagBlockEntity)blockEntity;
            int testCount = Math.round((float)fall * 2.0f);
            double dropChance = (Double)LCConfig.SERVER.moneyBagCoinLossChance.get();
            if (dropChance <= 0.0) {
                return;
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            RandomSource random = level.m_213780_();
            for (int i = 0; i < testCount && !be.isEmpty(); ++i) {
                if (!(random.m_188500_() < dropChance)) continue;
                drops.add(be.removeRandomItem());
            }
            if (!drops.isEmpty()) {
                LightmansCurrency.LogDebug("Money Bag dropped " + drops.size() + " coins after landing");
                Vec3 itemSpawn = MoneyBagBlock.getDropPosition(pos, (Integer)state.m_61143_((Property)SIZE));
                for (ItemStack item : drops) {
                    ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item);
                    entity.m_20334_(random.m_216328_(0.0, 0.5), (double)fall * 0.25 + random.m_216328_(2.0, 1.0), random.m_216328_(0.0, 0.5));
                    level.m_7967_((Entity)entity);
                }
            }
        }
    }

    public static Vec3 getDropPosition(BlockPos pos, @Range(from=0L, to=3L) int size) {
        Vec3 center = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        return switch (size) {
            case 0 -> center.m_82520_(0.0, 0.4375, 0.0);
            case 1 -> center.m_82520_(0.0, 0.625, 0.0);
            case 2 -> center.m_82520_(0.0, 0.75, 0.0);
            default -> center.m_82520_(0.0, 1.0625, 0.0);
        };
    }

    public ItemStack getDropItem(ItemStack stack, CompoundTag tag) {
        if (stack == null || stack.m_41619_() || !stack.m_150930_(this.m_5456_())) {
            return stack;
        }
        if (tag.m_128441_("CustomName")) {
            stack.m_41714_((Component)Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")));
        }
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        ListTag list = tag.m_128437_("Contents", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = InventoryUtil.loadItemNoLimits(list.m_128728_(i));
            if (item.m_41619_()) continue;
            contents.add(item);
        }
        MoneyBagItem.setContents(stack, contents);
        if (tag.m_128441_("LootTable")) {
            CompoundTag itemTag = stack.m_41784_();
            itemTag.m_128359_("LootTable", tag.m_128461_("LootTable"));
            if (tag.m_128441_("LootTableSeed")) {
                itemTag.m_128356_("LootTableSeed", tag.m_128454_("LootTableSeed"));
            }
            stack.m_41751_(itemTag);
        }
        return stack;
    }
}

