/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettings;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsHolder;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PaygateBlockEntity
extends TraderBlockEntity<PaygateTraderData>
implements IDirectionalSettingsHolder {
    private int timer = 0;
    private final DirectionalSettings outputSides = new DirectionalSettings(this);

    public boolean allowOutputSide(Direction side) {
        return this.outputSides.getState(side).allowsOutputs();
    }

    public PaygateBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.PAYGATE.get(), pos, state);
    }

    protected PaygateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    protected PaygateTraderData castOrNullify(@Nonnull TraderData trader) {
        if (trader instanceof PaygateTraderData) {
            PaygateTraderData pg = (PaygateTraderData)trader;
            return pg;
        }
        return null;
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        this.saveTimer(compound);
        this.saveOutputSides(compound);
    }

    public final CompoundTag saveTimer(CompoundTag compound) {
        compound.m_128405_("Timer", Math.max(this.timer, 0));
        return compound;
    }

    public final CompoundTag saveOutputSides(CompoundTag compound) {
        this.outputSides.save(compound, "OutputSides");
        return compound;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        if (compound.m_128425_("Timer", 3)) {
            this.timer = Math.max(compound.m_128451_("Timer"), 0);
        }
        this.outputSides.load(compound, "OutputSides");
        super.m_142466_(compound);
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public void activate(int duration, int level, DirectionalSettings outputSides) {
        this.timer = duration;
        this.outputSides.copy(outputSides);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWER_LEVEL, (Comparable)Integer.valueOf(MathUtil.clamp(level, 0, 15))));
        this.markTimerDirty();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.timer > 0) {
            --this.timer;
            this.markTimerDirty();
            if (this.timer <= 0) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWER_LEVEL, (Comparable)Integer.valueOf(0)));
                this.outputSides.clear();
            }
        }
    }

    public void markTimerDirty() {
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveTimer(new CompoundTag()));
        }
    }

    public int getValidTicketTrade(Player player, ItemStack heldItem) {
        long ticketID;
        PaygateTraderData trader = (PaygateTraderData)this.getTraderData();
        if (TicketItem.isTicketOrPass(heldItem) && (ticketID = TicketItem.GetTicketID(heldItem)) >= -1L) {
            TradeContext context = TradeContext.create((TraderData)trader, player).build();
            for (int i = 0; i < trader.getTradeCount(); ++i) {
                PaygateTradeData trade = trader.getTrade(i);
                if (!trade.isTicketTrade() || trade.getTicketID() != ticketID || trader.runPreTradeEvent(trade, context).isCanceled()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @Nonnull
    protected PaygateTraderData buildNewTrader() {
        return new PaygateTraderData(this.f_58857_, this.f_58858_);
    }
}

