/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class CashRegisterBlockEntity
extends BlockEntity
implements ITraderSource {
    List<BlockPos> positions = new ArrayList<BlockPos>();
    Component customTitle = null;

    public CashRegisterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CASH_REGISTER.get(), pos, state);
    }

    public void loadDataFromItems(ItemStack stack) {
        if (stack == null || !stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        this.readPositions(tag);
        if (stack.m_41788_()) {
            this.customTitle = stack.m_41786_();
        }
    }

    public void OpenContainer(Player player) {
        MenuProvider provider = TraderData.getTraderMenuProvider(this.f_58858_, BlockEntityValidator.of(this));
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
            return;
        }
        if (!this.getTraders().isEmpty()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
        } else {
            player.m_213846_((Component)LCText.MESSAGE_CASH_REGISTER_NOT_LINKED.get(new Object[0]));
        }
    }

    @Override
    public boolean isSingleTrader() {
        return false;
    }

    @Override
    @Nonnull
    public List<TraderData> getTraders() {
        ArrayList<TraderData> traders = new ArrayList<TraderData>();
        for (BlockPos position : this.positions) {
            TraderBlockEntity be;
            Object trader;
            BlockEntity blockEntity = this.f_58857_.m_7702_(position);
            if (!(blockEntity instanceof TraderBlockEntity) || (trader = (be = (TraderBlockEntity)blockEntity).getTraderData()) == null || !((TraderData)trader).allowAccess()) continue;
            traders.add((TraderData)trader);
        }
        return traders;
    }

    @Override
    @Nullable
    public Component getCustomTitle() {
        return this.customTitle;
    }

    @Override
    public boolean showSearchBox() {
        return this.positions.size() > 1;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        ListTag storageList = new ListTag();
        for (BlockPos thisPos : this.positions) {
            CompoundTag thisEntry = new CompoundTag();
            thisEntry.m_128405_("x", thisPos.m_123341_());
            thisEntry.m_128405_("y", thisPos.m_123342_());
            thisEntry.m_128405_("z", thisPos.m_123343_());
            storageList.add((Object)thisEntry);
        }
        if (!storageList.isEmpty()) {
            compound.m_128365_("TraderPos", (Tag)storageList);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        this.readPositions(compound);
        super.m_142466_(compound);
    }

    private void readPositions(CompoundTag compound) {
        if (compound.m_128441_("TraderPos")) {
            this.positions = new ArrayList<BlockPos>();
            ListTag storageList = compound.m_128437_("TraderPos", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisEntry = storageList.m_128728_(i);
                if (!thisEntry.m_128441_("x") || !thisEntry.m_128441_("y") || !thisEntry.m_128441_("z")) continue;
                BlockPos thisPos = new BlockPos(thisEntry.m_128451_("x"), thisEntry.m_128451_("y"), thisEntry.m_128451_("z"));
                this.positions.add(thisPos);
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

