/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.events.WalletDropEvent;
import io.github.lightman314.lightmanscurrency.api.misc.BlockProtectionHelper;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.advancements.date.DateTrigger;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.CapabilityEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.IEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.event.SPacketSyncEventUnlocks;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void pickupItem(EntityItemPickupEvent event) {
        WalletItem walletItem;
        WalletMenuBase container;
        ItemEntity ie = event.getItem();
        ItemStack pickupItem = ie.m_32055_();
        Player player = event.getEntity();
        if (ie.m_32063_() || !CoinAPI.API.IsAllowedInCoinContainer(pickupItem, false) || !EventHandler.matchesTarget(ie, (Entity)player)) {
            return;
        }
        ItemStack coinStack = event.getItem().m_32055_();
        WalletMenuBase activeContainer = null;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof WalletMenuBase && (container = (WalletMenuBase)abstractContainerMenu).isEquippedWallet()) {
            activeContainer = container;
        }
        boolean cancelEvent = false;
        ItemStack wallet = CoinAPI.API.getEquippedWallet(player);
        if (!wallet.m_41619_() && WalletItem.CanPickup(walletItem = (WalletItem)wallet.m_41720_())) {
            cancelEvent = true;
            coinStack = activeContainer != null ? activeContainer.PickupCoins(coinStack) : WalletItem.PickupCoin(wallet, coinStack);
        }
        if (event.isCancelable() && cancelEvent) {
            event.getItem().m_32045_(ItemStack.f_41583_);
            if (!coinStack.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)coinStack);
            }
            if (!player.m_9236_().f_46443_) {
                WalletItem.playCollectSound((LivingEntity)player, wallet);
            }
            event.setCanceled(true);
        }
    }

    public static boolean matchesTarget(ItemEntity ie, Entity entity) {
        CompoundTag data = ie.m_20240_(new CompoundTag());
        if (data.m_128441_("Owner")) {
            UUID target = data.m_128342_("Owner");
            return target.equals(entity.m_20148_());
        }
        return true;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        IOwnableBlock block;
        if (((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            return;
        }
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        Block block2 = state.m_60734_();
        if (block2 instanceof IOwnableBlock && !(block = (IOwnableBlock)block2).canBreak(event.getPlayer(), level, event.getPos(), state)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (((Boolean)LCConfig.SERVER.anarchyMode.get()).booleanValue()) {
            return;
        }
        Level level = event.getEntity().m_9236_();
        BlockState state = event.getState();
        Block block = event.getState().m_60734_();
        if (block instanceof IOwnableBlock) {
            IOwnableBlock block2 = (IOwnableBlock)block;
            event.getPosition().ifPresent(pos -> {
                if (!block2.canBreak(event.getEntity(), (LevelAccessor)level, (BlockPos)pos, state)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(CurrencyCapabilities.ID_WALLET, WalletCapability.createProvider(player));
            event.addCapability(CurrencyCapabilities.ID_EVENT_TRACKER, CapabilityEventUnlocks.createProvider(player));
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        EventHandler.sendWalletUpdatePacket(event.getEntity());
        EventHandler.sendEventUpdatePacket(event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SyncedConfigFile.playerJoined(player2);
        }
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        EventHandler.sendWalletUpdatePacket(target, LightmansCurrencyPacketHandler.getTarget(player));
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        IWalletHandler oldHandler = WalletCapability.lazyGetWalletHandler((Entity)oldPlayer);
        IWalletHandler newHandler = WalletCapability.lazyGetWalletHandler((Entity)event.getEntity());
        if (oldHandler != null && newHandler != null) {
            newHandler.setWallet(oldHandler.getWallet());
            newHandler.setVisible(oldHandler.visible());
        }
        IEventUnlocks oldEventHandler = CapabilityEventUnlocks.getCapability(oldPlayer);
        IEventUnlocks newEventHandler = CapabilityEventUnlocks.getCapability(event.getEntity());
        if (oldEventHandler != null && newEventHandler != null) {
            newEventHandler.sync(oldEventHandler.getUnlockedList());
        }
        oldPlayer.invalidateCaps();
    }

    @SubscribeEvent
    public static void playerChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        EventHandler.sendWalletUpdatePacket(player);
        EventHandler.sendEventUpdatePacket(player);
    }

    private static void sendWalletUpdatePacket(Entity entity, PacketDistributor.PacketTarget target) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
        if (walletHandler != null) {
            new SPacketSyncWallet(entity.m_19879_(), walletHandler.getWallet(), walletHandler.visible()).sendToTarget(target);
        }
    }

    private static void sendWalletUpdatePacket(Player player) {
        EventHandler.sendWalletUpdatePacket((Entity)player, LightmansCurrencyPacketHandler.getTarget(player));
    }

    private static void sendEventUpdatePacket(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        IEventUnlocks eventUnlocks = CapabilityEventUnlocks.getCapability(player);
        if (eventUnlocks != null) {
            new SPacketSyncEventUnlocks(eventUnlocks.getUnlockedList()).sendTo(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDrops(LivingDropsEvent event) {
        IWalletHandler walletHandler;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        if (!livingEntity.m_5833_() && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)livingEntity)) != null) {
            ItemStack walletStack = walletHandler.getWallet();
            if (walletStack.m_41619_()) {
                return;
            }
            List<ItemStack> drops = new ArrayList<ItemStack>();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                boolean keepWallet = ModGameRules.safeGetCustomBool(player.m_9236_(), ModGameRules.KEEP_WALLET, false);
                if (!LCCurios.hasWalletSlot((LivingEntity)player) && player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                    keepWallet = true;
                }
                int coinDropPercent = ModGameRules.safeGetCustomInt(player.m_9236_(), ModGameRules.COIN_DROP_PERCENT, 0);
                SimpleContainer walletInventory = WalletItem.getWalletInventory(walletStack);
                WalletDropEvent wde = new WalletDropEvent(player, walletHandler, (Container)walletInventory, event.getSource(), keepWallet, coinDropPercent);
                if (MinecraftForge.EVENT_BUS.post((Event)wde)) {
                    return;
                }
                drops = wde.getDrops();
                walletHandler.setWallet(wde.getWalletStack());
            } else {
                drops.add(walletStack);
                walletHandler.setWallet(ItemStack.f_41583_);
            }
            if (((Boolean)LCConfig.SERVER.walletDropsManualSpawn.get()).booleanValue()) {
                for (ItemEntity entity : EventHandler.turnIntoEntities(livingEntity, drops)) {
                    livingEntity.m_9236_().m_7967_((Entity)entity);
                }
            } else {
                event.getDrops().addAll(EventHandler.turnIntoEntities(livingEntity, drops));
            }
        }
    }

    private static List<ItemEntity> turnIntoEntities(@Nonnull LivingEntity entity, @Nonnull List<ItemStack> list) {
        ArrayList<ItemEntity> result = new ArrayList<ItemEntity>();
        for (ItemStack stack : list) {
            ItemEntity item = new ItemEntity(entity.m_9236_(), entity.m_20182_().f_82479_, entity.m_20182_().f_82480_ + 1.0, entity.m_20182_().f_82481_, stack);
            item.m_32060_();
            result.add(item);
        }
        return result;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onWalletDrop(@Nonnull WalletDropEvent event) {
        if (event.keepWallet) {
            event.addDrops(EventHandler.getWalletDrops(event, event.coinDropPercent));
        } else if (!LCCurios.hasWalletSlot((LivingEntity)event.getEntity())) {
            event.addDrop(event.getWalletStack());
            event.setWalletStack(ItemStack.f_41583_);
        }
    }

    private static List<ItemStack> getWalletDrops(@Nonnull WalletDropEvent event, int coinDropPercent) {
        if (coinDropPercent <= 0) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Container walletInventory = event.getWalletInventory();
        IMoneyHandler walletHandler = MoneyAPI.API.GetContainersMoneyHandler(walletInventory, drops::add, IClientTracker.entityWrapper((Entity)event.getEntity()));
        MoneyView walletFunds = walletHandler.getStoredMoney();
        for (MoneyValue value : walletFunds.allValues()) {
            MoneyValue takeAmount;
            if (!(value instanceof CoinValue) || (takeAmount = value.percentageOfValue(coinDropPercent)).isEmpty() || !(takeAmount instanceof CoinValue)) continue;
            CoinValue coinsToDrop = (CoinValue)takeAmount;
            if (!walletHandler.extractMoney(takeAmount, true).isEmpty()) continue;
            walletHandler.extractMoney(takeAmount, false);
            drops.addAll(coinsToDrop.getAsSeperatedItemList());
        }
        return drops;
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        Player player;
        IEventUnlocks eventHandler;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)livingEntity);
        if (walletHandler != null) {
            walletHandler.tick();
            if (walletHandler.isDirty()) {
                new SPacketSyncWallet(livingEntity.m_19879_(), walletHandler.getWallet(), walletHandler.visible()).sendToTarget(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity));
                walletHandler.clean();
            }
        }
        if (livingEntity instanceof Player && (eventHandler = CapabilityEventUnlocks.getCapability(player = (Player)livingEntity)) != null && eventHandler.isDirty()) {
            EventHandler.sendEventUpdatePacket(player);
            eventHandler.clean();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void serverStart(ServerStartedEvent event) {
        ConfigFile.loadServerFiles(ConfigFile.LoadPhase.GAME_START);
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.haveTime()) {
            ProfilerFiller filler = event.getServer().m_129905_();
            filler.m_6180_("Date Trigger Tick");
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                DateTrigger.INSTANCE.trigger(player);
            }
            filler.m_7238_();
        }
    }

    @SubscribeEvent
    public static void treeGrowEvent(SaplingGrowTreeEvent event) {
        try {
            Feature feature;
            Holder holder = event.getFeature();
            if (holder != null && (feature = ((ConfiguredFeature)holder.m_203334_()).f_65377_()) instanceof AbstractHugeMushroomFeature) {
                AbstractHugeMushroomFeature feature2 = (AbstractHugeMushroomFeature)feature;
                LevelAccessor level = event.getLevel();
                BlockPos center = event.getPos();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                int radius = 3;
                int height = 13;
                for (int y = 0; y <= 13; ++y) {
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            pos.m_122154_((Vec3i)center, x, y, z);
                            BlockState state = level.m_8055_((BlockPos)pos);
                            if (!BlockProtectionHelper.ShouldProtect(state, level.m_7702_((BlockPos)pos))) continue;
                            LightmansCurrency.LogInfo("Protected block detected at " + pos.m_123344_() + " which is within the potential growth area of a " + feature2.getClass().getName() + " attempting to grow at " + center.m_123344_() + "\nGrowth will be cancelled!");
                            event.setCanceled(true);
                            return;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

