/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util.text_inputs;

import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class FloatParser
implements Function<String, Float>,
Predicate<String> {
    public static final FloatParser DEFAULT = FloatParser.builder().build();
    private final Supplier<Float> minValue;
    private final Supplier<Float> maxValue;
    private final Supplier<Float> emptyValue;

    private FloatParser(Builder builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.emptyValue = builder.emptyValue;
    }

    @Override
    public Float apply(String text) {
        return Float.valueOf(MathUtil.clamp(NumberUtil.GetFloatValue(text, this.emptyValue.get().floatValue()), this.minValue.get().floatValue(), this.maxValue.get().floatValue()));
    }

    @Override
    public boolean test(String s) {
        if (NumberUtil.IsFloatOrEmpty(s)) {
            float value = this.apply(s).floatValue();
            return value >= this.minValue.get().floatValue() && value <= this.maxValue.get().floatValue();
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<Float> minValue = () -> Float.valueOf(-3.4028235E38f);
        private Supplier<Float> maxValue = () -> Float.valueOf(Float.MAX_VALUE);
        private Supplier<Float> emptyValue = () -> Float.valueOf(0.0f);

        private Builder() {
        }

        public Builder min(float minValue) {
            this.minValue = () -> Float.valueOf(minValue);
            return this;
        }

        public Builder min(Supplier<Float> minValue) {
            this.minValue = Objects.requireNonNull(minValue);
            return this;
        }

        public Builder max(float maxValue) {
            this.maxValue = () -> Float.valueOf(maxValue);
            return this;
        }

        public Builder max(Supplier<Float> maxValue) {
            this.maxValue = Objects.requireNonNull(maxValue);
            return this;
        }

        public Builder empty(float emptyValue) {
            this.emptyValue = () -> Float.valueOf(emptyValue);
            return this;
        }

        public Builder empty(Supplier<Float> emptyValue) {
            this.emptyValue = Objects.requireNonNull(emptyValue);
            return this;
        }

        private FloatParser build() {
            return new FloatParser(this);
        }

        public Consumer<TextInputUtil.Builder<Float>> consumer() {
            return b -> {
                FloatParser result = this.build();
                b.parser(result).filter(result);
            };
        }
    }
}

