/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemPositionData {
    public static final ItemPositionData EMPTY = new ItemPositionData(new PositionEntry[0]);
    private final List<PositionEntry> entries;

    public ItemPositionData(PositionEntry ... entries) {
        this.entries = ImmutableList.copyOf((Object[])entries);
    }

    public ItemPositionData(@Nonnull List<PositionEntry> entries) {
        this.entries = ImmutableList.copyOf(entries);
    }

    @Nonnull
    public static ItemPositionData parse(@Nonnull JsonObject json) throws JsonSyntaxException, IllegalArgumentException {
        String globalRotation = null;
        float globalScale = GsonHelper.m_13820_((JsonObject)json, (String)"Scale", (float)Float.NEGATIVE_INFINITY);
        int globalExtraCount = GsonHelper.m_13824_((JsonObject)json, (String)"ExtraCount", (int)0);
        if (globalExtraCount < 0) {
            throw new IllegalArgumentException("ExtraCount cannot be less than 0!");
        }
        Vector3f globalExtraOffset = new Vector3f(GsonHelper.m_13820_((JsonObject)json, (String)"offsetX", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"offsetY", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"offsetZ", (float)0.0f));
        if (json.has("RotationType") && RotationHandler.getRotationHandler(globalRotation = GsonHelper.m_13906_((JsonObject)json, (String)"RotationType")) == null) {
            throw new IllegalArgumentException("'" + globalRotation + "' is not a valid RotationType!");
        }
        JsonArray entryList = GsonHelper.m_13933_((JsonObject)json, (String)"Entries");
        ArrayList<PositionEntry> entries = new ArrayList<PositionEntry>();
        for (int i = 0; i < entryList.size(); ++i) {
            JsonObject entryData = GsonHelper.m_13918_((JsonElement)entryList.get(i), (String)("Entry #" + (i + 1)));
            JsonObject positionData = GsonHelper.m_13930_((JsonObject)entryData, (String)"Position");
            Vector3f startPosition = new Vector3f(GsonHelper.m_13915_((JsonObject)positionData, (String)"x"), GsonHelper.m_13915_((JsonObject)positionData, (String)"y"), GsonHelper.m_13915_((JsonObject)positionData, (String)"z"));
            int extraCount = GsonHelper.m_13824_((JsonObject)positionData, (String)"ExtraCount", (int)globalExtraCount);
            Vector3f extraOffset = new Vector3f();
            if (extraCount != 0) {
                if (extraCount < 0) {
                    throw new IllegalArgumentException("ExtraCount cannot be less than 0!");
                }
                extraOffset = new Vector3f(GsonHelper.m_13820_((JsonObject)positionData, (String)"offsetX", (float)globalExtraOffset.x), GsonHelper.m_13820_((JsonObject)positionData, (String)"offsetY", (float)globalExtraOffset.y), GsonHelper.m_13820_((JsonObject)positionData, (String)"offsetZ", (float)globalExtraOffset.z));
                if (extraOffset.x == 0.0f && extraOffset.y == 0.0f && extraOffset.z == 0.0f) {
                    throw new IllegalArgumentException("offsetX/Y/Z is not defined or has all values equal zero!");
                }
            }
            float scale = globalScale != Float.NEGATIVE_INFINITY ? GsonHelper.m_13820_((JsonObject)entryData, (String)"Scale", (float)globalScale) : GsonHelper.m_13820_((JsonObject)entryData, (String)"Scale", (float)1.0f);
            String rotationType = globalRotation != null ? GsonHelper.m_13851_((JsonObject)entryData, (String)"RotationType", (String)globalRotation) : GsonHelper.m_13906_((JsonObject)entryData, (String)"RotationType");
            RotationHandler rotationHandler = RotationHandler.getRotationHandler(rotationType);
            if (rotationHandler == null) {
                throw new IllegalArgumentException("'" + rotationType + "' is not a valid RotationType!");
            }
            entries.add(new PositionEntry(startPosition, extraCount, extraOffset, scale, rotationHandler));
        }
        return new ItemPositionData(entries);
    }

    @Nullable
    private PositionEntry safeGetEntry(int index) {
        if (index < 0 || index >= this.entries.size()) {
            return null;
        }
        return this.entries.get(index);
    }

    @Nonnull
    public List<Vector3f> getPositions(BlockState state, int index) {
        FacingData facing;
        PositionEntry entry = this.safeGetEntry(index);
        if (entry == null) {
            return new ArrayList<Vector3f>();
        }
        Block block = state.m_60734_();
        if (block instanceof IRotatableBlock) {
            IRotatableBlock rb = (IRotatableBlock)block;
            facing = new FacingData(rb.getFacing(state));
        } else {
            facing = new FacingData();
        }
        ArrayList<Vector3f> results = new ArrayList<Vector3f>();
        Vector3f currentPos = new Vector3f((Vector3fc)entry.position);
        results.add(facing.handle(currentPos));
        for (int i = 0; i < entry.extraCount; ++i) {
            currentPos.add((Vector3fc)entry.extraOffset);
            results.add(facing.handle(currentPos));
        }
        return results;
    }

    @Nonnull
    public List<Quaternionf> getRotation(BlockState state, int index, float partialTicks) {
        PositionEntry entry = this.safeGetEntry(index);
        if (entry == null) {
            return ImmutableList.of();
        }
        return entry.rotationHandler.rotate(state, partialTicks);
    }

    public float getScale(int index) {
        PositionEntry entry = this.safeGetEntry(index);
        if (entry == null) {
            return 1.0f;
        }
        return entry.scale;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public record PositionEntry(Vector3f position, int extraCount, Vector3f extraOffset, float scale, RotationHandler rotationHandler) {
    }

    private static final class FacingData {
        final Vector3f forward;
        final Vector3f right;
        final Vector3f up;
        final Vector3f offset;

        FacingData() {
            this.forward = MathUtil.getZP();
            this.right = MathUtil.getXP();
            this.up = MathUtil.getYP();
            this.offset = new Vector3f();
        }

        FacingData(Direction facing) {
            this.forward = IRotatableBlock.getForwardVect(facing);
            this.right = IRotatableBlock.getRightVect(facing);
            this.up = MathUtil.getYP();
            this.offset = IRotatableBlock.getOffsetVect(facing);
        }

        Vector3f handle(Vector3f position) {
            Vector3f x = MathUtil.VectorMult(this.right, position.x);
            Vector3f y = MathUtil.VectorMult(this.up, position.y);
            Vector3f z = MathUtil.VectorMult(this.forward, position.z);
            return MathUtil.VectorAdd(x, y, z, this.offset);
        }
    }
}

