/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DropdownWidget
extends EasyWidgetWithChildren
implements IMouseListener {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/dropdown.png");
    public static final int HEIGHT = 12;
    boolean open = false;
    int currentlySelected;
    private final List<Component> options;
    private final Consumer<Integer> onSelect;
    private final Function<Integer, Boolean> optionActive;
    List<DropdownButton> optionButtons = new ArrayList<DropdownButton>();

    public void setCurrentlySelected(int currentlySelected) {
        this.currentlySelected = MathUtil.clamp(currentlySelected, 0, this.options.size() - 1);
    }

    private DropdownWidget(@Nonnull Builder builder) {
        super(builder);
        this.options = ImmutableList.copyOf(builder.options);
        this.currentlySelected = MathUtil.clamp(builder.selected, 0, this.options.size() - 1);
        this.onSelect = builder.action;
        this.optionActive = builder.activeCheck;
    }

    @Override
    public boolean addChildrenBeforeThis() {
        return true;
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        this.optionButtons = new ArrayList<DropdownButton>();
        for (int i = 0; i < this.options.size(); ++i) {
            int index = i;
            int yOff = 12 + i * 12;
            DropdownButton button = this.addChild(((DropdownButton.Builder)DropdownButton.builder().position(area.pos.offset(0, yOff))).width(this.f_93618_).text(this.options.get(i)).pressAction(() -> this.OnSelect(index)).build());
            this.optionButtons.add(button);
            this.optionButtons.get((int)i).f_93624_ = this.open;
        }
    }

    @Override
    public void renderTick() {
        if (this.open) {
            for (int i = 0; i < this.optionButtons.size(); ++i) {
                this.optionButtons.get((int)i).f_93623_ = this.optionActive.apply(i) != false && i != this.currentlySelected;
            }
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        int offset;
        int n = offset = this.f_93622_ ? this.f_93619_ : 0;
        if (!this.f_93623_) {
            gui.setColor(0.5f, 0.5f, 0.5f);
        } else {
            gui.resetColor();
        }
        gui.blitHorizSplit(GUI_TEXTURE, 0, 0, this.f_93618_, this.f_93619_, 0, offset, 256, 12);
        gui.drawString(this.fitString(gui, this.options.get(this.currentlySelected).getString()), 2, 2, 0x404040);
        gui.resetColor();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int click) {
        if (this.f_93623_ && this.f_93624_) {
            if (this.m_93680_(mouseX, mouseY) && this.m_7972_(click)) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.open = !this.open;
                this.optionButtons.forEach(button -> {
                    button.f_93624_ = this.open;
                });
                return true;
            }
            if (this.open && !this.isOverChild(mouseX, mouseY)) {
                this.open = false;
                this.optionButtons.forEach(button -> {
                    button.f_93624_ = false;
                });
            }
        }
        return false;
    }

    private boolean isOverChild(double mouseX, double mouseY) {
        for (DropdownButton b : this.optionButtons) {
            if (!b.m_5953_(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    private void OnSelect(int index) {
        if (index < 0 || index >= this.optionButtons.size()) {
            return;
        }
        this.currentlySelected = index;
        this.onSelect.accept(index);
        this.open = false;
        this.optionButtons.forEach(b -> {
            b.f_93624_ = false;
        });
    }

    private String fitString(EasyGuiGraphics gui, String text) {
        if (gui.font.m_92895_(text) <= this.f_93618_ - 14) {
            return text;
        }
        while (gui.font.m_92895_(text + "...") > this.f_93618_ - 14 && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "...";
    }

    @Override
    protected boolean m_7972_(int button) {
        return button == 0;
    }

    @Override
    public void m_7435_(@Nonnull SoundManager manager) {
        EasyButton.playClick(manager);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private final List<Component> options = new ArrayList<Component>();
        private int selected = 0;
        private Consumer<Integer> action = i -> {};
        private Function<Integer, Boolean> activeCheck = i -> true;

        private Builder() {
            super(20, 12);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder option(Component option) {
            this.options.add(option);
            return this;
        }

        public Builder option(TextEntry option) {
            this.options.add((Component)option.get(new Object[0]));
            return this;
        }

        public Builder options(@Nonnull List<Component> options) {
            this.options.addAll(options);
            return this;
        }

        public Builder selected(int selected) {
            this.selected = selected;
            return this;
        }

        public Builder selectAction(Consumer<Integer> action) {
            this.action = action;
            return this;
        }

        public Builder activeCheck(Function<Integer, Boolean> activeCheck) {
            this.activeCheck = activeCheck;
            return this;
        }

        public DropdownWidget build() {
            return new DropdownWidget(this);
        }
    }
}

