/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class TradeButton
extends EasyButton
implements ITooltipSource {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/trade.png");
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 18;
    public static final int TEMPLATE_WIDTH = 212;
    public static final int BUTTON_HEIGHT = 18;
    private final Supplier<TradeData> tradeSource;
    private final Supplier<TradeContext> contextSource;
    private final BiFunction<TraderData, TradeData, Boolean> isSelected;
    private final BiFunction<TraderData, TradeData, List<Component>> extraTooltips;
    private final boolean displayOnly;

    public TradeData getTrade() {
        return this.tradeSource.get();
    }

    public TradeRenderManager<?> getTradeRenderer() {
        TradeData trade = this.getTrade();
        if (trade != null) {
            return trade.getButtonRenderer();
        }
        return null;
    }

    public TradeContext getContext() {
        return this.contextSource.get();
    }

    private TradeButton(@Nonnull Builder builder) {
        super(builder);
        this.tradeSource = builder.trade;
        this.contextSource = builder.context;
        this.displayOnly = builder.displayOnly;
        this.isSelected = builder.isSelected;
        this.extraTooltips = builder.extraTooltips;
        this.recalculateSize();
    }

    private void recalculateSize() {
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr != null) {
            TradeContext context = this.getContext();
            this.m_93674_(tr.tradeButtonWidth(context));
        }
    }

    @Deprecated
    public void move(int x, int y) {
        this.m_264152_(x, y);
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        if (context == null) {
            return;
        }
        boolean selected = this.isSelected.apply(context.getTrader(), (TradeData)tr.trade);
        boolean hovered = !context.isStorageMode && !this.displayOnly && this.f_93622_;
        this.recalculateSize();
        this.renderBackground(gui, hovered, selected);
        LazyOptional<ScreenPosition> arrowPosOptional = tr.arrowPosition(context);
        arrowPosOptional.ifPresent(arrowPos -> this.renderArrow(gui, (ScreenPosition)arrowPos, hovered, selected));
        try {
            tr.renderAdditional(this, gui, context);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error on additional Trade Button rendering.", e);
        }
        this.renderAlert(gui, tr.alertPosition(context), tr.getAlertData(context), hovered);
        this.renderDisplays(gui, tr, context);
        gui.resetColor();
    }

    private void renderBackground(@Nonnull EasyGuiGraphics gui, boolean isHovered, boolean selected) {
        int xRend;
        int vOffset;
        if (this.f_93618_ < 8) {
            LightmansCurrency.LogError("Cannot renderBG a trade button that is less than 8 pixels wide!");
            return;
        }
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int n = vOffset = isHovered ? 18 : 0;
        if (selected) {
            vOffset += 36;
        }
        gui.blit(GUI_TEXTURE, 0, 0, 0, vOffset, 4, 18);
        for (int xOff = 4; xOff < this.f_93618_ - 4; xOff += xRend) {
            xRend = Math.min(this.f_93618_ - 4 - xOff, 204);
            gui.blit(GUI_TEXTURE, xOff, 0, 4, vOffset, xRend, 18);
        }
        gui.blit(GUI_TEXTURE, this.f_93618_ - 4, 0, 208, vOffset, 4, 18);
    }

    private void renderArrow(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition position, boolean isHovered, boolean selected) {
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int vOffset = isHovered || selected ? 18 : 0;
        gui.blit(GUI_TEXTURE, position, 212, vOffset, 22, 18);
    }

    private void renderAlert(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition position, @Nullable List<AlertData> alerts, boolean isHovered) {
        if (alerts == null || alerts.isEmpty()) {
            return;
        }
        alerts.sort(AlertData::compare);
        alerts.get(0).setShaderColor(gui, this.f_93623_ ? 1.0f : 0.5f, isHovered);
        gui.blit(GUI_TEXTURE, position, 234, 0, 22, 18);
    }

    public void renderDisplays(EasyGuiGraphics gui, TradeRenderManager<?> tr, TradeContext context) {
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(tr, context)) {
            ((DisplayEntry)display.getFirst()).render(gui, 0, 0, (DisplayData)display.getSecond());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(tr, context)) {
            ((DisplayEntry)display.getFirst()).render(gui, 0, 0, (DisplayData)display.getSecond());
        }
    }

    @Override
    public void renderTooltip(EasyGuiGraphics gui) {
        List<AlertData> alerts;
        if (!this.isMouseOver(gui.mousePos)) {
            return;
        }
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        if (context == null) {
            return;
        }
        int mouseX = gui.mousePos.x;
        int mouseY = gui.mousePos.y;
        ArrayList<Component> tooltips = new ArrayList<Component>();
        List<Component> extra = this.extraTooltips.apply(context.getTrader(), (TradeData)tr.trade);
        if (extra != null && !extra.isEmpty()) {
            tooltips.addAll(extra);
        }
        this.tryAddTooltip(tooltips, tr.getAdditionalTooltips(context, mouseX - this.m_252754_(), mouseY - this.m_252907_()));
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(tr, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            if (((DisplayEntry)display.getFirst()).trySelfRenderTooltip(gui)) {
                return;
            }
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).getTooltip());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(tr, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            if (((DisplayEntry)display.getFirst()).trySelfRenderTooltip(gui)) {
                return;
            }
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).getTooltip());
        }
        if (this.isMouseOverAlert(mouseX, mouseY, tr, context) && (alerts = tr.getAlertData(context)) != null && !alerts.isEmpty()) {
            this.tryAddAlertTooltips(tooltips, alerts);
        }
        if (tooltips.isEmpty()) {
            return;
        }
        gui.renderComponentTooltip(tooltips);
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        return null;
    }

    private void tryAddTooltip(@Nonnull List<Component> tooltips, @Nullable List<Component> add) {
        if (add == null) {
            return;
        }
        tooltips.addAll(add);
    }

    private void tryAddAlertTooltips(@Nonnull List<Component> tooltips, @Nullable List<AlertData> alerts) {
        if (alerts == null) {
            return;
        }
        alerts.sort(AlertData::compare);
        for (AlertData alert : alerts) {
            tooltips.add((Component)alert.getFormattedMessage());
        }
    }

    public void HandleInteractionClick(int mouseX, int mouseY, int button, @Nonnull TradeInteractionHandler handler) {
        if (!this.f_93624_ || !this.m_5953_(mouseX, mouseY)) {
            return;
        }
        TradeData trade = this.getTrade();
        if (trade == null) {
            return;
        }
        TradeRenderManager<?> tr = trade.getButtonRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        TradeInteractionData data = new TradeInteractionData(mouseX - this.m_252754_(), mouseY - this.m_252907_(), button, Screen.m_96638_(), Screen.m_96637_(), Screen.m_96639_());
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(tr, context);
        for (int i = 0; i < inputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = inputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            handler.HandleTradeInputInteraction(context.getTrader(), trade, data, i);
            return;
        }
        List<Pair<DisplayEntry, DisplayData>> outputDisplays = TradeButton.getOutputDisplayData(tr, context);
        for (int i = 0; i < outputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = outputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.m_252754_(), this.m_252907_(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            handler.HandleTradeOutputInteraction(context.getTrader(), trade, data, i);
            return;
        }
        handler.HandleOtherTradeInteraction(context.getTrader(), trade, data);
    }

    public boolean isMouseOverAlert(int mouseX, int mouseY, TradeRenderManager<?> tr, TradeContext context) {
        ScreenPosition position = tr.alertPosition(context);
        int left = this.m_252754_() + position.x;
        int top = this.m_252907_() + position.y;
        return mouseX >= left && mouseX < left + 22 && mouseY >= top && mouseY < top + 18;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getInputDisplayData(TradeRenderManager<?> tr, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = tr.getInputDisplays(context);
        List<DisplayData> display = tr.inputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getOutputDisplayData(TradeRenderManager<?> tr, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = tr.getOutputDisplays(context);
        List<DisplayData> display = tr.outputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    @Override
    protected boolean m_7972_(int button) {
        TradeContext context = this.getContext();
        if (context == null || context.isStorageMode || this.displayOnly) {
            return false;
        }
        return super.m_7972_(button);
    }

    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        Supplier<TradeContext> context = () -> null;
        Supplier<TradeData> trade = () -> null;
        boolean displayOnly = false;
        BiFunction<TraderData, TradeData, Boolean> isSelected = (a, b) -> false;
        BiFunction<TraderData, TradeData, List<Component>> extraTooltips = (a, b) -> null;

        private Builder() {
            super(0, 18);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder context(Supplier<TradeContext> context) {
            this.context = context;
            return this;
        }

        public Builder trade(TradeData trade) {
            return this.trade(() -> trade);
        }

        public Builder trade(Supplier<TradeData> trade) {
            this.trade = trade;
            return this;
        }

        public Builder displayOnly() {
            this.displayOnly = true;
            return this;
        }

        public Builder selectedState(BiFunction<TraderData, TradeData, Boolean> isSelected) {
            this.isSelected = isSelected;
            return this;
        }

        public Builder extraTooltips(Component tooltip) {
            this.extraTooltips = (a, b) -> ImmutableList.of((Object)tooltip);
            return this;
        }

        public Builder extraTooltips(TextEntry tooltip) {
            this.extraTooltips = (a, b) -> tooltip.getAsList(new Object[0]);
            return this;
        }

        public Builder extraTooltips(List<Component> tooltip) {
            this.extraTooltips = (a, b) -> tooltip;
            return this;
        }

        public Builder extraTooltips(Supplier<List<Component>> tooltip) {
            this.extraTooltips = (a, b) -> (List)tooltip.get();
            return this;
        }

        public Builder extraTooltips(BiFunction<TraderData, TradeData, List<Component>> tooltip) {
            this.extraTooltips = tooltip;
            return this;
        }

        public TradeButton build() {
            return new TradeButton(this);
        }
    }
}

