/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class DisplayEntry {
    private final List<Component> tooltip;

    @Deprecated
    protected DisplayEntry() {
        this.tooltip = null;
    }

    protected DisplayEntry(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    protected final Font getFont() {
        Minecraft m = Minecraft.m_91087_();
        return m.f_91062_;
    }

    @Nonnull
    public List<Component> getTooltip() {
        if (this.tooltip == null) {
            return new ArrayList<Component>();
        }
        return this.tooltip;
    }

    public boolean trySelfRenderTooltip(@Nonnull EasyGuiGraphics gui) {
        return false;
    }

    public abstract void render(EasyGuiGraphics var1, int var2, int var3, DisplayData var4);

    public abstract boolean isMouseOver(int var1, int var2, DisplayData var3, int var4, int var5);

    public static DisplayEntry of(ItemStack item, int count) {
        return new ItemEntry(item, count, null, null);
    }

    public static DisplayEntry of(ItemStack item, int count, Consumer<List<Component>> tooltipEditor) {
        return new ItemEntry(item, count, null, tooltipEditor);
    }

    public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip) {
        return new ItemEntry(item, count, tooltip, null);
    }

    public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip, Pair<ResourceLocation, ResourceLocation> background) {
        return new ItemAndBackgroundEntry(item, count, tooltip, null, background, ScreenPosition.ZERO);
    }

    public static DisplayEntry of(ItemStack item, int count, Consumer<List<Component>> tooltipEditor, Pair<ResourceLocation, ResourceLocation> background) {
        return new ItemAndBackgroundEntry(item, count, null, tooltipEditor, background, ScreenPosition.ZERO);
    }

    public static DisplayEntry of(ItemStack item, int count, List<Component> tooltip, Pair<ResourceLocation, ResourceLocation> background, ScreenPosition backgroundOffset) {
        return new ItemAndBackgroundEntry(item, count, tooltip, null, background, backgroundOffset);
    }

    public static DisplayEntry of(ItemStack item, int count, Consumer<List<Component>> tooltipEditor, Pair<ResourceLocation, ResourceLocation> background, ScreenPosition backgroundOffset) {
        return new ItemAndBackgroundEntry(item, count, null, tooltipEditor, background, backgroundOffset);
    }

    public static DisplayEntry of(Pair<ResourceLocation, ResourceLocation> background) {
        return new EmptySlotEntry(background, null);
    }

    public static DisplayEntry of(Pair<ResourceLocation, ResourceLocation> background, List<Component> tooltip) {
        return new EmptySlotEntry(background, tooltip);
    }

    public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format) {
        return new TextEntry(text, format, null, false);
    }

    public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format, boolean fullHitbox) {
        return new TextEntry(text, format, null, fullHitbox);
    }

    public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip) {
        return new TextEntry(text, format, tooltip, false);
    }

    public static DisplayEntry of(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip, boolean fullHitbox) {
        return new TextEntry(text, format, tooltip, fullHitbox);
    }

    public static DisplayEntry of(Component text, int color) {
        return new ScrollingTextEntry(text, color, 0, null);
    }

    public static DisplayEntry of(Component text, int color, int width) {
        return new ScrollingTextEntry(text, color, width, null);
    }

    public static DisplayEntry of(Component text, int color, List<Component> tooltip) {
        return new ScrollingTextEntry(text, color, 0, tooltip);
    }

    public static DisplayEntry of(Component text, int color, int width, List<Component> tooltip) {
        return new ScrollingTextEntry(text, color, width, tooltip);
    }

    public static DisplayEntry of(MoneyValue price) {
        return DisplayEntry.of(price, null, false);
    }

    public static DisplayEntry of(MoneyValue price, List<Component> additionalTooltips) {
        return DisplayEntry.of(price, additionalTooltips, false);
    }

    public static DisplayEntry of(MoneyValue price, List<Component> additionalTooltips, boolean tooltipOverride) {
        return price.getDisplayEntry(additionalTooltips, tooltipOverride);
    }

    private static class ItemEntry
    extends DisplayEntry {
        private final ItemStack item;
        private final Consumer<List<Component>> tooltipEditor;

        private ItemEntry(ItemStack item, int count, @Nullable List<Component> forcedTooltip, @Nullable Consumer<List<Component>> tooltipEditor) {
            super(forcedTooltip);
            this.item = item.m_41777_();
            this.item.m_41764_(count);
            this.tooltipEditor = tooltipEditor;
        }

        private int getTopLeft(int xOrY, int availableWidthOrHeight) {
            return xOrY + availableWidthOrHeight / 2 - 8;
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
            if (this.item.m_41619_()) {
                return;
            }
            gui.resetColor();
            int left = this.getTopLeft(x + area.xOffset(), area.width());
            int top = this.getTopLeft(y + area.yOffset(), area.height());
            gui.renderItem(this.item, left, top);
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = this.getTopLeft(x + area.xOffset(), area.width());
            int top = this.getTopLeft(y + area.yOffset(), area.height());
            return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
        }

        @Override
        public boolean trySelfRenderTooltip(@Nonnull EasyGuiGraphics gui) {
            if (this.tooltipEditor == null) {
                List<Component> tooltip = this.getTooltip();
                if (!tooltip.isEmpty()) {
                    EasyScreenHelper.RenderItemTooltip(gui, this.item, tooltip);
                    return true;
                }
                return false;
            }
            EasyScreenHelper.RenderItemTooltipWithModifiers(gui, this.item, this.tooltipEditor);
            return true;
        }
    }

    private static class ItemAndBackgroundEntry
    extends DisplayEntry {
        private final ItemStack item;
        private final Consumer<List<Component>> tooltipEditor;
        private final Pair<ResourceLocation, ResourceLocation> background;
        private final ScreenPosition backgroundOffset;

        private ItemAndBackgroundEntry(ItemStack item, int count, @Nullable List<Component> forcedTooltip, @Nullable Consumer<List<Component>> tooltipEditor, Pair<ResourceLocation, ResourceLocation> background, ScreenPosition backgroundOffset) {
            super(forcedTooltip);
            this.item = item.m_41777_();
            this.item.m_41764_(count);
            this.background = background;
            this.backgroundOffset = backgroundOffset;
            this.tooltipEditor = tooltipEditor;
        }

        private int getTopLeft(int xOrY, int availableWidthOrHeight) {
            return xOrY + availableWidthOrHeight / 2 - 8;
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
            if (this.item.m_41619_()) {
                return;
            }
            gui.resetColor();
            int left = this.getTopLeft(x + area.xOffset(), area.width());
            int top = this.getTopLeft(y + area.yOffset(), area.height());
            gui.renderSlotBackground(this.background, this.backgroundOffset.offset(left, top));
            gui.renderItem(this.item, left, top);
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = this.getTopLeft(x + area.xOffset(), area.width());
            int top = this.getTopLeft(y + area.yOffset(), area.height());
            return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
        }

        @Override
        public boolean trySelfRenderTooltip(@Nonnull EasyGuiGraphics gui) {
            if (this.tooltipEditor == null) {
                List<Component> tooltip = this.getTooltip();
                if (!tooltip.isEmpty()) {
                    EasyScreenHelper.RenderItemTooltip(gui, this.item, tooltip);
                    return true;
                }
                return false;
            }
            EasyScreenHelper.RenderItemTooltipWithModifiers(gui, this.item, this.tooltipEditor);
            return true;
        }
    }

    private static class EmptySlotEntry
    extends DisplayEntry {
        private final Pair<ResourceLocation, ResourceLocation> background;

        private EmptySlotEntry(Pair<ResourceLocation, ResourceLocation> background, List<Component> tooltip) {
            super(tooltip);
            this.background = background;
        }

        private int getTopLeft(int xOrY, int availableWidthOrHeight) {
            return xOrY + availableWidthOrHeight / 2 - 8;
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
            gui.resetColor();
            int left = this.getTopLeft(x + area.xOffset(), area.width());
            int top = this.getTopLeft(y + area.yOffset(), area.height());
            gui.renderSlotBackground(this.background, left, top);
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = this.getTopLeft(x + area.xOffset(), area.width());
            int top = this.getTopLeft(y + area.yOffset(), area.height());
            return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
        }
    }

    private static class TextEntry
    extends DisplayEntry {
        private final Component text;
        private final TextRenderUtil.TextFormatting format;
        private final boolean fullHitbox;

        private TextEntry(Component text, TextRenderUtil.TextFormatting format, List<Component> tooltip, boolean fullHitbox) {
            super(tooltip);
            this.text = text;
            this.format = format;
            this.fullHitbox = fullHitbox;
        }

        protected int getTextLeft(int x, int availableWidth) {
            if (this.format.centering().isCenter()) {
                return x + availableWidth / 2 - this.getTextWidth() / 2;
            }
            if (this.format.centering().isRight()) {
                return x + availableWidth - this.getTextWidth();
            }
            return x;
        }

        protected int getTextTop(int y, int availableHeight) {
            if (this.format.centering().isMiddle()) {
                int n = y + availableHeight / 2;
                Objects.requireNonNull(this.getFont());
                return n - 9 / 2;
            }
            if (this.format.centering().isBottom()) {
                Objects.requireNonNull(this.getFont());
                return y + availableHeight - 9;
            }
            return y;
        }

        protected int getTextWidth() {
            return this.getFont().m_92852_((FormattedText)this.text);
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
            if (this.text.getString().isBlank()) {
                return;
            }
            gui.resetColor();
            int left = this.getTextLeft(x + area.xOffset(), area.width());
            int top = this.getTextTop(y + area.yOffset(), area.height());
            gui.resetColor();
            gui.drawShadowed(this.text, left, top, this.format.color());
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int n;
            int width;
            int left = this.fullHitbox ? x + area.xOffset() : this.getTextLeft(x + area.xOffset(), area.width());
            int top = this.fullHitbox ? y + area.yOffset() : this.getTextTop(y + area.yOffset(), area.height());
            int n2 = width = this.fullHitbox ? area.width() : this.getTextWidth();
            if (this.fullHitbox) {
                n = area.height();
            } else {
                Objects.requireNonNull(this.getFont());
                n = 9;
            }
            int height = n;
            return mouseX >= left && mouseX < left + width && mouseY >= top && mouseY < top + height;
        }
    }

    private static class ScrollingTextEntry
    extends DisplayEntry {
        private final Component text;
        private final int color;
        private final int width;

        private ScrollingTextEntry(Component text, int color, int width, List<Component> tooltip) {
            super(tooltip);
            this.text = text;
            this.color = color;
            this.width = width;
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y, DisplayData area) {
            int left = x + area.xOffset();
            int top = y + area.yOffset();
            gui.drawScrollingString(this.text, left, top, area.width(), area.height(), this.color);
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = x + area.xOffset();
            int top = y + area.yOffset();
            return mouseX >= left && mouseX < left + area.width() && mouseY >= top && mouseY < top + area.height();
        }

        @Override
        @Nonnull
        public List<Component> getTooltip() {
            if (this.width > 0 && this.getFont().m_92852_((FormattedText)this.text) > this.width) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                tooltips.addAll(TooltipHelper.splitTooltips(this.text, 256, new ChatFormatting[0]));
                tooltips.addAll(super.getTooltip());
                return tooltips;
            }
            return super.getTooltip();
        }
    }
}

