/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TradeButtonArea
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipSource,
IEasyTickable {
    @Deprecated
    public static final Function<TradeData, Boolean> FILTER_VALID = TradeData::isValid;
    @Deprecated
    public static final Function<TradeData, Boolean> FILTER_ANY = trade -> true;
    private final Supplier<? extends ITraderSource> traderSource;
    private final Function<TraderData, TradeContext> getContext;
    private final BiFunction<TraderData, TradeData, Boolean> isSelected;
    private final TradeInteractionHandler interactionHandler;
    private final List<TradeButton> allButtons = new ArrayList<TradeButton>();
    private final Font font;
    private final BiConsumer<TraderData, TradeData> onPress;
    private final Predicate<TradeData> tradeFilter;
    private int scroll = 0;
    ScrollBarWidget scrollBar;
    private final boolean allowSearching;
    EditBox searchBox;
    private String lastSearch = "";
    private boolean hasTitlePosition = false;
    private ScreenPosition titlePosition = ScreenPosition.ZERO;
    private int titleWidth = 0;
    private boolean renderNameOnly = false;
    private ScreenArea searchBoxArea = ScreenArea.of(ScreenPosition.ZERO, 90, 12);
    private final BiFunction<TraderData, TradeData, List<Component>> extraTooltips;
    private final ScreenPosition scrollBarOffset;
    private int scrollBarHeight;

    private int actualTitleWidth() {
        return this.isSearchBoxRelevant() ? this.titleWidth - 90 : this.titleWidth;
    }

    @Deprecated
    public TradeButtonArea withTitle(ScreenPosition titlePosition, int titleWidth, boolean renderNameOnly) {
        this.hasTitlePosition = true;
        this.titlePosition = titlePosition;
        this.titleWidth = titleWidth;
        this.renderNameOnly = renderNameOnly;
        return this;
    }

    public boolean isSearchBoxRelevant() {
        return this.searchBox != null && this.searchBox.m_94213_();
    }

    @Deprecated
    public TradeButtonArea withScrollBarHeight(int height) {
        this.scrollBarHeight = height;
        return this;
    }

    public int getMinAvailableWidth() {
        return this.scrollBarOffset.x < 0 ? this.f_93618_ + this.scrollBarOffset.x : this.f_93618_;
    }

    public int getAvailableWidth() {
        return this.scrollBar.visible() ? (this.scrollBarOffset.x < 0 ? this.f_93618_ + this.scrollBarOffset.x : this.f_93618_) : this.f_93618_;
    }

    private TradeButtonArea(@Nonnull Builder builder) {
        super(builder);
        this.traderSource = builder.traderSource;
        this.getContext = builder.context;
        this.onPress = builder.pressAction;
        this.tradeFilter = builder.tradeFilter;
        this.extraTooltips = builder.extraTooltips;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        if (builder.titlePosition != null) {
            this.hasTitlePosition = true;
            this.titlePosition = builder.titlePosition;
            this.titleWidth = builder.titleWidth;
            this.renderNameOnly = builder.titleNameOnly;
        }
        this.allowSearching = builder.allowSearching;
        this.scrollBarOffset = builder.scrollBarOffset;
        this.scrollBarHeight = builder.scrollBarHeight > 0 ? builder.scrollBarHeight : this.f_93619_ - 5;
        this.isSelected = builder.selectionTrigger;
        this.interactionHandler = builder.interactionHandler;
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(area)).listener(this).build());
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(area.pos.offset(area.width + this.scrollBarOffset.x, this.scrollBarOffset.y))).height(this.scrollBarHeight).scrollable(this).build());
        if (this.hasTitlePosition && this.allowSearching) {
            this.searchBoxArea = ScreenArea.of(this.titlePosition.x + this.titleWidth - 90, this.titlePosition.y - 2, 90, 12);
            this.searchBox = this.addChild(new EditBox(this.font, this.searchBoxArea.pos.x + 2, this.searchBoxArea.pos.y + 2, this.searchBoxArea.width - 10, 10, (Component)LCText.GUI_TRADER_SEARCH_TRADES.get(new Object[0])));
            this.searchBox.m_94182_(false);
            this.searchBox.m_94151_(s -> {
                this.lastSearch = s;
            });
            this.tickSearchBox();
        }
        this.resetButtons();
    }

    @Nullable
    public TradeButton getHoveredButton(ScreenPosition mousePos) {
        for (TradeButton button : this.allButtons) {
            if (!button.m_5953_(mousePos.x, mousePos.y)) continue;
            return button;
        }
        return null;
    }

    public TraderData getTrader(int traderIndex) {
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return null;
        }
        List<TraderData> traders = source.getTraders();
        if (traderIndex < 0 || traderIndex >= traders.size()) {
            return null;
        }
        return traders.get(traderIndex);
    }

    public List<List<Pair<TraderData, TradeData>>> getTradesInRows(boolean search) {
        ArrayList<List<Pair<TraderData, TradeData>>> result = new ArrayList<List<Pair<TraderData, TradeData>>>();
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return new ArrayList<List<Pair<TraderData, TradeData>>>();
        }
        List<TraderData> traders = source.getTraders();
        int currentRowWidth = 0;
        ArrayList<Pair> currentRow = new ArrayList<Pair>();
        for (TraderData trader : traders) {
            TradeContext context = this.getContext.apply(trader);
            List<? extends TradeData> trades = trader.getTradeData();
            for (TradeData tradeData : trades) {
                if (!this.tradeFilter.test(tradeData) || !this.tradeMatchesSearch(source, tradeData, search)) continue;
                TradeRenderManager<?> trm = tradeData.getButtonRenderer();
                int tradeWidth = trm.tradeButtonWidth(context);
                if (currentRowWidth + tradeWidth > this.getMinAvailableWidth() && !currentRow.isEmpty()) {
                    result.add(currentRow);
                    currentRow = new ArrayList();
                    currentRowWidth = 0;
                }
                currentRow.add(Pair.of((Object)trader, (Object)tradeData));
                currentRowWidth += tradeWidth;
            }
        }
        result.add(currentRow);
        return result;
    }

    @Nonnull
    private String searchText() {
        return this.lastSearch;
    }

    private boolean tradeMatchesSearch(@Nonnull ITraderSource source, @Nonnull TradeData trade, boolean search) {
        if (!search || !this.allowSearching) {
            return true;
        }
        if (this.isSearchBoxRelevant() && !this.searchText().isBlank()) {
            return TraderAPI.API.FilterTrade(trade, this.searchText().toLowerCase());
        }
        return true;
    }

    public Pair<TraderData, TradeData> getTradeAndTrader(int displayIndex) {
        return this.getTradeAndTrader(this.scroll, displayIndex);
    }

    public Pair<TraderData, TradeData> getTradeAndTrader(int assumedScroll, int displayIndex) {
        ITraderSource source = this.traderSource.get();
        if (source == null) {
            return Pair.of(null, null);
        }
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows(true);
        for (int r = assumedScroll; r < rows.size(); ++r) {
            List<Pair<TraderData, TradeData>> row = rows.get(r);
            for (Pair<TraderData, TradeData> traderDataTradeDataPair : row) {
                if (displayIndex <= 0) {
                    return traderDataTradeDataPair;
                }
                --displayIndex;
            }
        }
        return Pair.of(null, null);
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        if (!this.hasValidTrade()) {
            MutableComponent mutableComponent = LCText.GUI_TRADER_NO_TRADES.get(new Object[0]);
            int n = this.f_93618_ / 2;
            int n2 = this.f_93619_ / 2;
            Objects.requireNonNull(gui.font);
            TextRenderUtil.drawCenteredText(gui, (Component)mutableComponent, n, n2 - 9 / 2, 0x404040);
        }
        if (this.hasTitlePosition) {
            ITraderSource ts = this.traderSource.get();
            if (ts == null) {
                return;
            }
            Component title = ts.getCustomTitle();
            if (title == null) {
                MutableComponent text = EasyText.empty();
                for (TraderData trader : ts.getTraders()) {
                    if (text.getString().isEmpty()) {
                        text.m_7220_((Component)(this.renderNameOnly ? trader.getName() : trader.getTitle()));
                        continue;
                    }
                    text.m_7220_((Component)LCText.GUI_SEPERATOR.get(new Object[0])).m_7220_((Component)(this.renderNameOnly ? trader.getName() : trader.getTitle()));
                }
                title = text;
            }
            gui.pushOffsetZero();
            gui.drawString(TextRenderUtil.fitString(title, this.actualTitleWidth()), this.titlePosition, 0x404040);
            if (this.isSearchBoxRelevant()) {
                gui.blit(ItemEditWidget.GUI_TEXTURE, this.searchBoxArea, 18, 0);
            }
            gui.popOffset();
        }
    }

    @Override
    public void renderTick() {
        this.validateScroll();
    }

    @Override
    public void tick() {
        if (this.allButtons.size() < this.requiredButtons()) {
            this.resetButtons();
        } else {
            this.repositionButtons();
        }
        this.tickSearchBox();
    }

    private void tickSearchBox() {
        if (this.searchBox != null) {
            ITraderSource source = this.traderSource.get();
            this.searchBox.m_94194_(source != null && source.showSearchBox());
        }
    }

    private void resetButtons() {
        this.allButtons.forEach(x$0 -> this.removeChild(x$0));
        this.allButtons.clear();
        int requiredButtons = this.requiredButtons();
        int i = 0;
        while (i < requiredButtons) {
            int di = i++;
            TradeButton newButton = this.addChild(((TradeButton.Builder)TradeButton.builder().pressAction(() -> this.OnTraderPress(di))).context(() -> this.getContext.apply((TraderData)this.getTradeAndTrader(di).getFirst())).trade(() -> (TradeData)this.getTradeAndTrader(di).getSecond()).selectedState(this.isSelected).extraTooltips(this.extraTooltips).build());
            this.allButtons.add(newButton);
        }
        this.repositionButtons();
    }

    private boolean hasValidTrade() {
        ITraderSource ts = this.traderSource.get();
        if (ts == null) {
            return false;
        }
        boolean count = false;
        List<TraderData> traders = ts.getTraders();
        for (TraderData trader : traders) {
            List<? extends TradeData> trades = trader.getTradeData();
            for (TradeData tradeData : trades) {
                if (tradeData == null || !this.tradeFilter.test(tradeData) || !this.tradeMatchesSearch(ts, tradeData, true)) continue;
                return true;
            }
        }
        return false;
    }

    private int requiredButtons() {
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows(false);
        int count = 0;
        int lines = this.fittableLines();
        for (int r = this.scroll; r < rows.size() && r < this.scroll + lines; ++r) {
            count += rows.get(r).size();
        }
        return count;
    }

    private int fittableLines() {
        return this.f_93619_ / 22;
    }

    private void repositionButtons() {
        int displayIndex = 0;
        int yOffset = 0;
        int fittableLines = this.fittableLines();
        List<List<Pair<TraderData, TradeData>>> rows = this.getTradesInRows(true);
        for (int line = 0; line < fittableLines && line + this.scroll < rows.size(); ++line) {
            int spacing;
            List<Pair<TraderData, TradeData>> row = rows.get(line + this.scroll);
            int visibleButtons = 0;
            int totalWidth = 0;
            for (Pair<TraderData, TradeData> trade : row) {
                if (trade.getFirst() == null || trade.getSecond() == null) continue;
                TradeContext context = this.getContext.apply((TraderData)trade.getFirst());
                ++visibleButtons;
                totalWidth += ((TradeData)trade.getSecond()).getButtonRenderer().tradeButtonWidth(context);
            }
            int xOffset = spacing = (this.getAvailableWidth() - totalWidth) / (visibleButtons + 1);
            for (Pair<TraderData, TradeData> trade : row) {
                if (displayIndex >= this.allButtons.size()) break;
                TradeButton button = this.allButtons.get(displayIndex);
                if (trade.getFirst() != null && trade.getSecond() != null) {
                    TradeContext context = this.getContext.apply((TraderData)trade.getFirst());
                    button.setPosition(this.getPosition().offset(xOffset, yOffset));
                    button.f_93624_ = true;
                    xOffset += ((TradeData)trade.getSecond()).getButtonRenderer().tradeButtonWidth(context) + spacing;
                } else {
                    button.f_93624_ = false;
                }
                ++displayIndex;
            }
            yOffset += 22;
        }
        for (int i = displayIndex; i < this.allButtons.size(); ++i) {
            this.allButtons.get((int)i).f_93624_ = false;
        }
    }

    private void OnTraderPress(int displayIndex) {
        if (this.onPress != null) {
            Pair<TraderData, TradeData> data = this.getTradeAndTrader(displayIndex);
            this.onPress.accept((TraderData)data.getFirst(), (TradeData)data.getSecond());
        }
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        if (this.hasTitlePosition) {
            int n = this.actualTitleWidth();
            Objects.requireNonNull(this.font);
            if (this.titlePosition.isMouseInArea(mouseX, mouseY, n, 9)) {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                ITraderSource ts = this.traderSource.get();
                if (ts == null) {
                    return null;
                }
                for (TraderData trader : ts.getTraders()) {
                    tooltips.add((Component)trader.getTitle());
                }
                return tooltips;
            }
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.allButtons.size(); ++i) {
            TradeButton b = this.allButtons.get(i);
            if (!b.m_5953_(mouseX, mouseY)) continue;
            Pair<TraderData, TradeData> traderPair = this.getTradeAndTrader(i);
            TradeContext context = this.getContext.apply((TraderData)traderPair.getFirst());
            if (context.isStorageMode) {
                if (this.interactionHandler == null) continue;
                b.HandleInteractionClick((int)mouseX, (int)mouseY, button, this.interactionHandler);
                return true;
            }
            return b.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        if (newScroll == this.scroll) {
            return;
        }
        this.scroll = MathUtil.clamp(newScroll, 0, this.getMaxScroll());
        this.resetButtons();
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.fittableLines(), this.getTradesInRows(true).size());
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasySizableBuilder<Builder> {
        private Supplier<ITraderSource> traderSource = () -> null;
        private Function<TraderData, TradeContext> context = t -> null;
        private BiConsumer<TraderData, TradeData> pressAction = (t, d) -> {};
        private Predicate<TradeData> tradeFilter = t -> true;
        @Nullable
        private ScreenPosition titlePosition = null;
        int titleWidth = 0;
        boolean titleNameOnly = false;
        boolean allowSearching = true;
        ScreenPosition scrollBarOffset = ScreenPosition.of(-9, 0);
        int scrollBarHeight = 0;
        BiFunction<TraderData, TradeData, Boolean> selectionTrigger = (t, d) -> false;
        @Nullable
        TradeInteractionHandler interactionHandler = null;
        BiFunction<TraderData, TradeData, List<Component>> extraTooltips = (a, b) -> null;

        private Builder() {
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder traderSource(Supplier<ITraderSource> source) {
            this.traderSource = source;
            return this;
        }

        public Builder context(Supplier<TradeContext> contextSource) {
            return this.context((TraderData t) -> (TradeContext)contextSource.get());
        }

        public Builder context(Function<TraderData, TradeContext> contextBuilder) {
            this.context = contextBuilder;
            return this;
        }

        public Builder pressAction(BiConsumer<TraderData, TradeData> pressAction) {
            this.pressAction = pressAction;
            return this;
        }

        public Builder tradeFilter(Predicate<TradeData> tradeFilter) {
            this.tradeFilter = tradeFilter;
            return this;
        }

        public Builder tradeFilter(@Nullable TraderData trader, ITraderStorageMenu menu) {
            if (trader != null) {
                return this.tradeFilter(trader.getStorageDisplayFilter(menu));
            }
            return this;
        }

        public Builder title(ScreenPosition titlePosition, int titleWidth, boolean renderNameOnly) {
            this.titlePosition = titlePosition;
            this.titleWidth = titleWidth;
            this.titleNameOnly = renderNameOnly;
            return this;
        }

        public Builder blockSearchBox() {
            this.allowSearching = false;
            return this;
        }

        public Builder scrollBarOffset(ScreenPosition offset) {
            this.scrollBarOffset = offset;
            return this;
        }

        public Builder scrollBarHeight(int height) {
            this.scrollBarHeight = height;
            return this;
        }

        public Builder selectedState(BiFunction<TraderData, TradeData, Boolean> selectedState) {
            this.selectionTrigger = selectedState;
            return this;
        }

        public Builder interactionHandler(TradeInteractionHandler handler) {
            this.interactionHandler = handler;
            return this;
        }

        public Builder extraTooltips(Component tooltip) {
            this.extraTooltips = (a, b) -> ImmutableList.of((Object)tooltip);
            return this;
        }

        public Builder extraTooltips(TextEntry tooltip) {
            this.extraTooltips = (a, b) -> tooltip.getAsList(new Object[0]);
            return this;
        }

        public Builder extraTooltips(List<Component> tooltip) {
            this.extraTooltips = (a, b) -> tooltip;
            return this;
        }

        public Builder extraTooltips(Supplier<List<Component>> tooltip) {
            this.extraTooltips = (a, b) -> (List)tooltip.get();
            return this;
        }

        public Builder extraTooltips(BiFunction<TraderData, TradeData, List<Component>> tooltip) {
            this.extraTooltips = tooltip;
            return this;
        }

        public TradeButtonArea build() {
            return new TradeButtonArea(this);
        }
    }
}

