/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class PriceFluctuationTab
extends TradeRuleSubTab<PriceFluctuation> {
    EditBox fluctuationInput;
    TimeInputWidget durationInput;

    public PriceFluctuationTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, PriceFluctuation.TYPE);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        this.fluctuationInput = this.addChild(TextInputUtil.intBuilder().position(screenArea.pos.offset(25, 9)).size(30, 20).maxLength(3).startingValue(rule == null ? 10 : rule.getFluctuation()).parser(IntParser.ONE_TO_ONE_HUNDRED).handler(this::onFluctuationChanged).build());
        this.durationInput = this.addChild(((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(63, 75))).unitRange(TimeUtil.TimeUnit.MINUTE, TimeUtil.TimeUnit.DAY).handler(this::onTimeSet).startTime(rule == null ? 86400000L : rule.getDuration()).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule == null) {
            return;
        }
        gui.pushOffset((AbstractWidget)this.fluctuationInput);
        gui.drawString((Component)LCText.GUI_PRICE_FLUCTUATION_LABEL.get(new Object[0]), this.fluctuationInput.m_5711_() + 4, 6, 0x404040);
        gui.popOffset();
        TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_PRICE_FLUCTUATION_INFO.get(rule.getFluctuation(), new TimeUtil.TimeData(((PriceFluctuation)this.getRule()).getDuration()).getShortString()), 10, this.screen.getXSize() - 20, 35, 0x404040);
    }

    void onFluctuationChanged(int newFluctuation) {
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule != null) {
            rule.setFluctuation(newFluctuation);
        }
        this.sendUpdateMessage(this.builder().setInt("Fluctuation", newFluctuation));
    }

    public void onTimeSet(TimeUtil.TimeData newTime) {
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule != null) {
            rule.setDuration(newTime.miliseconds);
        }
        this.sendUpdateMessage(this.builder().setLong("Duration", newTime.miliseconds));
    }
}

