/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.OwnerSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class OwnershipTab
extends SettingsSubTab {
    OwnerSelectionWidget ownerSelectionWidget;
    private boolean manualSelectionMode = false;
    EditBox playerOwnerInput;
    EasyButton setPlayerButton;
    EasyButton buttonToggleInputMode;

    public OwnershipTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_ALEX_HEAD;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_SETTINGS_OWNER.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("transferOwnership");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.playerOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 50, 160, 20, (Component)EasyText.empty()));
        this.playerOwnerInput.m_94199_(16);
        this.setPlayerButton = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 80))).width(160)).text(LCText.BUTTON_OWNER_SET_PLAYER).pressAction(this::setPlayerOwner)).addon(EasyAddonHelper.tooltip((Component)LCText.TOOLTIP_WARNING_CANT_BE_UNDONE.getWithStyle(ChatFormatting.YELLOW, ChatFormatting.BOLD)))).build());
        this.ownerSelectionWidget = this.addChild(((OwnerSelectionWidget.Builder)OwnerSelectionWidget.builder().position(screenArea.pos.offset(20, 27))).width(160).rows(5).selected(this::getCurrentOwner).handler(this::setOwner).oldWidget(this.ownerSelectionWidget).build());
        this.buttonToggleInputMode = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 25, 5))).pressAction(this::toggleInputMode)).icon(this::getModeIcon).addon(EasyAddonHelper.tooltip(this::getModeTooltip))).build());
        this.updateMode();
    }

    @Nullable
    protected OwnerData getCurrentOwner() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            return trader.getOwner();
        }
        return null;
    }

    protected void setOwner(@Nonnull Owner newOwner) {
        this.sendMessage(this.builder().setOwner("ChangeOwner", newOwner));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            gui.drawString((Component)LCText.GUI_OWNER_CURRENT.get(trader.getOwner().getName()), 20, 10, 0x404040);
        }
    }

    @Override
    public void tick() {
        if (this.manualSelectionMode) {
            this.setPlayerButton.f_93623_ = !this.playerOwnerInput.m_94155_().isBlank();
        }
    }

    private void setPlayerOwner(EasyButton button) {
        if (this.playerOwnerInput.m_94155_().isBlank()) {
            return;
        }
        this.sendMessage(this.builder().setString("ChangePlayerOwner", this.playerOwnerInput.m_94155_()));
        this.playerOwnerInput.m_94144_("");
    }

    private void toggleInputMode(EasyButton button) {
        this.manualSelectionMode = !this.manualSelectionMode;
        this.updateMode();
    }

    private void updateMode() {
        this.playerOwnerInput.f_93624_ = this.setPlayerButton.f_93624_ = this.manualSelectionMode;
        if (this.manualSelectionMode) {
            this.setPlayerButton.f_93623_ = !this.playerOwnerInput.m_94155_().isBlank();
        }
        this.ownerSelectionWidget.setVisible(!this.manualSelectionMode);
    }

    private IconData getModeIcon() {
        return this.manualSelectionMode ? IconData.of((ItemLike)Items.f_42116_) : IconUtil.ICON_ALEX_HEAD;
    }

    private Component getModeTooltip() {
        return this.manualSelectionMode ? LCText.TOOLTIP_OWNERSHIP_MODE_SELECTION.get(new Object[0]) : LCText.TOOLTIP_OWNERSHIP_MODE_MANUAL.get(new Object[0]);
    }
}

