/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class NameTab
extends SettingsSubTab
implements IMouseListener {
    private final ScreenArea iconArea;
    EditBox nameInput;
    EasyButton buttonSetName;
    EasyButton buttonResetName;
    EasyButton buttonPickupTrader;

    public NameTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
        ScreenArea screenArea = this.screen.getArea();
        this.iconArea = ScreenArea.of(screenArea.width / 2 - 8, 96, 16, 16);
    }

    private boolean iconEditable() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            return trader.showOnTerminal();
        }
        return false;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42614_);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_NAME.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 25, 160, 20, (Component)EasyText.empty()));
        this.nameInput.m_94199_(32);
        this.nameInput.m_94144_(trader.customName.get());
        this.buttonSetName = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 50))).width(74)).text(LCText.BUTTON_SETTINGS_CHANGE_NAME).pressAction(this::SetName)).build());
        this.buttonResetName = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(screenArea.width - 93, 50))).width(74)).text(LCText.BUTTON_SETTINGS_RESET_NAME).pressAction(this::ResetName)).build());
        this.buttonPickupTrader = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 118))).width(screenArea.width - 40)).text(LCText.BUTTON_TRADER_SETTINGS_PICKUP_TRADER).pressAction(this::PickupTrader)).addon(EasyAddonHelper.tooltips(this::getPickupTooltip, 256))).build());
        this.tick();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        gui.drawString((Component)LCText.GUI_NAME.get(new Object[0]), 20, 15, 0x404040);
        if (this.iconEditable()) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TRADER_SETTINGS_CUSTOM_ICON.get(new Object[0]), this.screen.getXSize() / 2, this.iconArea.y - 12, 0x404040);
            gui.blit(TraderScreen.GUI_TEXTURE, this.iconArea.pos.offset(-1, -1), 206, 0, 18, 18);
            IconData icon = trader.customIcon.get();
            if (icon != null) {
                icon.render(gui, this.iconArea.pos);
            }
        }
    }

    @Override
    public void tick() {
        boolean canChangeName = this.menu.hasPermission("changeName");
        this.nameInput.m_94186_(canChangeName);
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        this.buttonSetName.f_93623_ = !this.nameInput.m_94155_().contentEquals(trader.customName.get());
        this.buttonSetName.f_93624_ = canChangeName;
        this.buttonResetName.f_93623_ = trader.hasCustomName();
        this.buttonResetName.f_93624_ = canChangeName;
        TraderBlockEntity<?> be = trader.getBlockEntity();
        this.buttonPickupTrader.f_93624_ = be != null && be.supportsTraderPickup() && this.menu.hasPermission("breakTrader");
    }

    private void SetName(EasyButton button) {
        TraderData trader = this.menu.getTrader();
        if (trader == null) {
            return;
        }
        String customName = trader.customName.get();
        if (!customName.contentEquals(this.nameInput.m_94155_())) {
            this.sendMessage(this.builder().setString("ChangeName", this.nameInput.m_94155_()));
        }
    }

    private void ResetName(EasyButton button) {
        this.nameInput.m_94144_("");
        this.SetName(button);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.iconEditable() && this.iconArea.offsetPosition(this.screen.getCorner()).isMouseInArea(mouseX, mouseY)) {
            ItemStack heldItem = this.menu.getHeldItem();
            TraderData trader = this.menu.getTrader();
            if (trader != null) {
                this.sendMessage(this.builder().setCompound("ChangeIcon", trader.getIconForItem(heldItem).save()));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    private List<Component> getPickupTooltip() {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add((Component)LCText.TOOLTIP_TRADER_SETTINGS_PICKUP_TRADER.get(new Object[0]));
        if (LCAdminMode.isAdminPlayer(this.menu.getPlayer())) {
            result.add((Component)LCText.TOOLTIP_TRADER_SETTINGS_PICKUP_TRADER_ADVANCED.get(new Object[0]));
        }
        return result;
    }

    private void PickupTrader(EasyButton button) {
        this.sendMessage(this.builder().setBoolean("PickupTrader", Screen.m_96638_()));
    }
}

