/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.command;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CommandSettingsTab
extends SettingsSubTab {
    public CommandSettingsTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42256_);
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_COMMAND.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("editSettings");
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().sprite(IconAndButtonUtil.SPRITE_PLUS).position(screenArea.pos.offset(20, 30))).pressAction(() -> this.editPermissionLevel(1))).addon(EasyAddonHelper.activeCheck(() -> this.getPermissionLevel() < (Integer)LCConfig.SERVER.commandTraderMaxPermissionLevel.get()))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().sprite(IconAndButtonUtil.SPRITE_MINUS).position(screenArea.pos.offset(20, 40))).pressAction(() -> this.editPermissionLevel(-1))).addon(EasyAddonHelper.activeCheck(() -> this.getPermissionLevel() > 0))).build());
    }

    private int getPermissionLevel() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof CommandTrader) {
            CommandTrader trader = (CommandTrader)traderData;
            return trader.getPermissionLevel();
        }
        return 0;
    }

    private void editPermissionLevel(int delta) {
        this.sendMessage(this.builder().setInt("ChangePermissionLevel", this.getPermissionLevel() + delta));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.GUI_TRADER_SETTINGS_COMMAND_PERMISSION_LEVEL.get(this.getPermissionLevel()), 34, 35, 0x404040);
    }
}

