/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.slot_machine.SlotMachineRenderer;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine.SlotMachineEntryDisplayWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.slot_machine.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenStorage;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SlotMachineScreen
extends EasyMenuScreen<SlotMachineMenu>
implements IScrollable {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/slot_machine.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 222;
    public static final int ENTRY_ROWS = 2;
    public static final int ENTRY_COLUMNS = 2;
    public static final int ENTRIES_PER_PAGE = 4;
    public static final Sprite SPRITE_INFO = Sprite.SimpleSprite(GUI_TEXTURE, 176, 36, 10, 11);
    public static final Sprite SPRITE_INTERACT_1 = Sprite.SimpleSprite(GUI_TEXTURE, 176, 0, 18, 18);
    public static final Sprite SPRITE_INTERACT_5 = Sprite.SimpleSprite(GUI_TEXTURE, 194, 0, 18, 18);
    public static final Sprite SPRITE_INTERACT_10 = Sprite.SimpleSprite(GUI_TEXTURE, 212, 0, 18, 18);
    private boolean interactMode = true;
    private int scroll = 0;
    IconButton buttonOpenStorage;
    IconButton buttonCollectCoins;
    IconButton buttonOpenTerminal;
    EasyButton buttonInteract;
    EasyButton buttonInteract5;
    EasyButton buttonInteract10;
    EasyButton buttonInfo;
    ScrollListener scrollListener;
    private final ScreenPosition INFO_WIDGET_POSITION = ScreenPosition.of(160, 126);
    public final LazyWidgetPositioner rightEdgePositioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(), 176, 0, 20);
    private final SlotMachineRenderer slotRenderer = new SlotMachineRenderer(this);
    public final ScreenPosition SM_INFO_WIDGET = ScreenPosition.of(160, 8);

    public SlotMachineScreen(SlotMachineMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.resize(176, 222);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.buttonOpenStorage = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenStorage)).icon(IconUtil.ICON_STORAGE).addon(EasyAddonHelper.visibleCheck(() -> ((SlotMachineMenu)this.f_97732_).getTrader() != null && ((SlotMachineMenu)this.f_97732_).getTrader().hasPermission(((SlotMachineMenu)this.f_97732_).player, "openStorage")))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_OPEN_STORAGE))).build());
        this.buttonCollectCoins = this.addChild(IconAndButtonUtil.finishCollectCoinButton((IconButton.Builder)IconButton.builder().pressAction(this::CollectCoins), ((SlotMachineMenu)this.f_97732_).player, ((SlotMachineMenu)this.f_97732_)::getTrader));
        this.buttonOpenTerminal = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::OpenTerminal)).icon(IconUtil.ICON_BACK).addon(EasyAddonHelper.visibleCheck(this::showTerminalButton))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_TRADER_NETWORK_BACK))).build());
        this.buttonOpenTerminal.f_93624_ = this.showTerminalButton();
        this.rightEdgePositioner.clear();
        this.rightEdgePositioner.addWidgets(this.buttonOpenTerminal, this.buttonOpenStorage, this.buttonCollectCoins);
        this.addChild(this.rightEdgePositioner);
        this.buttonInteract = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(52, 107))).pressAction(() -> this.ExecuteTrade(1))).sprite(SPRITE_INTERACT_1).addon(EasyAddonHelper.tooltips(() -> this.getInteractionTooltip(1)))).addon(EasyAddonHelper.activeCheck(this::allowInteraction))).addon(EasyAddonHelper.visibleCheck(this::isInteractMode))).build());
        this.buttonInteract5 = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(29, 107))).pressAction(() -> this.ExecuteTrade(5))).sprite(SPRITE_INTERACT_5).addon(EasyAddonHelper.tooltips(() -> this.getInteractionTooltip(5)))).addon(EasyAddonHelper.activeCheck(this::allowInteraction))).addon(EasyAddonHelper.visibleCheck(this::isInteractMode))).build());
        this.buttonInteract10 = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(7, 107))).pressAction(() -> this.ExecuteTrade(10))).sprite(SPRITE_INTERACT_10).addon(EasyAddonHelper.tooltips(() -> this.getInteractionTooltip(10)))).addon(EasyAddonHelper.activeCheck(this::allowInteraction))).addon(EasyAddonHelper.visibleCheck(this::isInteractMode))).build());
        this.buttonInfo = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(this.SM_INFO_WIDGET))).pressAction(this::ToggleMode)).sprite(SPRITE_INFO).addon(EasyAddonHelper.tooltips(this::getInfoTooltip))).build());
        this.scrollListener = this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().area(screenArea)).listener(this).addon(EasyAddonHelper.activeCheck(this::isInfoMode))).build());
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                int displayIndex = y * 2 + x;
                this.addChild(((SlotMachineEntryDisplayWidget.Builder)((SlotMachineEntryDisplayWidget.Builder)SlotMachineEntryDisplayWidget.builder().position(screenArea.pos.offset(19 + x * 80, 10 + y * 46))).trader(((SlotMachineMenu)this.f_97732_)::getTrader).index(() -> this.getTrueIndex(displayIndex)).addon(EasyAddonHelper.visibleCheck(this::isInfoMode))).build());
            }
        }
        this.addChild(((ScrollBarWidget.Builder)((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(8, 10))).height(92).scrollable(this).addon(EasyAddonHelper.visibleCheck(this::isInfoMode))).build());
        this.addChild(this.slotRenderer);
    }

    private boolean isInteractMode() {
        return this.interactMode;
    }

    private boolean isInfoMode() {
        return !this.interactMode;
    }

    private void ToggleMode(EasyButton button) {
        if (((SlotMachineMenu)this.f_97732_).hasPendingReward()) {
            return;
        }
        boolean bl = this.interactMode = !this.interactMode;
        if (this.isInfoMode()) {
            this.validateScroll();
        }
    }

    private boolean allowInteraction() {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            TradeEvent.PreTradeEvent event = trader.runPreTradeEvent(trader.getTrade(0), ((SlotMachineMenu)this.f_97732_).getContext());
            return !((SlotMachineMenu)this.f_97732_).hasPendingReward() && trader.hasStock() && trader.hasValidTrade() && !event.isCanceled();
        }
        return false;
    }

    private boolean showTerminalButton() {
        if (((SlotMachineMenu)this.f_97732_).getTrader() != null) {
            return ((SlotMachineMenu)this.f_97732_).getTrader().showOnTerminal();
        }
        return false;
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.blit(TraderScreen.GUI_TEXTURE, this.INFO_WIDGET_POSITION, 244, 0, 10, 10);
        if (this.isInteractMode()) {
            this.slotRenderer.render(gui);
        }
        gui.drawString(this.f_169604_, 8, this.getYSize() - 94, 0x404040);
        Component valueText = ((SlotMachineMenu)this.f_97732_).getContext(null).getAvailableFunds().getRandomValueLine();
        gui.drawString(valueText, 160 - gui.font.m_92852_((FormattedText)valueText), this.getYSize() - 94, 0x404040);
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (this.INFO_WIDGET_POSITION.offset(this).isMouseInArea(gui.mousePos, 10, 10)) {
            gui.renderComponentTooltip(((SlotMachineMenu)this.f_97732_).getContext().getAvailableFundsDescription());
        }
    }

    @Nullable
    private List<Component> getInfoTooltip() {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            List<Component> info = trader.getSlotMachineInfo();
            if (this.isInfoMode()) {
                LCText.TOOLTIP_SLOT_MACHINE_TO_INTERACT.tooltip(info, new Object[0]);
            } else {
                LCText.TOOLTIP_SLOT_MACHINE_TO_INFO.tooltip(info, new Object[0]);
            }
            return info;
        }
        return null;
    }

    private List<Component> getInteractionTooltip(int count) {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            MoneyValue normalCost = trader.getPrice();
            MoneyValue currentCost = trader.runTradeCostEvent(trader.getTrade(0), ((SlotMachineMenu)this.f_97732_).getContext()).getCostResult();
            MutableComponent costText = currentCost.isFree() ? LCText.TOOLTIP_SLOT_MACHINE_COST_FREE.get(new Object[0]) : currentCost.getText();
            List<Component> result = count == 1 ? LCText.TOOLTIP_SLOT_MACHINE_ROLL_ONCE.get(count, costText) : LCText.TOOLTIP_SLOT_MACHINE_ROLL_MULTI.get(count, costText);
            if (!currentCost.equals(normalCost) && count > 1) {
                result.add((Component)LCText.TOOLTIP_SLOT_MACHINE_NORMAL_COST.get(normalCost.isFree() ? LCText.TOOLTIP_SLOT_MACHINE_COST_FREE.get(new Object[0]) : normalCost.getText()));
            }
            TradeEvent.PreTradeEvent event = trader.runPreTradeEvent(trader.getTrade(0), ((SlotMachineMenu)this.f_97732_).getContext());
            for (AlertData alert : event.getAlertInfo()) {
                result.add((Component)alert.getFormattedMessage());
            }
            return result;
        }
        return ImmutableList.of();
    }

    private void ExecuteTrade(int count) {
        ((SlotMachineMenu)this.f_97732_).SendMessageToServer(this.builder().setInt("ExecuteTrade", count));
    }

    private void OpenStorage(EasyButton button) {
        if (((SlotMachineMenu)this.f_97732_).getTrader() != null) {
            new CPacketOpenStorage(((SlotMachineMenu)this.f_97732_).getTrader().getID()).send();
        }
    }

    private void CollectCoins(EasyButton button) {
        if (((SlotMachineMenu)this.f_97732_).getTrader() != null) {
            CPacketCollectCoins.sendToServer();
        }
    }

    private void OpenTerminal(EasyButton button) {
        if (this.showTerminalButton()) {
            new CPacketOpenNetworkTerminal().send();
        }
    }

    @Override
    protected void screenTick() {
        if (this.isInfoMode()) {
            this.validateScroll();
        }
    }

    @Nonnull
    private List<SlotMachineEntry> getEntries() {
        SlotMachineTraderData trader = ((SlotMachineMenu)this.f_97732_).getTrader();
        if (trader != null) {
            return trader.getValidEntries();
        }
        return new ArrayList<SlotMachineEntry>();
    }

    private int getTrueIndex(int displayIndex) {
        return displayIndex + this.scroll * 2;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(4, 2, this.getEntries().size());
    }
}

