/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.notifications.NotificationTabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.gui.widget.notifications.NotificationDisplayWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.data.types.NotificationDataCache;
import io.github.lightman314.lightmanscurrency.common.menus.NotificationMenu;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NotificationScreen
extends EasyMenuScreen<NotificationMenu> {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/notifications.png");
    private static final int SCREEN_WIDTH = 200;
    private static final int SCREEN_HEIGHT = 200;
    public final int TABS_PER_PAGE = 8;
    public final int NOTIFICATIONS_PER_PAGE = 8;
    List<NotificationTabButton> tabButtons;
    int tabScroll = 0;
    NotificationCategory selectedCategory = NotificationCategory.GENERAL;
    NotificationDisplayWidget notificationDisplay;
    ScrollBarWidget notificationScroller;
    EasyButton buttonMarkAsSeen;

    public final NotificationData getNotifications() {
        return NotificationDataCache.TYPE.get(true).getNotifications(((NotificationMenu)this.f_97732_).player);
    }

    public NotificationScreen(@Nonnull NotificationMenu menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
        this.resize(200, 200);
    }

    public List<NotificationCategory> getCategories() {
        ArrayList categories = Lists.newArrayList((Object[])new NotificationCategory[]{NotificationCategory.GENERAL});
        categories.addAll(this.getNotifications().getCategories().stream().filter(cat -> cat != NotificationCategory.GENERAL).toList());
        return categories;
    }

    public void reinit() {
        this.m_169413_();
        this.validateSelectedCategory();
        this.m_7856_();
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.tabButtons = new ArrayList<NotificationTabButton>();
        for (NotificationCategory cat : this.getCategories()) {
            this.tabButtons.add(this.addChild(((NotificationTabButton.Builder)NotificationTabButton.nBuilder().pressAction(() -> this.SelectTab(cat))).data(this::getNotifications).category(cat).build()));
        }
        this.positionTabButtons();
        this.notificationDisplay = this.addChild(((NotificationDisplayWidget.Builder)NotificationDisplayWidget.builder().position(screenArea.pos.offset(15, 15))).width(screenArea.width - 30).rowCount(8).notificationSource(this::getVisibleNotifications).showGeneral(this::isGeneralSelected).colorIfUnseen().build());
        this.notificationDisplay.setDeletionHandler(this::deleteNotification, () -> !this.isGeneralSelected());
        this.notificationScroller = this.addChild(ScrollBarWidget.builder().onRight(this.notificationDisplay).build());
        int textWidth = this.f_96547_.m_92852_((FormattedText)LCText.BUTTON_NOTIFICATIONS_MARK_AS_READ.get(new Object[0]));
        this.buttonMarkAsSeen = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(screenArea.width - 19 - textWidth, 4))).size(4 + textWidth, 11)).text(LCText.BUTTON_NOTIFICATIONS_MARK_AS_READ).pressAction(this::markAsRead)).addon(EasyAddonHelper.activeCheck(() -> this.getNotifications().unseenNotification(this.selectedCategory)))).build());
    }

    private void validateSelectedCategory() {
        List<NotificationCategory> categories = this.getCategories();
        boolean categoryFound = false;
        for (int i = 0; i < categories.size() && !categoryFound; ++i) {
            if (!categories.get(i).matches(this.selectedCategory)) continue;
            categoryFound = true;
        }
        if (!categoryFound || this.selectedCategory == null) {
            this.selectedCategory = NotificationCategory.GENERAL;
        }
    }

    private boolean isGeneralSelected() {
        return this.selectedCategory == NotificationCategory.GENERAL;
    }

    private void positionTabButtons() {
        int startIndex = this.tabScroll = Math.min(this.tabScroll, this.getMaxTabScroll());
        ScreenPosition pos = this.getCorner().offset(-25, 0);
        List<NotificationCategory> categories = this.getCategories();
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            TabButton tab = this.tabButtons.get(i);
            if (i >= startIndex && i < startIndex + 8) {
                tab.f_93624_ = true;
                tab.setPosition(pos);
                tab.setRotation(WidgetRotation.LEFT);
                tab.f_93623_ = i < categories.size() ? !categories.get(i).matches(this.selectedCategory) : true;
                pos = pos.offset(0, 25);
                continue;
            }
            tab.f_93624_ = false;
        }
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        gui.renderNormalBackground(GUI_TEXTURE, this);
    }

    private List<Notification> getVisibleNotifications() {
        this.validateSelectedCategory();
        return this.getNotifications().getNotifications(this.selectedCategory);
    }

    private void SelectTab(NotificationCategory newCategory) {
        if (!newCategory.matches(this.selectedCategory)) {
            this.selectedCategory = newCategory;
            this.notificationDisplay.setScroll(0);
            this.positionTabButtons();
        }
    }

    public int getMaxTabScroll() {
        return Math.max(0, this.tabButtons.size() - 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tabScrolled(double delta) {
        if (delta < 0.0) {
            if (this.tabScroll >= this.getMaxTabScroll()) return false;
            ++this.tabScroll;
            this.positionTabButtons();
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.tabScroll <= 0) return false;
            --this.tabScroll;
            this.positionTabButtons();
        }
        return true;
    }

    public int getMaxNotificationScroll() {
        return Math.max(0, this.getNotifications().getNotifications(this.selectedCategory).size() - 8);
    }

    public void markAsRead(EasyButton button) {
        ((NotificationMenu)this.f_97732_).SendMessage(this.builder().setCompound("MarkAsRead", this.selectedCategory.save()));
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.getCorner().offset(25, 0).isMouseInArea(mouseX, mouseY, this.getXSize() - 25, this.getYSize())) {
            if (this.notificationDisplay.handleScrollWheel(delta)) {
                return true;
            }
            return super.m_6050_(mouseX, mouseY, delta);
        }
        if (this.tabScrolled(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void deleteNotification(int notificationIndex) {
        ((NotificationMenu)this.f_97732_).SendMessage(this.builder().setInt("DeleteNotification", notificationIndex).setCompound("Category", this.selectedCategory.save()));
    }
}

