/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.TerminalSorter;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.TerminalMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenTrades;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetworkTerminalScreen
extends EasyMenuScreen<TerminalMenu>
implements IScrollable {
    private static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/network_terminal.png");
    private EditBox searchField;
    private int searchWidth = 118;
    private static int scroll = 0;
    private static String lastSearch = "";
    ScrollBarWidget scrollBar;
    private int columns;
    private int rows;
    List<NetworkTraderButton> traderButtons;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();

    private List<TraderData> traderList() {
        List<TraderData> traderList = TraderAPI.API.GetAllNetworkTraders(true);
        traderList.sort(TerminalSorter.getDefaultSorter());
        return traderList;
    }

    public NetworkTerminalScreen(TerminalMenu menu, Inventory inventory, Component ignored) {
        super(menu, inventory, (Component)LCText.GUI_NETWORK_TERMINAL_TITLE.get(new Object[0]));
    }

    private ScreenArea calculateSize() {
        if (this.f_96541_ == null) {
            return this.getArea();
        }
        this.columns = 1;
        int columnLimit = (Integer)LCConfig.CLIENT.terminalColumnLimit.get();
        int availableWidth = this.f_96541_.m_91268_().m_85445_() - 146 - 30;
        while (availableWidth >= 146 && this.columns < columnLimit) {
            availableWidth -= 146;
            ++this.columns;
        }
        int availableHeight = this.f_96541_.m_91268_().m_85446_() - 30 - 45;
        this.rows = 1;
        int rowLimit = (Integer)LCConfig.CLIENT.terminalRowLimit.get();
        while (availableHeight >= 30 && this.rows < rowLimit) {
            availableHeight -= 30;
            ++this.rows;
        }
        this.resize(this.columns * 146 + 30, this.rows * 30 + 36);
        return this.getArea();
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        screenArea = this.calculateSize();
        this.searchWidth = 50 + (this.columns - 1) * 146;
        this.searchField = this.addChild(new EditBox(this.f_96547_, screenArea.x + 28, screenArea.y + 10, this.searchWidth - 17, 9, this.searchField, (Component)LCText.GUI_NETWORK_TERMINAL_SEARCH.get(new Object[0])));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94144_(lastSearch);
        this.searchField.m_94151_(this::onSearchChanged);
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 24, 4))).pressAction(this::OpenAllTraders)).icon(IconData.of(ModBlocks.ITEM_NETWORK_TRADER_4)).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_NETWORK_TERMINAL_OPEN_ALL))).build());
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(16 + 146 * this.columns, 17))).height(30 * this.rows * 2).scrollable(this).build());
        this.initTraderButtons(screenArea);
        this.updateTraderList();
        this.validateScroll();
    }

    private void initTraderButtons(ScreenArea screenArea) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.columns; ++x) {
                NetworkTraderButton newButton = this.addChild(((NetworkTraderButton.Builder)((NetworkTraderButton.Builder)NetworkTraderButton.builder().position(screenArea.pos.offset(15 + x * 146, 26 + y * 30))).pressAction(this::OpenTrader)).build());
                this.traderButtons.add(newButton);
            }
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.blitNineSplit(GUI_TEXTURE, 0, 0, this.f_97726_, this.f_97727_, 0, 0, 100, 100, 25);
        gui.blit(GUI_TEXTURE, 14, 7, 100, 0, 11, 14);
        gui.blitHorizSplit(GUI_TEXTURE, 25, 7, this.searchWidth, 14, 111, 0, 107, 4);
        gui.blitNineSplit(GUI_TEXTURE, 14, 25, this.f_97726_ - 28, this.f_97727_ - 42, 0, 100, 100, 100, 25);
    }

    protected void onSearchChanged(String newSearch) {
        if (newSearch.equals(lastSearch)) {
            return;
        }
        lastSearch = newSearch;
        this.updateTraderList();
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return this.searchField.m_93696_() && this.searchField.m_94213_() && key != 256 || super.m_7933_(key, scanCode, mods);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleScrollWheel(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void OpenTrader(EasyButton button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            new CPacketOpenTrades(this.filteredTraderList.get(index).getID()).send();
        }
    }

    private int getTraderIndex(EasyButton button) {
        if (button instanceof NetworkTraderButton && this.traderButtons.contains((Object)button)) {
            return this.traderButtons.indexOf((Object)button) + scroll * this.columns;
        }
        return -1;
    }

    private void updateTraderList() {
        StringBuilder fullSearch = new StringBuilder();
        String extra = (String)LCConfig.CLIENT.terminalBonusFilters.get();
        if (!extra.isBlank()) {
            fullSearch.append(extra);
            if (!extra.endsWith(" ")) {
                fullSearch.append(" ");
            }
        }
        if (!this.searchField.m_94155_().isBlank()) {
            fullSearch.append(this.searchField.m_94155_());
        }
        this.filteredTraderList = TraderAPI.API.FilterTraders(this.traderList(), fullSearch.toString());
        this.validateScroll();
        this.updateTraderButtons();
    }

    private void updateTraderButtons() {
        int startIndex = scroll * this.columns;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        scroll = newScroll;
        this.updateTraderButtons();
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.columns * this.rows, this.columns, this.filteredTraderList.size());
    }

    private void OpenAllTraders(EasyButton button) {
        new CPacketOpenTrades(-1L).send();
    }
}

