/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.overlay;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.IItemBasedValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.client.util.ScreenCorner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class WalletDisplayOverlay
implements IGuiOverlay {
    public static final WalletDisplayOverlay INSTANCE = new WalletDisplayOverlay();
    private boolean sendError = true;

    private WalletDisplayOverlay() {
    }

    public void render(ForgeGui fgui, GuiGraphics mcgui, float partialTick, int screenWidth, int screenHeight) {
        block16: {
            if (!((Boolean)LCConfig.CLIENT.walletOverlayEnabled.get()).booleanValue()) {
                return;
            }
            try {
                IMoneyHolder money;
                MoneyView contents;
                IWalletHandler walletHandler;
                EasyGuiGraphics gui = EasyGuiGraphics.create(mcgui, fgui.m_93082_(), 0, 0, partialTick);
                ScreenCorner corner = (ScreenCorner)((Object)LCConfig.CLIENT.walletOverlayCorner.get());
                ScreenPosition offset = (ScreenPosition)LCConfig.CLIENT.walletOverlayPosition.get();
                ScreenPosition currentPosition = corner.getCorner(screenWidth, screenHeight).offset(offset);
                if (corner.isRightSide) {
                    currentPosition = currentPosition.offset(ScreenPosition.of(-16, 0));
                }
                if (corner.isBottomSide) {
                    currentPosition = currentPosition.offset(ScreenPosition.of(0, -16));
                }
                if ((walletHandler = WalletCapability.lazyGetWalletHandler((Entity)fgui.getMinecraft().f_91074_)) == null) {
                    return;
                }
                ItemStack wallet = walletHandler.getWallet();
                if (WalletItem.isWallet(wallet)) {
                    gui.renderItem(wallet, currentPosition.x, currentPosition.y);
                    currentPosition = corner.isRightSide ? currentPosition.offset(ScreenPosition.of(-17, 0)) : currentPosition.offset(ScreenPosition.of(17, 0));
                }
                if ((contents = (money = MoneyAPI.API.GetPlayersMoneyHandler((Player)Minecraft.m_91087_().f_91074_)).getStoredMoney()).isEmpty()) {
                    return;
                }
                DisplayType type = (DisplayType)((Object)LCConfig.CLIENT.walletOverlayType.get());
                if (type == DisplayType.ITEMS_NARROW || type == DisplayType.ITEMS_WIDE) {
                    int offsetAmount = LCConfig.CLIENT.walletOverlayType.get() == DisplayType.ITEMS_WIDE ? 17 : 9;
                    MoneyValue randomValue = contents.getRandomValue();
                    if (randomValue instanceof IItemBasedValue) {
                        IItemBasedValue itemValue = (IItemBasedValue)((Object)randomValue);
                        for (ItemStack coin : itemValue.getAsItemList()) {
                            gui.renderItem(coin, currentPosition.x, currentPosition.y);
                            if (corner.isRightSide) {
                                currentPosition = currentPosition.offset(ScreenPosition.of(-offsetAmount, 0));
                                continue;
                            }
                            currentPosition = currentPosition.offset(ScreenPosition.of(offsetAmount, 0));
                        }
                    } else {
                        type = DisplayType.TEXT;
                    }
                }
                if (type == DisplayType.TEXT) {
                    MutableComponent walletText = contents.getRandomValueText(EasyText.empty());
                    if (corner.isRightSide) {
                        gui.drawString((Component)walletText, currentPosition.offset(-1 * gui.font.m_92852_((FormattedText)walletText), 3), 0xFFFFFF);
                    } else {
                        gui.drawString((Component)walletText, currentPosition.offset(0, 3), 0xFFFFFF);
                    }
                }
            }
            catch (Throwable t) {
                if (!this.sendError) break block16;
                this.sendError = false;
                LightmansCurrency.LogError("Error occurred while rendering wallet overlay!", t);
            }
        }
    }

    public static enum DisplayType {
        ITEMS_WIDE,
        ITEMS_NARROW,
        TEXT;

    }
}

