/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.trade.comparison;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProductComparisonResult {
    private final boolean sameProduct;
    private final boolean sameNBT;
    private final int quantityDifference;

    public boolean Identical() {
        return this.SameProductType() && this.SameProductNBT() && this.SameProductQuantity();
    }

    public boolean SameProductType() {
        return this.sameProduct;
    }

    public boolean SameProductNBT() {
        return this.sameNBT;
    }

    public boolean SameProductQuantity() {
        return this.quantityDifference == 0;
    }

    public int ProductQuantityDifference() {
        return this.quantityDifference;
    }

    private ProductComparisonResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        this.sameProduct = sameProduct;
        this.sameNBT = sameNBT;
        this.quantityDifference = quantityDifference;
    }

    public static ProductComparisonResult CompareItem(ItemStack trueItem, ItemStack expectedItem) {
        return ProductComparisonResult.CompareItem(trueItem, expectedItem, true);
    }

    public static ProductComparisonResult CompareItem(ItemStack trueItem, ItemStack expectedItem, boolean checkNBT) {
        boolean isItemEqual;
        boolean bl = isItemEqual = trueItem.m_41720_() == expectedItem.m_41720_();
        boolean isTagEqual = checkNBT ? (trueItem.m_41783_() != null ? trueItem.m_41783_().equals((Object)expectedItem.m_41783_()) : expectedItem.m_41783_() == null || expectedItem.m_41783_().m_128456_()) : true;
        int quantityDifference = trueItem.m_41613_() - expectedItem.m_41613_();
        return new ProductComparisonResult(isItemEqual, isTagEqual, quantityDifference);
    }

    public static ProductComparisonResult CreateRaw(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        return new ProductComparisonResult(sameProduct, sameNBT, quantityDifference);
    }

    public static List<ProductComparisonResult> CompareTwoItems(ItemStack true1, ItemStack true2, ItemStack expected1, ItemStack expected2) {
        return ProductComparisonResult.CompareTwoItems(true1, true2, expected1, expected2, true);
    }

    public static List<ProductComparisonResult> CompareTwoItems(ItemStack true1, ItemStack true2, ItemStack expected1, ItemStack expected2, boolean checkNBT) {
        boolean flipMatch;
        ArrayList<ProductComparisonResult> results = new ArrayList<ProductComparisonResult>();
        boolean bl = flipMatch = true1.m_41720_() == expected2.m_41720_() && true2.m_41720_() == expected1.m_41720_() && true1.m_41720_() != true2.m_41720_() && expected1.m_41720_() != expected2.m_41720_();
        if (flipMatch) {
            results.add(ProductComparisonResult.CompareItem(true1, expected2, checkNBT));
            results.add(ProductComparisonResult.CompareItem(true2, expected1));
        } else {
            results.add(ProductComparisonResult.CompareItem(true1, expected1));
            results.add(ProductComparisonResult.CompareItem(true2, expected2));
        }
        return results;
    }

    public static ProductComparisonResult CompareFluid(FluidStack trueFluid, FluidStack expectedFluid) {
        boolean isFluidEqual;
        boolean bl = isFluidEqual = trueFluid.getFluid() == expectedFluid.getFluid();
        boolean isTagEqual = trueFluid.getTag() != null ? trueFluid.getTag().equals((Object)expectedFluid.getTag()) : expectedFluid.getTag() == null;
        int quantityDifference = trueFluid.getAmount() - expectedFluid.getAmount();
        return new ProductComparisonResult(isFluidEqual, isTagEqual, quantityDifference);
    }

    public static ProductComparisonResult CompareEnergy(int original, int query) {
        return new ProductComparisonResult(true, true, original - query);
    }
}

