/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ticket;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TicketData {
    private static final List<TicketData> DATA = new ArrayList<TicketData>();
    public final Item masterTicket;
    public final Item ticket;
    public final Item ticketStub;
    public final TagKey<Item> material;

    public static List<TicketData> allData() {
        return ImmutableList.copyOf(DATA);
    }

    private TicketData(@Nonnull ItemLike masterTicket, @Nonnull ItemLike ticket, @Nonnull ItemLike ticketStub, @Nonnull TagKey<Item> material) {
        this.masterTicket = masterTicket.m_5456_();
        this.ticket = ticket.m_5456_();
        this.ticketStub = ticketStub.m_5456_();
        this.material = material;
    }

    public static void create(@Nonnull ItemLike masterTicket, @Nonnull ItemLike ticket, @Nonnull ItemLike ticketStub, @Nonnull TagKey<Item> material) {
        DATA.add(new TicketData(masterTicket, ticket, ticketStub, material));
    }

    @Nullable
    public static TicketData getForMaster(@Nonnull ItemStack masterTicket) {
        for (TicketData data : DATA) {
            if (data.masterTicket != masterTicket.m_41720_()) continue;
            return data;
        }
        return null;
    }

    @Nullable
    public static TicketData getForTicket(@Nonnull ItemStack ticket) {
        for (TicketData data : DATA) {
            if (data.ticket != ticket.m_41720_()) continue;
            return data;
        }
        return null;
    }

    @Nullable
    public static TicketData getForMaterial(@Nonnull ItemStack material) {
        for (TicketData data : DATA) {
            if (!InventoryUtil.ItemHasTag(material, data.material)) continue;
            return data;
        }
        return null;
    }
}

