/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.bank.reference;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public abstract class BankReference
extends MoneyHolder.Slave
implements ISidedObject {
    private boolean isClient = false;
    protected final BankReferenceType type;

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    @Nonnull
    public BankReference flagAsClient() {
        return this.flagAsClient(true);
    }

    @Override
    @Nonnull
    public BankReference flagAsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    @Override
    @Nonnull
    public BankReference flagAsClient(@Nonnull IClientTracker parent) {
        return this.flagAsClient(parent.isClient());
    }

    protected BankReference(@Nonnull BankReferenceType type) {
        this.type = type;
    }

    @Nullable
    public abstract IBankAccount get();

    public int sortPriority() {
        return 0;
    }

    public abstract boolean allowedAccess(@Nonnull PlayerReference var1);

    public abstract boolean allowedAccess(@Nonnull Player var1);

    public boolean canPersist(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public final CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.id.toString());
        return tag;
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    public final void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130070_(this.type.id.toString());
        this.encodeAdditional(buffer);
    }

    protected abstract void encodeAdditional(@Nonnull FriendlyByteBuf var1);

    @Nullable
    public static BankReference load(CompoundTag tag) {
        if (tag.m_128441_("Type")) {
            BankReferenceType type = BankAPI.API.GetReferenceType(VersionUtil.parseResource(tag.m_128461_("Type")));
            if (type != null) {
                return type.load(tag);
            }
            LightmansCurrency.LogWarning("No Bank Reference Type '" + type + "' could be loaded.");
        } else {
            if (tag.m_128441_("PlayerID")) {
                return PlayerBankReference.of(tag.m_128342_("PlayerID"));
            }
            if (tag.m_128441_("TeamID")) {
                return TeamBankReference.of(tag.m_128454_("TeamID"));
            }
        }
        return null;
    }

    @Nullable
    public static BankReference decode(@Nonnull FriendlyByteBuf buffer) {
        BankReferenceType type = BankAPI.API.GetReferenceType(VersionUtil.parseResource(buffer.m_130277_()));
        if (type != null) {
            return type.decode(buffer);
        }
        LightmansCurrency.LogWarning("No Bank Reference Type '" + type + "' could be decoded.");
        return null;
    }

    @Override
    @Nullable
    protected IMoneyHolder getParent() {
        return this.get();
    }

    @Nullable
    public abstract IconData getIcon();

    public boolean equals(Object obj) {
        if (obj instanceof BankReference) {
            BankReference br = (BankReference)obj;
            return br.save().equals((Object)this.save());
        }
        return false;
    }

    public int hashCode() {
        return this.save().hashCode();
    }
}

