/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public interface IBankAccount
extends IMoneyHolder,
IClientTracker {
    @Nonnull
    public MoneyStorage getMoneyStorage();

    public int getCardValidation();

    public boolean isCardValid(int var1);

    public void resetCards();

    @Nonnull
    public MutableComponent getName();

    @Nonnull
    public Map<String, MoneyValue> getNotificationLevels();

    @Nonnull
    public MoneyValue getNotificationLevelFor(@Nonnull String var1);

    public void setNotificationLevel(@Nonnull String var1, @Nonnull MoneyValue var2);

    public void pushLocalNotification(@Nonnull Notification var1);

    default public void pushNotification(@Nonnull Supplier<Notification> notification) {
        this.pushNotification(notification, true);
    }

    public void pushNotification(@Nonnull Supplier<Notification> var1, boolean var2);

    @Nonnull
    public List<Notification> getNotifications();

    @Nonnull
    default public MutableComponent getBalanceText() {
        return LCText.GUI_BANK_BALANCE.get(this.getMoneyStorage().getRandomValueText());
    }

    public void depositMoney(@Nonnull MoneyValue var1);

    @Nonnull
    public MoneyValue withdrawMoney(@Nonnull MoneyValue var1);

    public void applyInterest(double var1, @Nonnull List<MoneyValue> var3, boolean var4, boolean var5);
}

