/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.blocks;

import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public interface IRotatableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public static BlockPos getRightPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            case Direction.SOUTH -> new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            case Direction.EAST -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            case Direction.WEST -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            default -> pos;
        };
    }

    public static BlockPos getLeftPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            case Direction.SOUTH -> new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            case Direction.EAST -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            case Direction.WEST -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            default -> pos;
        };
    }

    public static BlockPos getForwardPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            case Direction.SOUTH -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            case Direction.EAST -> new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            case Direction.WEST -> new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            default -> pos;
        };
    }

    public static BlockPos getBackwardPos(BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            case Direction.SOUTH -> new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            case Direction.EAST -> new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            case Direction.WEST -> new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            default -> pos;
        };
    }

    public static Vector3f getRightVect(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new Vector3f(1.0f, 0.0f, 0.0f);
            case Direction.SOUTH -> new Vector3f(-1.0f, 0.0f, 0.0f);
            case Direction.EAST -> new Vector3f(0.0f, 0.0f, 1.0f);
            case Direction.WEST -> new Vector3f(0.0f, 0.0f, -1.0f);
            default -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    public static Vector3f getLeftVect(Direction facing) {
        return MathUtil.VectorMult(IRotatableBlock.getRightVect(facing), -1.0f);
    }

    public static Vector3f getForwardVect(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new Vector3f(0.0f, 0.0f, -1.0f);
            case Direction.SOUTH -> new Vector3f(0.0f, 0.0f, 1.0f);
            case Direction.EAST -> new Vector3f(1.0f, 0.0f, 0.0f);
            case Direction.WEST -> new Vector3f(-1.0f, 0.0f, 0.0f);
            default -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    public static Vector3f getBackwardVect(Direction facing) {
        return MathUtil.VectorMult(IRotatableBlock.getForwardVect(facing), -1.0f);
    }

    public static Vector3f getOffsetVect(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> new Vector3f(0.0f, 0.0f, 1.0f);
            case Direction.SOUTH -> new Vector3f(1.0f, 0.0f, 0.0f);
            case Direction.WEST -> new Vector3f(1.0f, 0.0f, 1.0f);
            default -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    default public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    public static Direction getRelativeSide(Direction facing, Direction side) {
        if (side == null) {
            return null;
        }
        if (side.m_122434_() == Direction.Axis.Y) {
            return side;
        }
        if (facing.m_122434_() == Direction.Axis.Z) {
            facing = facing.m_122424_();
        }
        return Direction.m_122407_((int)(facing.m_122416_() + side.m_122416_()));
    }

    public static Direction getActualSide(Direction facing, Direction relativeSide) {
        Direction result;
        if (relativeSide == null) {
            return null;
        }
        if (relativeSide.m_122434_() == Direction.Axis.Y) {
            return relativeSide;
        }
        if (facing.m_122434_() == Direction.Axis.Z) {
            facing = facing.m_122424_();
        }
        return (result = Direction.m_122407_((int)(facing.m_122416_() - relativeSide.m_122416_() + 4))).m_122434_() == Direction.Axis.X ? result.m_122424_() : result;
    }
}

