/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.easy_data;

import io.github.lightman314.lightmanscurrency.api.easy_data.EasyDataSettings;
import io.github.lightman314.lightmanscurrency.api.easy_data.ReadWriteContext;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class EasyData<T> {
    private final List<Consumer<T>> changeListeners = new ArrayList<Consumer<T>>();
    public final EasyDataSettings<T> settings;

    public EasyData(EasyDataSettings<T> builder) {
        this.settings = builder;
        this.settings.host.registerData(this);
    }

    public final void write(CompoundTag tag) {
        this.write(ReadWriteContext.of(tag), this.settings.tagKey);
    }

    protected abstract void write(ReadWriteContext var1, String var2);

    public final void read(CompoundTag tag) {
        if (tag.m_128441_(this.settings.tagKey)) {
            this.read(ReadWriteContext.of(tag), this.settings.tagKey);
        }
    }

    protected abstract void read(ReadWriteContext var1, String var2);

    public abstract T get();

    public final void set(T newValue) {
        if (this.get().equals(newValue)) {
            return;
        }
        this.setInternal(newValue);
        this.setChanged();
    }

    protected abstract void setInternal(T var1);

    @Nullable
    protected abstract Notification change(PlayerReference var1, T var2);

    public final void trySet(Player player, T newValue) {
        if (this.settings.category.canEdit(player, this.settings.host) && !this.get().equals(newValue)) {
            Consumer<Notification> consumer;
            T oldValue = this.get();
            PlayerReference pr = PlayerReference.of(player);
            Notification notification = this.change(pr, newValue);
            notification = this.settings.filterNotification(oldValue, this.get(), pr, notification);
            this.setChanged();
            if (notification != null && (consumer = this.settings.host.dataChangeNotifier()) != null) {
                consumer.accept(notification);
            }
        }
    }

    private void setChanged() {
        T val = this.get();
        for (Consumer<T> listener : new ArrayList<Consumer<T>>(this.changeListeners)) {
            listener.accept(val);
        }
        this.settings.host.onDataChanged(this);
    }

    public final void addListener(Consumer<T> listener) {
        if (this.changeListeners.contains(listener)) {
            return;
        }
        this.changeListeners.add(listener);
    }

    public final void removeListener(Consumer<T> listener) {
        this.changeListeners.remove(listener);
    }
}

