/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class LongOption
extends ConfigOption<Long> {
    private final long lowerLimit;
    private final long upperLimit;
    private final ConfigParser<Long> parser;

    public static ConfigParser<Long> makeParser(long lowerLimit, long upperLimit) {
        return new Parser(lowerLimit, upperLimit);
    }

    protected LongOption(@Nonnull Supplier<Long> defaultValue, long lowerLimit, long upperLimit) {
        super(defaultValue);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.parser = LongOption.makeParser(lowerLimit, upperLimit);
    }

    @Override
    @Nonnull
    protected ConfigParser<Long> getParser() {
        return this.parser;
    }

    @Override
    @Nonnull
    protected List<String> bonusComments() {
        return Lists.newArrayList((Object[])new String[]{"Range: " + this.lowerLimit + " -> " + this.upperLimit, "Default: " + this.getDefaultValue()});
    }

    public static LongOption create(long defaultValue) {
        return new LongOption(() -> defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static LongOption create(long defaultValue, long lowerLimit) {
        return new LongOption(() -> defaultValue, lowerLimit, Long.MAX_VALUE);
    }

    public static LongOption create(long defaultValue, long lowerLimit, long upperLimit) {
        return new LongOption(() -> defaultValue, lowerLimit, upperLimit);
    }

    public static LongOption create(@Nonnull Supplier<Long> defaultValue) {
        return new LongOption(defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static LongOption create(@Nonnull Supplier<Long> defaultValue, long lowerLimit) {
        return new LongOption(defaultValue, lowerLimit, Long.MAX_VALUE);
    }

    public static LongOption create(@Nonnull Supplier<Long> defaultValue, long lowerLimit, long upperLimit) {
        return new LongOption(defaultValue, lowerLimit, upperLimit);
    }

    private static class Parser
    implements ConfigParser<Long> {
        private final long lowerLimit;
        private final long upperLimit;

        private Parser(long lowerLimit, long upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        @Nonnull
        public Long tryParse(@Nonnull String cleanLine) throws ConfigParsingException {
            try {
                return MathUtil.clamp(Long.parseLong(cleanLine), this.lowerLimit, this.upperLimit);
            }
            catch (NumberFormatException e) {
                throw new ConfigParsingException("Error parsing long!", e);
            }
        }

        @Override
        @Nonnull
        public String write(@Nonnull Long value) {
            return Long.toString(value);
        }
    }
}

