/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.conditions;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConfigCraftingCondition
implements ICondition {
    public static final ResourceLocation ID = VersionUtil.lcResource("configured");
    public static final IConditionSerializer<ConfigCraftingCondition> SERIALIZER = new Serializer();
    private final ResourceLocation fileID;
    private final String optionPath;

    private ConfigCraftingCondition(ResourceLocation fileID, String optionPath) {
        this.fileID = fileID;
        this.optionPath = optionPath;
    }

    public static ConfigCraftingCondition of(ResourceLocation fileID, String optionPath) {
        return new ConfigCraftingCondition(fileID, optionPath);
    }

    public static ConfigCraftingCondition of(BooleanOption option) {
        Object path = null;
        ConfigFile file = option.getFile();
        if (file == null) {
            throw new IllegalArgumentException("Config Option was not attached to a config file!");
        }
        for (Map.Entry<String, ConfigOption<?>> entry : file.getAllOptions().entrySet()) {
            if (entry.getValue() != option) continue;
            return ConfigCraftingCondition.of(file.getFileID(), entry.getKey());
        }
        throw new IllegalArgumentException("Config Option was not a member of the config file!");
    }

    public boolean test(ICondition.IContext context) {
        Object obj;
        ConfigOption<?> option;
        ConfigFile file = ConfigFile.lookupFile(this.fileID);
        if (file != null && (option = file.getAllOptions().get(this.optionPath)) != null && (obj = option.get()) instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool;
        }
        return false;
    }

    public ResourceLocation getID() {
        return ID;
    }

    private static class Serializer
    implements IConditionSerializer<ConfigCraftingCondition> {
        private Serializer() {
        }

        public ResourceLocation getID() {
            return ID;
        }

        public void write(JsonObject json, ConfigCraftingCondition condition) {
            json.addProperty("fileID", condition.fileID.toString());
            json.addProperty("option", condition.optionPath);
        }

        public ConfigCraftingCondition read(JsonObject json) {
            String optionPath = GsonHelper.m_13906_((JsonObject)json, (String)"option");
            if (json.has("fileName")) {
                String fileName = GsonHelper.m_13906_((JsonObject)json, (String)"fileName");
                ConfigFile file = ConfigFile.lookupFile(fileName);
                if (file != null) {
                    return ConfigCraftingCondition.of(file.getFileID(), optionPath);
                }
                return ConfigCraftingCondition.of(ConfigFile.forceGenerateID(fileName), optionPath);
            }
            ResourceLocation fileID = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"fileID"));
            return ConfigCraftingCondition.of(fileID, optionPath);
        }
    }
}

