/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class AboutPartyCommand {
    private static final int MAX_MEMBER_COUNT = 32;
    private static final int MAX_ALLY_COUNT = 32;
    private static final int MAX_INVITES_COUNT = 16;

    private static <T> int createLimitedList(Component listComponent, int maxCount, Iterator<T> iterator, Consumer<T> adder) {
        int count = 0;
        while (iterator.hasNext()) {
            adder.accept(iterator.next());
            if (++count != maxCount) continue;
            listComponent.m_7360_().add(Component.m_237113_((String)" ..."));
            break;
        }
        return count;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Command action = context -> {
            Object tooltipPrefix;
            Object targetProfile;
            ServerPlayer casterPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            try {
                Collection profiles = GameProfileArgument.m_94590_((CommandContext)context, (String)"profile");
                targetProfile = profiles.size() == 1 ? (GameProfile)profiles.iterator().next() : null;
            }
            catch (IllegalArgumentException iae) {
                try {
                    ServerPlayer inputPlayer = EntityArgument.m_91474_((CommandContext)context, (String)"player");
                    targetProfile = inputPlayer != null ? inputPlayer.m_36316_() : null;
                }
                catch (IllegalArgumentException iae2) {
                    targetProfile = casterPlayer.m_36316_();
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((CommandSourceStack)context.getSource()).m_81377_());
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (targetProfile == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_about_invalid_player", new Object[0]));
                return 0;
            }
            GameProfile profile = targetProfile;
            UUID casterPlayerId = casterPlayer.m_20148_();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(profile.getId());
            if (playerParty == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_about_no_party", profile.getName()));
                return 0;
            }
            casterPlayer.m_213846_((Component)Component.m_237113_((String)""));
            casterPlayer.m_213846_((Component)Component.m_237113_((String)"===== Open Parties and Claims").m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)));
            casterPlayer.m_213846_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_player", new Object[0]).m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)));
            casterPlayer.m_213846_((Component)Component.m_237113_((String)profile.getName()).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)profile.getId().toString())))));
            casterPlayer.m_213846_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_current_party", new Object[0]).m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)));
            String partyName = playerParty.getDefaultName();
            IPlayerConfig ownerConfig = serverData.getPlayerConfigs().getLoadedConfig(playerParty.getOwner().getUUID());
            String partyCustomName = ownerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
            Object object = tooltipPrefix = !partyCustomName.isEmpty() ? partyName + "\n" : "";
            if (!partyCustomName.isEmpty()) {
                partyName = partyCustomName;
            }
            casterPlayer.m_213846_((Component)Component.m_237113_((String)partyName).m_130938_(arg_0 -> AboutPartyCommand.lambda$register$4((String)tooltipPrefix, (IServerParty)playerParty, arg_0)));
            casterPlayer.m_213846_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_members", playerParty.getMemberCount() + "/" + ServerConfig.CONFIG.maxPartyMembers.get()).m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)));
            MutableComponent partyMembersComponent = Component.m_237113_((String)"");
            Consumer<IPartyMember> partyMemberConsumer = arg_0 -> AboutPartyCommand.lambda$register$8((Component)partyMembersComponent, (IServerParty)playerParty, adaptiveLocalizer, casterPlayer, arg_0);
            int staffCount = AboutPartyCommand.createLimitedList((Component)partyMembersComponent, 32, playerParty.getTypedStaffInfoStream().iterator(), partyMemberConsumer);
            if (staffCount < 32) {
                AboutPartyCommand.createLimitedList((Component)partyMembersComponent, 32 - staffCount, playerParty.getTypedNonStaffInfoStream().iterator(), partyMemberConsumer);
            }
            casterPlayer.m_213846_((Component)partyMembersComponent);
            casterPlayer.m_213846_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_allies", playerParty.getAllyCount() + "/" + ServerConfig.CONFIG.maxPartyAllies.get()).m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)));
            MutableComponent partyAlliesComponent = Component.m_237113_((String)"");
            AboutPartyCommand.createLimitedList((Component)partyAlliesComponent, 32, playerParty.getTypedAllyPartiesStream().iterator(), arg_0 -> AboutPartyCommand.lambda$register$11((IPartyManager)partyManager, (Component)partyAlliesComponent, serverData, arg_0));
            if (partyAlliesComponent.m_7360_().isEmpty()) {
                casterPlayer.m_213846_((Component)Component.m_237113_((String)"N/A").m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)));
            } else {
                casterPlayer.m_213846_((Component)partyAlliesComponent);
            }
            casterPlayer.m_213846_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_invited", playerParty.getInviteCount() + "/" + ServerConfig.CONFIG.maxPartyInvites.get()).m_130938_(s -> s.m_131140_(ChatFormatting.GOLD)));
            MutableComponent invitedComponent = Component.m_237113_((String)"");
            AboutPartyCommand.createLimitedList((Component)invitedComponent, 16, playerParty.getTypedInvitedPlayersStream().iterator(), arg_0 -> AboutPartyCommand.lambda$register$15((Component)invitedComponent, arg_0));
            if (invitedComponent.m_7360_().isEmpty()) {
                casterPlayer.m_213846_((Component)Component.m_237113_((String)"N/A").m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)));
            } else {
                casterPlayer.m_213846_((Component)invitedComponent);
            }
            casterPlayer.m_213846_((Component)Component.m_237113_((String)"=====").m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)));
            return 1;
        };
        SuggestionProvider suggestions = (context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_();
            return SharedSuggestionProvider.m_82981_(playerlist.m_11314_().stream().map(targetPlayer -> targetPlayer.m_36316_().getName()), (SuggestionsBuilder)builder);
        };
        LiteralArgumentBuilder normalCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(Commands.m_82127_((String)"about").executes(action));
        dispatcher.register(normalCommand);
        LiteralArgumentBuilder targetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(Commands.m_82127_((String)"about").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(c -> !c.m_6761_(2))).suggests(suggestions).executes(action)));
        dispatcher.register(targetCommand);
        LiteralArgumentBuilder opTargetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(Commands.m_82127_((String)"about").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"profile", (ArgumentType)GameProfileArgument.m_94584_()).requires(c -> c.m_6761_(2))).suggests(suggestions).executes(action)));
        dispatcher.register(opTargetCommand);
    }

    private static /* synthetic */ void lambda$register$15(Component invitedComponent, IPartyPlayerInfo pi) {
        if (!invitedComponent.m_7360_().isEmpty()) {
            invitedComponent.m_7360_().add(Component.m_237113_((String)", "));
        }
        invitedComponent.m_7360_().add(Component.m_237113_((String)pi.getUsername()).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)pi.getUUID().toString())))));
    }

    private static /* synthetic */ void lambda$register$11(IPartyManager partyManager, Component partyAlliesComponent, IServerData serverData, IPartyAlly ally) {
        IServerPartyAPI allyParty = partyManager.getPartyById(ally.getPartyId());
        if (allyParty != null) {
            if (!partyAlliesComponent.m_7360_().isEmpty()) {
                partyAlliesComponent.m_7360_().add(Component.m_237113_((String)", "));
            }
            IPlayerConfig allyOwnerConfig = serverData.getPlayerConfigs().getLoadedConfig(allyParty.getOwner().getUUID());
            String configuredAllyName = allyOwnerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
            String allyDefaultName = allyParty.getDefaultName();
            Object allyTooltipPrefix = !configuredAllyName.isEmpty() ? allyDefaultName + "\n" : "";
            partyAlliesComponent.m_7360_().add(Component.m_237113_((String)(configuredAllyName.isEmpty() ? allyDefaultName : configuredAllyName)).m_130938_(arg_0 -> AboutPartyCommand.lambda$register$10((String)allyTooltipPrefix, (IServerParty)allyParty, arg_0)));
        }
    }

    private static /* synthetic */ Style lambda$register$10(String allyTooltipPrefix, IServerParty allyParty, Style s) {
        return s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(allyTooltipPrefix + allyParty.getId().toString()))));
    }

    private static /* synthetic */ void lambda$register$8(Component partyMembersComponent, IServerParty playerParty, AdaptiveLocalizer adaptiveLocalizer, ServerPlayer casterPlayer, IPartyMember mi) {
        if (!partyMembersComponent.m_7360_().isEmpty()) {
            partyMembersComponent.m_7360_().add(Component.m_237113_((String)", "));
        }
        partyMembersComponent.m_7360_().add(Component.m_237113_((String)mi.getUsername()).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)mi.getUUID().toString())))));
        if (mi.getRank() != PartyMemberRank.MEMBER) {
            MutableComponent rankComponent = Component.m_237113_((String)(playerParty.getOwner() == mi ? "OWNER" : mi.getRank().toString())).m_130938_(s -> s.m_131140_(mi.getRank().getColor()));
            partyMembersComponent.m_7360_().add(adaptiveLocalizer.getFor(casterPlayer, "[%s]", rankComponent));
        }
    }

    private static /* synthetic */ Style lambda$register$4(String tooltipPrefix, IServerParty playerParty, Style s) {
        return s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(tooltipPrefix + playerParty.getId().toString()))));
    }
}

