/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.claims.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.client.claims.player.ClientPlayerClaimInfoManager;
import xaero.pac.client.claims.player.IClientPlayerClaimInfo;
import xaero.pac.client.claims.player.sub.ClientPlayerSubClaimInfo;
import xaero.pac.common.claims.player.PlayerClaimInfo;
import xaero.pac.common.claims.player.PlayerDimensionClaims;

public final class ClientPlayerClaimInfo
extends PlayerClaimInfo<ClientPlayerClaimInfo, ClientPlayerClaimInfoManager>
implements IClientPlayerClaimInfo<PlayerDimensionClaims> {
    private final Int2ObjectMap<ClientPlayerSubClaimInfo> subClaimInfo;

    public ClientPlayerClaimInfo(String username, UUID playerId, Map<ResourceLocation, PlayerDimensionClaims> claims, ClientPlayerClaimInfoManager manager, Int2ObjectMap<ClientPlayerSubClaimInfo> subClaimInfo) {
        super(username, playerId, claims, manager);
        this.subClaimInfo = subClaimInfo;
    }

    @Override
    protected Stream<Map.Entry<ResourceLocation, PlayerDimensionClaims>> getDimensionClaimCountStream() {
        return this.claims.entrySet().stream();
    }

    @Override
    protected Stream<Map.Entry<ResourceLocation, PlayerDimensionClaims>> getDimensionForceloadCountStream() {
        return this.getDimensionClaimCountStream();
    }

    @Override
    @Nullable
    public String getClaimsName(int subConfigIndex) {
        ClientPlayerSubClaimInfo sub = (ClientPlayerSubClaimInfo)this.subClaimInfo.get(subConfigIndex);
        if (sub == null) {
            return null;
        }
        return sub.getClaimsName();
    }

    @Override
    @Nullable
    public Integer getClaimsColor(int subConfigIndex) {
        ClientPlayerSubClaimInfo sub = (ClientPlayerSubClaimInfo)this.subClaimInfo.get(subConfigIndex);
        if (sub == null) {
            return null;
        }
        return sub.getClaimsColor();
    }

    public void ensureSubClaim(int subConfigIndex) {
        if (!this.subClaimInfo.containsKey(subConfigIndex)) {
            this.subClaimInfo.put(subConfigIndex, (Object)new ClientPlayerSubClaimInfo(subConfigIndex));
        }
    }

    public void removeSubClaim(int subConfigIndex) {
        this.subClaimInfo.remove(subConfigIndex);
    }

    public void setClaimsName(int subConfigIndex, String name) {
        ClientPlayerSubClaimInfo sub = (ClientPlayerSubClaimInfo)this.subClaimInfo.get(subConfigIndex);
        if (sub == null) {
            return;
        }
        sub.setClaimsName(name);
    }

    public void setClaimsColor(int subConfigIndex, Integer color) {
        ClientPlayerSubClaimInfo sub = (ClientPlayerSubClaimInfo)this.subClaimInfo.get(subConfigIndex);
        if (sub == null) {
            return;
        }
        sub.setClaimsColor(color);
    }
}

