/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class IntegerEditBox
extends EditBox {
    private boolean contentValid;

    public IntegerEditBox(Font textRenderer, int x, int y, int width, int height, Component name, int defaultVal, Consumer<IntegerEditBox> onChanged, Function<String, Boolean> validator, Component toolTipComponent) {
        super(textRenderer, x, y, width, height, name);
        if (toolTipComponent != null) {
            this.m_257544_(Tooltip.m_257550_((Component)toolTipComponent));
        }
        this.m_94144_(String.valueOf(defaultVal));
        this.m_94151_(text -> {
            this.contentValid = (Boolean)validator.apply((String)text);
            this.m_94202_(this.contentValid ? 0xFFFFFF : 0xFF0000);
            onChanged.accept(this);
        });
        this.contentValid = validator.apply(this.m_94155_());
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.m_94155_());
    }

    public boolean isContentValid() {
        return this.contentValid;
    }

    public static Function<String, Boolean> makeValidator(int min, int max) {
        return text -> {
            boolean valid = true;
            try {
                if (text.length() > 0) {
                    int port = Integer.parseInt(text);
                    if (port < min || port > max) {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                valid = false;
            }
            return valid;
        };
    }
}

