/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.sculptor;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.GeckoDynamicChain;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.client.sound.BossMusic;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.abilities.mob.HurtAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimpleAnimationAbility;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.UseAbilityAI;
import com.bobmowzie.mowziesmobs.server.bossinfo.BossInfoSculptor;
import com.bobmowzie.mowziesmobs.server.bossinfo.MMBossInfoServer;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderSculptor;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillar;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerSculptorTrade;
import com.bobmowzie.mowziesmobs.server.item.ItemEarthrendGauntlet;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemSculptorStaff;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class EntitySculptor
extends MowzieGeckoEntity {
    public static int TEST_HEIGHT = 60;
    public static int TEST_RADIUS_BOTTOM = 6;
    public static int TEST_RADIUS = 13;
    public static int TEST_MAX_RADIUS_HEIGHT = 20;
    public static double TEST_RADIUS_FALLOFF = 5.0;
    private static final int HEAL_PAUSE = 75;
    public static float DEFENSE_HEALTH_THRESHOLD = 0.8f;
    public Vector3d calfRPos;
    public Vector3d calfLPos;
    public Vector3d thighRPos;
    public Vector3d thighLPos;
    public Vector3d skirtEndRPos;
    public Vector3d skirtEndLPos;
    public Vector3d skirtLocFrontRPos;
    public Vector3d skirtLocFrontLPos;
    public Vector3d skirtLocBackRPos;
    public Vector3d skirtLocBackLPos;
    public float disappearController = 0.0f;
    public Matrix4f frontClothRot;
    public static final AbilityType<EntitySculptor, HurtAbility<EntitySculptor>> HURT_ABILITY = new AbilityType<EntitySculptor, HurtAbility>("sculptor_hurt", (type, entity) -> new HurtAbility<EntitySculptor>(type, (EntitySculptor)entity, RawAnimation.begin().thenPlay("hurt"), 16, 0));
    public static final AbilityType<EntitySculptor, SculptorDieAbility> DIE_ABILITY = new AbilityType<EntitySculptor, SculptorDieAbility>("sculptor_die", SculptorDieAbility::new);
    public static final AbilityType<EntitySculptor, StartTestAbility> START_TEST = new AbilityType<EntitySculptor, StartTestAbility>("testStart", StartTestAbility::new);
    public static final AbilityType<EntitySculptor, FailTestAbility> FAIL_TEST = new AbilityType<EntitySculptor, FailTestAbility>("testFail", FailTestAbility::new);
    public static final AbilityType<EntitySculptor, PassTestAbility> PASS_TEST = new AbilityType<EntitySculptor, PassTestAbility>("testPass", PassTestAbility::new);
    public static final AbilityType<EntitySculptor, AttackAbility> ATTACK_ABILITY = new AbilityType<EntitySculptor, AttackAbility>("attack", AttackAbility::new);
    public static final AbilityType<EntitySculptor, GuardAbility> GUARD_ABILITY = new AbilityType<EntitySculptor, GuardAbility>("guard", GuardAbility::new);
    public static final AbilityType<EntitySculptor, DisappearAbility> DISAPPEAR_ABILITY = new AbilityType<EntitySculptor, DisappearAbility>("disappear", DisappearAbility::new);
    public static final AbilityType<EntitySculptor, SimpleAnimationAbility<EntitySculptor>> TALK_ABILITY = new AbilityType<EntitySculptor, SimpleAnimationAbility>("talk", (type, entity) -> new SimpleAnimationAbility<EntitySculptor>(type, entity, RawAnimation.begin().thenPlay("talk"), 27, true){

        @Override
        public void start() {
            ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_GREETING.get(), 1.0f, 1.0f);
            super.start();
        }
    });
    public static final AbilityType<EntitySculptor, SimpleAnimationAbility<EntitySculptor>> IDLE_ABILITY = new AbilityType<EntitySculptor, SimpleAnimationAbility>("idle", (type, entity) -> new SimpleAnimationAbility<EntitySculptor>(type, entity, RawAnimation.begin().thenPlay("idle_variation_1"), 88, true){

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getTicksInUse() == 10) {
                ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_HM.get(), 1.0f, 1.0f);
            }
        }
    });
    public static final AbilityType<EntitySculptor, SimpleAnimationAbility<EntitySculptor>> LAUGH_ABILITY = new AbilityType<EntitySculptor, SimpleAnimationAbility>("laugh", (type, entity) -> new SimpleAnimationAbility<EntitySculptor>(type, entity, RawAnimation.begin().thenPlay("laugh"), 58, true){

        @Override
        public void start() {
            ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_LAUGH.get(), 1.0f, 1.0f);
            super.start();
        }
    });
    private static final EntityDataAccessor<ItemStack> DESIRES = SynchedEntityData.m_135353_(EntitySculptor.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> IS_TRADING = SynchedEntityData.m_135353_(EntitySculptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FIGHTING = SynchedEntityData.m_135353_(EntitySculptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> TESTING_PLAYER = SynchedEntityData.m_135353_(EntitySculptor.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Player customer;
    private Player testingPlayer;
    private Optional<Double> prevPlayerVelY;
    private Optional<Vec3> prevPlayerPosition;
    private int ticksAcceleratingUpward;
    private boolean testing;
    private int testTimePassed;
    private boolean isTestObstructed;
    private boolean isTestObstructedSoFar;
    private int obstructionTestHeight;
    private int timeUntilHeal = 0;
    private EntityPillar.EntityPillarSculptor pillar;
    public int numLivePaths = 0;
    private HurtByTargetGoal hurtByTargetAI;
    protected Projectile guardProjectileTarget;
    public List<EntityBoulderSculptor> boulders = new ArrayList<EntityBoulderSculptor>();
    public ItemStack heldStaff;
    public GeckoDynamicChain beardChain;
    private boolean hasPingedBlockThisPass = false;
    private static RawAnimation HURT = RawAnimation.begin().thenPlay("hurt");
    private static RawAnimation TEST_OBSTRUCTED = RawAnimation.begin().thenLoop("test_obstructed");

    public EntitySculptor(EntityType<? extends MowzieEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 30;
        TEST_HEIGHT = (Integer)ConfigHandler.COMMON.MOBS.SCULPTOR.testHeight.get();
        this.heldStaff = new ItemStack((ItemLike)ItemHandler.SCULPTOR_STAFF.get());
        if (world.f_46443_) {
            this.beardChain = new GeckoDynamicChain((Entity)this);
            this.dynamicChains = new GeckoDynamicChain[]{this.beardChain};
        }
    }

    @Override
    public AbilityType getHurtAbility() {
        return HURT_ABILITY;
    }

    @Override
    public AbilityType getDeathAbility() {
        return DIE_ABILITY;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 0.06f){

            public void m_8056_() {
                this.f_25518_ = this.m_183277_(80 + this.f_25512_.m_217043_().m_188503_(80));
            }
        });
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntitySculptor>(this, START_TEST, false));
        this.f_21345_.m_25352_(1, new UseAbilityAI<EntitySculptor>(this, DIE_ABILITY));
        this.f_21345_.m_25352_(2, new UseAbilityAI<EntitySculptor>(this, HURT_ABILITY, false));
        this.f_21345_.m_25352_(4, (Goal)new RunTestGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CombatBehaviorGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GuardBehaviorGoal(this));
        this.hurtByTargetAI = new HurtByTargetGoal(this, new Class[0]){

            public void m_8056_() {
                super.m_8056_();
                Mob mob = this.f_26135_;
                if (mob instanceof EntitySculptor) {
                    EntitySculptor sculptor = (EntitySculptor)mob;
                    sculptor.setTestingPlayer(null);
                    sculptor.setCustomer(null);
                }
            }

            public boolean m_8036_() {
                return super.m_8036_() && EntitySculptor.this.getHealthRatio() < DEFENSE_HEALTH_THRESHOLD;
            }

            public boolean m_8045_() {
                LivingEntity livingentity = this.f_26135_.m_5448_();
                if (livingentity == null) {
                    livingentity = this.f_26137_;
                }
                if (livingentity == null) {
                    return false;
                }
                if (!this.f_26135_.m_6779_(livingentity)) {
                    return false;
                }
                Team team = this.f_26135_.m_5647_();
                Team team1 = livingentity.m_5647_();
                if (team != null && team1 == team) {
                    return false;
                }
                double d0 = this.m_7623_();
                double yDistMax = 70.0;
                double yBase = this.f_26135_.m_20186_();
                EntitySculptor sculptor = (EntitySculptor)this.f_26135_;
                if (sculptor.getPillar() != null) {
                    yBase = sculptor.getPillar().m_20186_();
                }
                if (this.f_26135_.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82557_(livingentity.m_20182_().m_82542_(1.0, 0.0, 1.0)) > d0 * d0 || livingentity.m_20186_() < yBase - yDistMax || livingentity.m_20186_() > this.f_26135_.m_20186_() + yDistMax) {
                    return false;
                }
                this.f_26135_.m_6710_(livingentity);
                return true;
            }
        };
        this.f_21346_.m_25352_(3, (Goal)this.hurtByTargetAI);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        Item tradeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)ConfigHandler.COMMON.MOBS.SCULPTOR.whichItem.get()));
        this.m_20088_().m_135372_(DESIRES, (Object)new ItemStack((ItemLike)tradeItem, ((Integer)ConfigHandler.COMMON.MOBS.SCULPTOR.howMany.get()).intValue()));
        this.m_20088_().m_135372_(IS_TRADING, (Object)false);
        this.m_20088_().m_135372_(IS_FIGHTING, (Object)false);
        this.m_20088_().m_135372_(TESTING_PLAYER, Optional.empty());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 140.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 60.0);
    }

    @Override
    protected <E extends GeoEntity> void loopingAnimations(AnimationState<E> event) {
        event.getController().transitionLength(10);
        if (this.isTestObstructed && !this.isFighting()) {
            this.controller.setAnimation(TEST_OBSTRUCTED);
        } else {
            super.loopingAnimations(event);
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_SCULPTOR_HURT.get();
    }

    public void m_8032_() {
        if (this.getActiveAbility() != null) {
            return;
        }
        if (!this.isFighting()) {
            if (this.isTestObstructed) {
                if ((double)this.f_19796_.m_188501_() > 0.5) {
                    this.m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_HM.get(), 1.0f, 1.0f);
                }
            } else if ((double)this.f_19796_.m_188501_() < 0.1) {
                this.sendAbilityMessage(IDLE_ABILITY);
            } else if (this.m_21563_().m_186069_()) {
                if (this.isTrading() && (double)this.f_19796_.m_188501_() > 0.5) {
                    return;
                }
                if ((double)this.f_19796_.m_188501_() > 0.4) {
                    if (!this.isTesting()) {
                        this.sendAbilityMessage(TALK_ABILITY);
                    }
                } else {
                    this.sendAbilityMessage(LAUGH_ABILITY);
                }
            }
        }
    }

    public float m_6100_() {
        return 1.0f;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_5997_(double x, double y, double z) {
        super.m_5997_(0.0, y, 0.0);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public void setDesires(ItemStack stack) {
        this.m_20088_().m_135381_(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.m_20088_().m_135370_(DESIRES);
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntitySculptor.canPayFor(input.m_7993_(), desires)) {
            input.m_6201_(desires.m_41613_());
            return true;
        }
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    @Override
    public boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.SCULPTOR.hasBossBar.get();
    }

    @Override
    public BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.GREEN;
    }

    @Override
    protected MMBossInfoServer initBossInfo() {
        return new BossInfoSculptor(this);
    }

    @Override
    public void m_8119_() {
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        super.m_8119_();
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        if (this.testingPlayer == null && this.getTestingPlayerID().isPresent()) {
            this.testingPlayer = this.m_9236_().m_46003_(this.getTestingPlayerID().get());
            if (this.testingPlayer != null) {
                this.testing = true;
            }
        }
        if (this.testingPlayer != null) {
            this.m_21563_().m_148051_((Entity)this.testingPlayer);
        } else if (this.customer != null) {
            this.m_21563_().m_148051_((Entity)this.customer);
        }
        if (!this.testing && !this.isFighting()) {
            this.checkTestObstructedAtHeight(this.obstructionTestHeight + 1);
            int height = TEST_HEIGHT + 3;
            this.obstructionTestHeight = (this.obstructionTestHeight + 1) % height;
            if (this.obstructionTestHeight == 0) {
                this.isTestObstructed = this.isTestObstructedSoFar;
                this.isTestObstructedSoFar = false;
                this.hasPingedBlockThisPass = false;
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_5448_() == null) {
            --this.timeUntilHeal;
            if (((Boolean)ConfigHandler.COMMON.MOBS.SCULPTOR.healsOutOfBattle.get()).booleanValue() && this.timeUntilHeal <= 0) {
                this.m_5634_(0.3f);
            }
        } else {
            this.timeUntilHeal = 75;
        }
        this.testTimePassed = this.isTesting() ? ++this.testTimePassed : 0;
        if (this.m_9236_().m_5776_()) {
            this.beardChain.setSimulating(this.pillar == null || this.pillar.m_213877_() || !this.getPillar().isFalling() && !this.getPillar().isRising());
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        this.timeUntilHeal = 75;
        if (this.getActiveAbilityType() == PASS_TEST || this.getActiveAbilityType() == DISAPPEAR_ABILITY) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    public boolean m_20147_() {
        return super.m_20147_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean checkTestObstructed() {
        int height = TEST_HEIGHT + 3;
        this.hasPingedBlockThisPass = false;
        for (int i = 1; i < height; ++i) {
            this.checkTestObstructedAtHeight(i);
            if (!this.isTestObstructed) continue;
            return true;
        }
        return false;
    }

    public boolean isTestObstructed() {
        return this.isTestObstructed;
    }

    private void checkTestObstructedAtHeight(int height) {
        BlockPos pos = this.m_20183_();
        int radius = TEST_RADIUS;
        for (int i = -radius; i < radius; ++i) {
            for (int j = -radius; j < radius; ++j) {
                BlockState checkState;
                Vec2 offset = new Vec2((float)i, (float)j);
                BlockPos checkPos = pos.m_7918_((int)offset.f_82470_, height, (int)offset.f_82471_);
                double testRadius = EntitySculptor.testRadiusAtHeight(height);
                if (!((double)offset.m_165912_() < testRadius * testRadius) || (checkState = this.m_9236_().m_8055_(checkPos)).m_60795_() || checkState.m_60713_(Blocks.f_152480_)) continue;
                this.isTestObstructed = true;
                this.isTestObstructedSoFar = true;
                if (!this.m_9236_().m_5776_() || !this.isPlayerInTestZone(MowziesMobs.PROXY.getPlayer()) || !this.blockHasExposedSide(checkPos)) continue;
                MowziesMobs.PROXY.sculptorMarkBlock(this.m_19879_(), checkPos);
                ParticleRotation.FaceCamera faceCamera = new ParticleRotation.FaceCamera(0.0f);
                AdvancedParticleBase.spawnAlwaysVisibleParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), 64.0, (double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 0.5, (double)checkPos.m_123343_() + 0.5, 0.0, 0.0, 0.0, faceCamera, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 20.0, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 16.0f), false)});
                if (this.hasPingedBlockThisPass) continue;
                AdvancedParticleBase.spawnAlwaysVisibleParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.ORB2.get()), 64.0, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), 0.0, 0.0, 0.0, faceCamera, 6.0, 0.83f, 1.0, 0.39f, 0.7, 1.0, 30.0, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, ParticleComponent.KeyTrack.startAndEnd((float)this.m_20185_(), (float)((double)checkPos.m_123341_() + 0.5)), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.KeyTrack.startAndEnd((float)this.m_20186_() + this.m_20206_() / 2.0f, (float)((double)checkPos.m_123342_() + 0.5)), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, ParticleComponent.KeyTrack.startAndEnd((float)this.m_20189_(), (float)((double)checkPos.m_123343_() + 0.5)), false)});
                this.hasPingedBlockThisPass = true;
            }
        }
    }

    private boolean blockHasExposedSide(BlockPos pos) {
        return !this.m_9236_().m_8055_(pos.m_122012_()).m_60815_() || !this.m_9236_().m_8055_(pos.m_122019_()).m_60815_() || !this.m_9236_().m_8055_(pos.m_122029_()).m_60815_() || !this.m_9236_().m_8055_(pos.m_122024_()).m_60815_() || !this.m_9236_().m_8055_(pos.m_7494_()).m_60815_() || !this.m_9236_().m_8055_(pos.m_7495_()).m_60815_();
    }

    private void checkIfPlayerCheats() {
        if (this.testingPlayer == null) {
            return;
        }
        if (!this.isTesting() || this.testingPlayer.m_7500_()) {
            return;
        }
        if (this.testingPlayer != null && this.testingPlayer.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82554_(this.m_20182_().m_82542_(1.0, 0.0, 1.0)) > (double)(TEST_RADIUS + 4)) {
            this.playerCheated();
            return;
        }
        if (this.testingPlayer != null && this.pillar != null && this.testingPlayer.m_20186_() < this.pillar.m_20186_() - 10.0) {
            this.playerCheated();
            return;
        }
        if (this.testingPlayer != null && this.testingPlayer.m_150110_().f_35935_) {
            this.playerCheated();
            return;
        }
        if (this.testingPlayer.m_20069_() && !this.testingPlayer.m_20096_()) {
            this.playerCheated();
            return;
        }
        if (this.testingPlayer != null && !this.testingPlayer.m_20096_()) {
            double playerVelY = this.testingPlayer.m_20184_().m_7098_();
            if (this.prevPlayerVelY != null && this.prevPlayerVelY.isPresent()) {
                double acceleration = playerVelY - this.prevPlayerVelY.get();
                if (acceleration >= 0.0) {
                    ++this.ticksAcceleratingUpward;
                } else if (this.ticksAcceleratingUpward > 0) {
                    --this.ticksAcceleratingUpward;
                }
                if (this.ticksAcceleratingUpward > 5) {
                    this.playerCheated();
                    return;
                }
            }
            this.prevPlayerVelY = Optional.of(playerVelY);
        } else {
            this.ticksAcceleratingUpward = 0;
            this.prevPlayerVelY = Optional.empty();
        }
        if (this.testingPlayer != null) {
            Vec3 predictedPosition;
            Vec3 currPosition = this.testingPlayer.m_20182_();
            if (this.prevPlayerPosition != null && this.prevPlayerPosition.isPresent() && currPosition.m_82554_(predictedPosition = this.prevPlayerPosition.get().m_82549_(this.testingPlayer.m_20184_())) > 3.0) {
                this.playerCheated();
                return;
            }
            this.prevPlayerPosition = Optional.of(this.testingPlayer.m_20182_());
        }
    }

    public void playerCheated() {
        if (this.isTesting() && this.testingPlayer != null) {
            this.sendAbilityMessage(FAIL_TEST);
        }
    }

    public float playerProgress() {
        if (this.getPillar() == null || this.getTestingPlayer() == null) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)(this.getTestingPlayer().m_20186_() - this.getPillar().m_20186_()) / (float)TEST_HEIGHT), (float)0.0f, (float)1.0f);
    }

    public static double testRadiusAtHeight(double height) {
        return (double)TEST_RADIUS_BOTTOM + Math.pow(Math.min(height / (double)TEST_MAX_RADIUS_HEIGHT, 1.0), TEST_RADIUS_FALLOFF) * (double)(TEST_RADIUS - TEST_RADIUS_BOTTOM);
    }

    public void setTrading(boolean trading) {
        this.f_19804_.m_135381_(IS_TRADING, (Object)trading);
    }

    public boolean isTrading() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRADING);
    }

    public void setFighting(boolean fighting) {
        this.f_19804_.m_135381_(IS_FIGHTING, (Object)fighting);
    }

    public boolean isFighting() {
        return (Boolean)this.f_19804_.m_135370_(IS_FIGHTING);
    }

    public Player getCustomer() {
        return this.customer;
    }

    public void setCustomer(Player customer) {
        this.setTrading(customer != null);
        this.customer = customer;
    }

    public boolean isTesting() {
        return this.getTestingPlayerID().isPresent();
    }

    public boolean isTestPassed() {
        return this.getActiveAbilityType() == PASS_TEST;
    }

    public boolean isTestFailed() {
        return this.getActiveAbilityType() == FAIL_TEST;
    }

    public boolean isTestOver() {
        return this.isTestPassed() || this.isTestFailed();
    }

    public Optional<UUID> getTestingPlayerID() {
        return (Optional)this.m_20088_().m_135370_(TESTING_PLAYER);
    }

    public void setTestingPlayerID(UUID playerID) {
        if (playerID == null) {
            this.m_20088_().m_135381_(TESTING_PLAYER, Optional.empty());
        } else {
            this.m_20088_().m_135381_(TESTING_PLAYER, Optional.of(playerID));
        }
    }

    public void setTestingPlayer(Player testingPlayer) {
        this.testingPlayer = testingPlayer;
        this.setTestingPlayerID(testingPlayer == null ? null : testingPlayer.m_20148_());
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)testingPlayer, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            playerCapability.setTestingSculptor(this);
        }
    }

    public Player getTestingPlayer() {
        return this.testingPlayer;
    }

    public void openGUI(Player playerEntity) {
        this.setCustomer(playerEntity);
        MowziesMobs.PROXY.setReferencedMob((Entity)this);
        if (!this.m_9236_().f_46443_ && this.m_5448_() == null && this.m_6084_()) {
            playerEntity.m_5893_(new MenuProvider(){

                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return new ContainerSculptorTrade(id, EntitySculptor.this, playerInventory);
                }

                public Component m_5446_() {
                    return EntitySculptor.this.m_5446_();
                }
            });
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.isTesting() && this.getPillar() != null && !this.getPillar().isRising()) {
            if (player == this.testingPlayer && this.getActiveAbilityType() != FAIL_TEST && player.m_20280_((Entity)this) <= 20.0) {
                this.sendAbilityMessage(PASS_TEST);
                if (player instanceof ServerPlayer) {
                    AdvancementHandler.SCULPTOR_CHALLENGE_TRIGGER.trigger((ServerPlayer)player);
                }
            }
        } else if (this.canTradeWith(player) && this.m_5448_() == null && this.m_6084_()) {
            this.openGUI(player);
            this.sendAbilityMessage(TALK_ABILITY);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canTradeWith(Player player) {
        return !this.isTrading() && !(this.m_21223_() <= 0.0f) && !this.testing;
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntitySculptor.canPayFor(stack, this.getDesires());
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.m_41720_() == worth.m_41720_() && stack.m_41613_() >= worth.m_41613_();
    }

    public EntityPillar.EntityPillarSculptor getPillar() {
        return this.pillar;
    }

    public void setPillar(EntityPillar.EntityPillarSculptor pillar) {
        this.pillar = pillar;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        this.controller.setSoundKeyframeHandler(state -> {
            String sound = state.getKeyframeData().getSound();
            if (sound.equals("make_gauntlet_effects")) {
                this.m_9236_().m_6263_(MowziesMobs.PROXY.getPlayer(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MMSounds.ENTITY_SCULPTOR_MAKE_GAUNTLET_EFFECTS.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (sound.equals("make_gauntlet_piece")) {
                this.m_9236_().m_6263_(MowziesMobs.PROXY.getPlayer(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MMSounds.ENTITY_SCULPTOR_MAKE_GAUNTLET_PIECE.get(), SoundSource.NEUTRAL, 1.0f, 0.7f + 0.6f * this.f_19796_.m_188501_());
            } else if (sound.equals("clap1")) {
                this.m_9236_().m_6263_(MowziesMobs.PROXY.getPlayer(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MMSounds.ENTITY_SCULPTOR_CLAP.get(), SoundSource.NEUTRAL, 1.0f, 0.7f + 0.6f * this.f_19796_.m_188501_());
            }
        });
    }

    @Override
    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[]{START_TEST, FAIL_TEST, PASS_TEST, HURT_ABILITY, DIE_ABILITY, ATTACK_ABILITY, GUARD_ABILITY, DISAPPEAR_ABILITY, TALK_ABILITY, IDLE_ABILITY, LAUGH_ABILITY};
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.testingPlayer != null && this.getTestingPlayerID().isPresent()) {
            compound.m_128362_("TestingPlayer", this.getTestingPlayerID().get());
            compound.m_128405_("NumLivePaths", this.numLivePaths);
        }
        compound.m_128405_("TestTimePassed", this.testTimePassed);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TestingPlayer")) {
            this.testing = true;
            this.setTestingPlayerID(compound.m_128342_("TestingPlayer"));
            this.numLivePaths = compound.m_128451_("NumLivePaths");
        }
        this.testTimePassed = compound.m_128451_("TestTimePassed");
    }

    public boolean isPlayerInTestZone(Player player) {
        double yDistMax = 12.0;
        double yBase = this.m_20186_();
        if (this.getPillar() != null) {
            yBase = this.getPillar().m_20186_();
        }
        return player.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82557_(this.m_20182_().m_82542_(1.0, 0.0, 1.0)) < (double)(TEST_RADIUS * TEST_RADIUS + 9) && player.m_20186_() > yBase - yDistMax && player.m_20186_() < yBase + (double)TEST_HEIGHT + yDistMax;
    }

    @Override
    protected int getDeathDuration() {
        AbilityType deathAbilityType = this.getDeathAbility();
        Ability deathAbility = this.getAbility(deathAbilityType);
        if (deathAbility == null || !deathAbility.isUsing()) {
            return 9;
        }
        if (deathAbility.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
            return deathAbility.getTicksInUse() - deathAbility.getTicksInSection() + 84;
        }
        return 94;
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.SCULPTOR;
    }

    public int getTestTimePassed() {
        return this.testTimePassed;
    }

    public int getMaxTestTime() {
        return (Integer)ConfigHandler.COMMON.MOBS.SCULPTOR.testTimeLimit.get() * 20;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BossMusic getBossMusic() {
        return BossMusicPlayer.SCULPTOR_MUSIC;
    }

    @Override
    public boolean hasBossMusic() {
        return true;
    }

    @Override
    protected boolean canPlayMusic() {
        if (this.isTesting() && !this.isTestFailed()) {
            return true;
        }
        return super.canPlayMusic();
    }

    @Override
    public boolean canPlayerHearMusic(Player player) {
        return player != null && (this.m_6779_((LivingEntity)player) || this.isTesting()) && this.m_20270_((Entity)player) < 2500.0f;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public static class RunTestGoal
    extends Goal {
        private final EntitySculptor sculptor;

        RunTestGoal(EntitySculptor sculptor) {
            this.sculptor = sculptor;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.sculptor.testingPlayer != null && this.sculptor.testingPlayer.m_6084_() && !this.sculptor.testingPlayer.m_213877_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.sculptor.testing = true;
            this.sculptor.sendAbilityMessage(START_TEST);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.sculptor.testingPlayer == null) {
                this.sculptor.sendAbilityMessage(FAIL_TEST);
                this.sculptor.prevPlayerPosition = Optional.empty();
                this.sculptor.prevPlayerVelY = Optional.empty();
            } else if (this.sculptor.testing) {
                this.sculptor.checkIfPlayerCheats();
            }
            if (this.sculptor.getTestTimePassed() > this.sculptor.getMaxTestTime()) {
                this.sculptor.sendAbilityMessage(FAIL_TEST);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.sculptor.setTestingPlayer(null);
            this.sculptor.testing = false;
        }
    }

    public static class CombatBehaviorGoal
    extends Goal {
        private final EntitySculptor sculptor;

        public CombatBehaviorGoal(EntitySculptor sculptor) {
            this.sculptor = sculptor;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.sculptor.m_5448_();
            return target != null && target.m_6084_();
        }

        public boolean m_8045_() {
            return super.m_8045_() || this.sculptor.getActiveAbilityType() == ATTACK_ABILITY || this.sculptor.getActiveAbilityType() == GUARD_ABILITY;
        }

        public void m_8056_() {
            super.m_8056_();
            this.sculptor.setFighting(true);
            if (this.sculptor.getPillar() != null && !this.sculptor.getPillar().m_213877_() && this.sculptor.getPillar().getHeight() < (float)TEST_HEIGHT) {
                this.sculptor.getPillar().startRising();
            } else {
                this.sculptor.sendAbilityMessage(START_TEST);
            }
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.sculptor.getActiveAbility() == null) {
                AbilityHandler.INSTANCE.sendAbilityMessage(this.sculptor, ATTACK_ABILITY);
            }
            if (this.sculptor.boulders.isEmpty() && this.sculptor.getActiveAbilityType() != START_TEST) {
                StartTestAbility.placeStartingBoulders(this.sculptor);
            }
            if (this.sculptor.m_5448_() != null && this.sculptor.getActiveAbilityType() != GUARD_ABILITY) {
                this.sculptor.m_21563_().m_24960_((Entity)this.sculptor.m_5448_(), 30.0f, 30.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.sculptor.setFighting(false);
            this.sculptor.sendAbilityMessage(FAIL_TEST);
        }
    }

    public static class GuardBehaviorGoal
    extends Goal {
        private final EntitySculptor sculptor;
        protected final Predicate<Projectile> guardTargetSelector;
        private static final float GUARD_DISTANCE = 8.0f;

        public GuardBehaviorGoal(EntitySculptor sculptor) {
            this.sculptor = sculptor;
            this.guardTargetSelector = target -> {
                Vec3 aActualMotion = new Vec3(target.m_20185_() - target.f_19854_, target.m_20186_() - target.f_19855_, target.m_20189_() - target.f_19856_);
                if (aActualMotion.m_82553_() < 0.1 || target.f_19797_ < 0) {
                    return false;
                }
                if (aActualMotion.m_82553_() * 9.0 < target.m_20182_().m_82554_(sculptor.m_20182_())) {
                    return false;
                }
                if (!sculptor.m_21574_().m_148306_((Entity)target)) {
                    return false;
                }
                float dot = (float)target.m_20184_().m_82541_().m_82526_(sculptor.m_20182_().m_82546_(target.m_20182_()).m_82541_());
                return !((double)dot < 0.8);
            };
        }

        public boolean m_8036_() {
            this.sculptor.guardProjectileTarget = this.getMostMovingTowardsMeEntity(Projectile.class, this.guardTargetSelector, (LivingEntity)this.sculptor, this.sculptor.m_20191_().m_82377_(8.0, 8.0, 8.0));
            return this.sculptor.guardProjectileTarget != null;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.sculptor.guardProjectileTarget != null) {
                AbilityHandler.INSTANCE.sendAbilityMessage(this.sculptor, GUARD_ABILITY);
            }
        }

        public boolean m_8045_() {
            return this.sculptor.getActiveAbilityType() == GUARD_ABILITY;
        }

        public void m_8041_() {
            super.m_8041_();
            AbilityHandler.INSTANCE.sendInterruptAbilityMessage(this.sculptor, GUARD_ABILITY);
        }

        @Nullable
        private <T extends Projectile> T getMostMovingTowardsMeEntity(Class<? extends T> entityClazz, Predicate<? super T> predicate, LivingEntity entity, AABB p_225318_10_) {
            return this.getMostMovingTowardsMeEntityFromList(entity.m_9236_().m_6443_(entityClazz, p_225318_10_, predicate), entity);
        }

        private <T extends Projectile> T getMostMovingTowardsMeEntityFromList(List<? extends T> entities, LivingEntity target) {
            double d0 = -2.0;
            Projectile t = null;
            for (Projectile t1 : entities) {
                double d1 = t1.m_20184_().m_82541_().m_82526_(target.m_20182_().m_82546_(t1.m_20182_()).m_82541_());
                if (!(d1 > d0)) continue;
                d0 = d1;
                t = t1;
            }
            return (T)t;
        }
    }

    public static class GuardAbility
    extends Ability<EntitySculptor> {
        private EntityBoulderProjectile boulder;
        private UUID boulderID;
        private Entity target;
        private Vec3 prevTargetPos;
        private static final RawAnimation BLOCK = RawAnimation.begin().thenPlay("guard");

        public GuardAbility(AbilityType abilityType, EntitySculptor user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 11), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 17)});
        }

        @Override
        public void start() {
            super.start();
            this.playAnimation(BLOCK);
            if (!((EntitySculptor)this.getUser()).m_9236_().m_5776_()) {
                this.target = ((EntitySculptor)this.getUser()).guardProjectileTarget.m_19749_();
                if (this.target != null) {
                    this.prevTargetPos = this.target.m_20182_().m_82520_(0.0, (double)this.target.m_20206_() / 2.0, 0.0);
                }
            }
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getBoulder() != null && this.target != null) {
                ((EntitySculptor)this.getUser()).m_21563_().m_24960_(this.target, 60.0f, 60.0f);
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (!((EntitySculptor)this.getUser()).m_9236_().m_5776_()) {
                if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                    this.boulder = new EntityBoulderProjectile((EntityType<? extends EntityBoulderProjectile>)((EntityType)EntityHandler.BOULDER_PROJECTILE.get()), ((EntitySculptor)this.getUser()).m_9236_(), (LivingEntity)this.getUser(), Blocks.f_50069_.m_49966_(), BlockPos.f_121853_, EntityGeomancyBase.GeomancyTier.SMALL);
                    Vec3 betweenSculptorAndProjectile = ((EntitySculptor)this.getUser()).guardProjectileTarget.m_20182_().m_82546_(((EntitySculptor)this.getUser()).m_20182_()).m_82541_();
                    this.boulder.m_146884_(((EntitySculptor)this.getUser()).m_20182_().m_82520_(0.0, (double)(((EntitySculptor)this.getUser()).m_20206_() / 2.0f), 0.0).m_82549_(betweenSculptorAndProjectile.m_82490_(2.0).m_82492_(0.0, (double)(this.boulder.m_20206_() / 2.0f), 0.0)));
                    this.boulder.activate();
                    ((EntitySculptor)this.getUser()).m_9236_().m_7967_((Entity)this.boulder);
                    this.boulderID = this.boulder.m_20148_();
                } else if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.getBoulder() != null) {
                    if (this.target != null && !this.target.m_213877_() && this.target instanceof LivingEntity) {
                        AttackAbility.shootBoulderAtTarget((LivingEntity)this.target, this.prevTargetPos, this.getBoulder(), 0.45f);
                        ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_ATTACK.get(), 2.0f, 0.95f + ((EntitySculptor)this.getUser()).f_19796_.m_188501_() * 0.1f);
                    } else {
                        this.getBoulder().explode();
                    }
                }
            }
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag nbt = super.writeNBT();
            if (this.boulderID != null) {
                nbt.m_128362_("boulder_guard", this.boulderID);
            }
            return nbt;
        }

        @Override
        public void readNBT(Tag nbt) {
            super.readNBT(nbt);
            CompoundTag compound = (CompoundTag)nbt;
            if (compound.m_128403_("boulder_guard")) {
                this.boulderID = compound.m_128342_("boulder_guard");
            }
        }

        public EntityBoulderProjectile getBoulder() {
            if (this.boulder != null && !this.boulder.m_213877_()) {
                return this.boulder;
            }
            if (this.boulderID != null && ((EntitySculptor)this.getUser()).m_9236_() instanceof ServerLevel) {
                Entity entity = ((ServerLevel)((EntitySculptor)this.getUser()).m_9236_()).m_8791_(this.boulderID);
                if (entity instanceof EntityBoulderProjectile) {
                    this.boulder = (EntityBoulderProjectile)entity;
                }
                return this.boulder;
            }
            return null;
        }

        @Override
        public boolean canCancelActiveAbility() {
            return ((EntitySculptor)this.getUser()).getActiveAbilityType() == ATTACK_ABILITY || ((EntitySculptor)this.getUser()).getActiveAbilityType() == HURT_ABILITY;
        }

        @Override
        public void end() {
            super.end();
            if (this.getBoulder() != null) {
                this.getBoulder().explode();
            }
        }
    }

    public static class DisappearAbility
    extends SimpleAnimationAbility<EntitySculptor> {
        private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");

        public DisappearAbility(AbilityType abilityType, EntitySculptor user) {
            super(abilityType, user, DISAPPEAR, 80);
        }

        @Override
        public void start() {
            super.start();
            if (((EntitySculptor)this.getUser()).m_9236_() instanceof ServerLevel) {
                ItemStack heldStaff = ((EntitySculptor)this.getUser()).heldStaff;
                ItemSculptorStaff staffItem = (ItemSculptorStaff)heldStaff.m_41720_();
                staffItem.triggerAnim((Entity)this.getUser(), GeoItem.getOrAssignId((ItemStack)heldStaff, (ServerLevel)((ServerLevel)((EntitySculptor)this.getUser()).m_9236_())), "controller", "disappear");
            }
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            int start = 1;
            int end = 70;
            if (this.getLevel().m_5776_() && this.getTicksInUse() > start && this.getTicksInUse() < end) {
                float z;
                float y;
                float x;
                AABB bounds;
                int i;
                float a = ((float)this.getTicksInUse() - (float)start) / (float)(end - start);
                float spawnRate = 15.0f * (float)Math.pow(2.0, -(Math.pow((double)a - 0.5, 2.0) / 0.05));
                Vec3 windForce = new Vec3(1.0, 0.0, 0.0).m_82524_((float)Math.toRadians(-((EntitySculptor)this.getUser()).f_20883_));
                windForce = windForce.m_82520_(0.0, 0.5, 0.0).m_82541_().m_82490_(0.01);
                for (i = 0; i < (int)spawnRate; ++i) {
                    bounds = ((EntitySculptor)this.getUser()).m_20191_();
                    x = (float)(((EntitySculptor)this.getUser()).m_20185_() + ((EntitySculptor)this.getUser()).f_19796_.m_188583_() * (bounds.f_82291_ - bounds.f_82288_) / 3.0);
                    y = (float)(((EntitySculptor)this.getUser()).m_20186_() + ((EntitySculptor)this.getUser()).f_19796_.m_188583_() * (bounds.f_82292_ - bounds.f_82289_) / 5.0 + (double)((EntitySculptor)this.getUser()).m_20206_() / 2.0);
                    z = (float)(((EntitySculptor)this.getUser()).m_20189_() + ((EntitySculptor)this.getUser()).f_19796_.m_188583_() * (bounds.f_82293_ - bounds.f_82290_) / 3.0);
                    double colorVariation = ((EntitySculptor)this.getUser()).f_19796_.m_188500_() * 10.0;
                    double yaw = ((EntitySculptor)this.getUser()).f_19796_.m_188500_() * Math.PI / 2.0;
                    double pitch = ((EntitySculptor)this.getUser()).f_19796_.m_188500_() * Math.PI / 2.0;
                    double roll = ((EntitySculptor)this.getUser()).f_19796_.m_188500_() * Math.PI / 2.0;
                    AdvancedParticleBase.spawnParticle(((EntitySculptor)this.getUser()).m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.LEAF.get()), x, y, z, 0.0, 0.0, 0.0, false, yaw, pitch, roll, 0.0, 1.0, (247.0 + colorVariation) / 256.0, (185.0 + colorVariation) / 256.0, (220.0 + colorVariation) / 256.0, 1.0, 0.9, 35.0f + ((EntitySculptor)this.getUser()).f_19796_.m_188501_() * 20.0f, false, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.CurlNoise(0.01f, 4.0f), new ParticleComponent.ForceOverTime(windForce), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.YAW, new ParticleComponent.Constant(0.04f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.PITCH, new ParticleComponent.Constant(0.025f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ROLL, new ParticleComponent.Constant(0.01f), true)});
                }
                for (i = 0; i < (int)spawnRate / 2; ++i) {
                    bounds = ((EntitySculptor)this.getUser()).m_20191_();
                    x = (float)(((EntitySculptor)this.getUser()).m_20185_() + ((EntitySculptor)this.getUser()).f_19796_.m_188583_() * (bounds.f_82291_ - bounds.f_82288_) / 3.0);
                    y = (float)(((EntitySculptor)this.getUser()).m_20186_() + ((EntitySculptor)this.getUser()).f_19796_.m_188583_() * (bounds.f_82292_ - bounds.f_82289_) / 5.0 + (double)((EntitySculptor)this.getUser()).m_20206_() / 2.0);
                    z = (float)(((EntitySculptor)this.getUser()).m_20189_() + ((EntitySculptor)this.getUser()).f_19796_.m_188583_() * (bounds.f_82293_ - bounds.f_82290_) / 3.0);
                    AdvancedParticleBase.spawnParticle(((EntitySculptor)this.getUser()).m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), x, y, z, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 1.0, 0.99609375, 0.96875, 0.578125, 1.0, 0.9, 35.0f + ((EntitySculptor)this.getUser()).f_19796_.m_188501_() * 20.0f, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 2.0f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.CurlNoise(0.01f, 4.0f), new ParticleComponent.ForceOverTime(windForce)});
                }
            }
            if (this.getTicksInUse() == 8) {
                ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_DISAPPEAR_EFFECTS.get());
            }
            if (this.getTicksInUse() == 15) {
                ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_DISAPPEAR.get());
            }
        }

        @Override
        public void end() {
            super.end();
            ((EntitySculptor)this.getUser()).m_142687_(Entity.RemovalReason.KILLED);
        }

        @Override
        public boolean canCancelActiveAbility() {
            return false;
        }
    }

    public static class SculptorDieAbility
    extends Ability<EntitySculptor> {
        private static AbilitySection.AbilitySectionDuration END_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 85);
        private static final RawAnimation DEATH_START = RawAnimation.begin().thenPlayAndHold("death_start");
        private static final RawAnimation DEATH_END = RawAnimation.begin().thenPlayAndHold("death_end");

        public SculptorDieAbility(AbilityType abilityType, EntitySculptor user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 9), new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE), END_SECTION});
        }

        @Override
        public void start() {
            super.start();
            this.playAnimation(DEATH_START);
            ((EntitySculptor)this.getUser()).m_6677_(((EntitySculptor)this.getUser()).m_269291_().m_269264_());
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && ((EntitySculptor)this.getUser()).m_20096_()) {
                this.nextSection();
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY && this.getTicksInSection() == 20) {
                ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_DEATH.get());
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
                this.playAnimation(DEATH_END);
                ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.MISC_GROUNDHIT_1.get(), 1.0f, 1.2f);
                ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_HURT.get());
            }
        }

        @Override
        public boolean canCancelActiveAbility() {
            return true;
        }
    }

    public static class AttackAbility
    extends Ability<EntitySculptor> {
        private EntityBoulderSculptor boulderToFire;
        private Vec3 prevTargetPos;
        private static final int STARTUP_TIME = 5;
        private WhichHand whichHand = WhichHand.NONE;
        private static RawAnimation ATTACK_START = RawAnimation.begin().thenPlayAndHold("attack_start");
        private static RawAnimation ATTACK_LEFT = RawAnimation.begin().thenPlayAndHold("attack_left");
        private static RawAnimation ATTACK_RIGHT = RawAnimation.begin().thenPlayAndHold("attack_right");
        private static RawAnimation ATTACK_LEFT_END = RawAnimation.begin().thenPlayAndHold("attack_left_end");
        private static RawAnimation ATTACK_RIGHT_END = RawAnimation.begin().thenPlayAndHold("attack_right_end");

        public AttackAbility(AbilityType abilityType, EntitySculptor user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 5), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 7), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 11)});
        }

        @Override
        public void start() {
            super.start();
        }

        @Override
        public boolean canUse() {
            LivingEntity target = ((EntitySculptor)this.getUser()).m_5448_();
            if (target != null) {
                Collections.shuffle(((EntitySculptor)this.getUser()).boulders);
                for (EntityBoulderSculptor boulder : ((EntitySculptor)this.getUser()).boulders) {
                    if (boulder == null || boulder.isTravelling() || boulder.m_213877_() || !boulder.isFinishedRising() || !boulder.isActive() || boulder.m_20182_().m_82520_(0.0, (double)boulder.m_20206_(), 0.0).m_82557_(target.m_20182_()) < 9.0) continue;
                    Vec3 vecBetweenSculptorAndTarget = ((EntitySculptor)this.getUser()).m_5448_().m_20182_().m_82546_(((EntitySculptor)this.getUser()).m_20182_()).m_82541_();
                    Vec3 vecBetweenSculptorAndBoulder = boulder.m_20182_().m_82546_(((EntitySculptor)this.getUser()).m_20182_()).m_82541_();
                    if (!(vecBetweenSculptorAndBoulder.m_82526_(vecBetweenSculptorAndTarget) > 0.5)) continue;
                    this.boulderToFire = boulder;
                    break;
                }
                if (this.boulderToFire == null) {
                    return false;
                }
                this.prevTargetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0);
                return super.canUse();
            }
            return false;
        }

        @Override
        public boolean canCancelSelf() {
            return true;
        }

        @Override
        public boolean canCancelActiveAbility() {
            return ((EntitySculptor)this.getUser()).getActiveAbilityType() == ATTACK_ABILITY;
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP && this.getTicksInSection() == 4 && (double)((EntitySculptor)this.getUser()).f_19796_.m_188501_() > 0.66) {
                ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_ATTACK.get(), 2.0f, 0.95f + ((EntitySculptor)this.getUser()).f_19796_.m_188501_() * 0.1f);
            }
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                if (this.whichHand == WhichHand.NONE) {
                    this.playAnimation(ATTACK_START);
                    this.whichHand = WhichHand.LEFT;
                } else if (this.whichHand == WhichHand.LEFT) {
                    this.playAnimation(ATTACK_RIGHT);
                    this.whichHand = WhichHand.RIGHT;
                } else {
                    this.playAnimation(ATTACK_LEFT);
                    this.whichHand = WhichHand.LEFT;
                }
            }
            if (!((EntitySculptor)this.getUser()).m_9236_().m_5776_() && ((EntitySculptor)this.getUser()).m_5448_() != null) {
                LivingEntity target = ((EntitySculptor)this.getUser()).m_5448_();
                if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                    AttackAbility.shootBoulderAtTarget(target, this.prevTargetPos, this.boulderToFire, 0.93f);
                    this.boulderToFire = null;
                }
            }
            if (section.sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
                if (!((EntitySculptor)this.getUser()).m_9236_().m_5776_() && ((EntitySculptor)this.getUser()).m_5448_() != null && this.canUse()) {
                    AbilityHandler.INSTANCE.sendJumpToSectionMessage((EntitySculptor)this.getUser(), this.getAbilityType(), 0);
                } else if (this.whichHand == WhichHand.LEFT) {
                    this.playAnimation(ATTACK_LEFT_END);
                } else {
                    this.playAnimation(ATTACK_RIGHT_END);
                }
            }
        }

        @Override
        public void end() {
            super.end();
            this.whichHand = WhichHand.NONE;
        }

        public static void shootBoulderAtTarget(LivingEntity target, Vec3 prevTargetPos, EntityBoulderProjectile boulderToFire, float timeScale) {
            if (boulderToFire == null) {
                return;
            }
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0);
            double timeToReach = boulderToFire.m_20182_().m_82546_(targetPos).m_82553_() / (double)boulderToFire.getSpeed();
            Vec3 targetMovement = targetPos.m_82546_(prevTargetPos).m_82490_(timeToReach * (double)timeScale * 1.0 / 4.0);
            targetMovement = targetMovement.m_82542_(1.0, 0.0, 1.0);
            Vec3 futureTargetPos = targetPos.m_82549_(targetMovement);
            Vec3 projectileMid = boulderToFire.m_20182_().m_82520_(0.0, (double)boulderToFire.m_20206_() / 2.0, 0.0);
            Vec3 shootVec = futureTargetPos.m_82546_(projectileMid).m_82541_();
            boulderToFire.shoot(shootVec.m_82490_((double)boulderToFire.getSpeed()));
        }

        private static enum WhichHand {
            NONE,
            LEFT,
            RIGHT;

        }
    }

    public static class PassTestAbility
    extends EndTestAbility {
        private static final RawAnimation TEST_PASS_START = RawAnimation.begin().then("test_pass_start", Animation.LoopType.HOLD_ON_LAST_FRAME);
        private static RawAnimation TEST_PASS_END = RawAnimation.begin().thenLoop("test_pass_end");

        public PassTestAbility(AbilityType<EntitySculptor, PassTestAbility> abilityType, EntitySculptor user) {
            super(abilityType, user, 150);
        }

        @Override
        public void start() {
            ((EntitySculptor)this.getUser()).m_20331_(true);
            if (((EntitySculptor)this.getUser()).testingPlayer != null) {
                List platforms = ((EntitySculptor)this.getUser()).m_9236_().m_45976_(EntityBoulderSculptor.class, ((EntitySculptor)this.getUser()).testingPlayer.m_20191_().m_82363_(0.0, -6.0, 0.0));
                if (!platforms.isEmpty()) {
                    EntityBoulderSculptor platformBelowPlayer = (EntityBoulderSculptor)platforms.get(0);
                    platformBelowPlayer.descend();
                }
                ((EntitySculptor)this.getUser()).testingPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19591_, (int)((float)TEST_HEIGHT / 5.0f) * 20, 0, false, false));
            }
            super.start();
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.getTicksInSection() == 15) {
                ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_CONGRATS.get());
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY && this.getTicksInSection() == 40) {
                ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_MAKE_GAUNTLET.get());
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY && this.getTicksInSection() == 134 && !((EntitySculptor)this.getUser()).m_9236_().m_5776_()) {
                Vec3 polarOffset = new Vec3(1.2, 0.0, 0.0).m_82524_((float)Math.toRadians(-((EntitySculptor)this.getUser()).f_20883_ - 90.0f));
                Vec3 itemPos = ((EntitySculptor)this.getUser()).m_20182_().m_82520_(0.0, 1.2, 0.0).m_82549_(polarOffset);
                Vec3 itemVelocity = new Vec3((double)0.1f, (double)0.1f, 0.0).m_82524_((float)Math.toRadians(-((EntitySculptor)this.getUser()).f_20883_ - 90.0f));
                ItemEntity itementity = new ItemEntity(((EntitySculptor)this.getUser()).m_9236_(), itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, ((ItemEarthrendGauntlet)((Object)ItemHandler.EARTHREND_GAUNTLET.get())).m_7968_(), itemVelocity.f_82479_, itemVelocity.f_82480_, itemVelocity.f_82481_);
                itementity.m_32060_();
                if (((EntitySculptor)this.getUser()).captureDrops() != null) {
                    ((EntitySculptor)this.getUser()).captureDrops().add(itementity);
                } else {
                    ((EntitySculptor)this.getUser()).m_9236_().m_7967_((Entity)itementity);
                }
            }
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.getTicksInSection() % 9 == 0) {
                ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_CLAP.get(), 1.0f, 0.8f + ((EntitySculptor)this.getUser()).f_19796_.m_188501_() * 0.3f);
            }
        }

        @Override
        public boolean canCancelActiveAbility() {
            return true;
        }

        @Override
        protected void playStartingAnimation() {
            this.playAnimation(TEST_PASS_START);
        }

        @Override
        protected void playFinishingAnimation() {
            this.playAnimation(TEST_PASS_END);
        }

        @Override
        public void end() {
            super.end();
            if (((Boolean)ConfigHandler.COMMON.MOBS.SCULPTOR.disappearAfterReward.get()).booleanValue()) {
                AbilityHandler.INSTANCE.sendAbilityMessage((EntitySculptor)this.getUser(), DISAPPEAR_ABILITY);
            }
        }
    }

    public static class FailTestAbility
    extends EndTestAbility {
        private static final RawAnimation TEST_FAIL_START = RawAnimation.begin().then("test_fail_start", Animation.LoopType.HOLD_ON_LAST_FRAME);
        private static RawAnimation TEST_FAIL_END = RawAnimation.begin().thenLoop("test_fail_end");

        public FailTestAbility(AbilityType<EntitySculptor, ? extends EndTestAbility> abilityType, EntitySculptor user) {
            super(abilityType, user, 30);
        }

        @Override
        protected void playStartingAnimation() {
            this.playAnimation(TEST_FAIL_START);
        }

        @Override
        protected void playFinishingAnimation() {
            this.playAnimation(TEST_FAIL_END);
            ((EntitySculptor)this.getUser()).m_216990_((SoundEvent)MMSounds.ENTITY_SCULPTOR_DISAPPOINT.get());
        }
    }

    public static abstract class EndTestAbility
    extends Ability<EntitySculptor> {
        public EndTestAbility(AbilityType<EntitySculptor, ? extends EndTestAbility> abilityType, EntitySculptor user, int recoveryDuration) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, recoveryDuration)});
        }

        @Override
        public boolean tryAbility() {
            return true;
        }

        @Override
        public void start() {
            super.start();
            this.playStartingAnimation();
            if (((EntitySculptor)this.getUser()).pillar != null) {
                ((EntitySculptor)this.getUser()).pillar.startFalling();
            }
            ((EntitySculptor)this.getUser()).testing = false;
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                if (!((EntitySculptor)this.getUser()).m_9236_().m_5776_() && ((EntitySculptor)this.getUser()).pillar != null && ((EntitySculptor)this.getUser()).pillar.getHeight() > 1.0f) {
                    ((EntitySculptor)this.getUser()).m_146884_(((EntitySculptor)this.getUser()).pillar.m_20182_().m_82520_(0.0, (double)((EntitySculptor)this.getUser()).pillar.getHeight() + 0.2, 0.0));
                }
                if (((EntitySculptor)this.getUser()).pillar == null || ((EntitySculptor)this.getUser()).pillar.m_213877_()) {
                    AbilityHandler.INSTANCE.sendJumpToSectionMessage((EntitySculptor)this.getUser(), this.getAbilityType(), 1);
                }
            }
        }

        @Override
        protected boolean canContinueUsing() {
            return super.canContinueUsing() && ((EntitySculptor)this.getUser()).m_5448_() == null;
        }

        @Override
        public void end() {
            super.end();
            if (this.getUser() != null) {
                ((EntitySculptor)this.getUser()).pillar = null;
                ((EntitySculptor)this.getUser()).setTestingPlayer(null);
                ((EntitySculptor)this.getUser()).testing = false;
                ((EntitySculptor)this.getUser()).numLivePaths = 0;
            }
        }

        @Override
        public boolean canCancelActiveAbility() {
            return true;
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (section.sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
                this.playFinishingAnimation();
            }
        }

        protected abstract void playFinishingAnimation();

        protected abstract void playStartingAnimation();
    }

    public static class StartTestAbility
    extends Ability<EntitySculptor> {
        private static int MAX_RANGE_TO_GROUND = 12;
        private BlockPos spawnPillarPos;
        private BlockState spawnPillarBlock;
        private static final RawAnimation TEST_START_ANIM = RawAnimation.begin().then("testStart", Animation.LoopType.PLAY_ONCE);

        public StartTestAbility(AbilityType<EntitySculptor, StartTestAbility> abilityType, EntitySculptor user) {
            super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 18), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, 34)});
        }

        @Override
        public boolean tryAbility() {
            Vec3 from = ((EntitySculptor)this.getUser()).m_20182_();
            Vec3 to = from.m_82492_(0.0, (double)MAX_RANGE_TO_GROUND, 0.0);
            BlockHitResult result = ((EntitySculptor)this.getUser()).m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
            if (result.m_6662_() != HitResult.Type.MISS) {
                BlockState blockAbove;
                this.spawnPillarPos = result.m_82425_();
                this.spawnPillarBlock = ((EntitySculptor)this.getUser()).m_9236_().m_8055_(this.spawnPillarPos);
                return result.m_82434_() == Direction.UP || !(blockAbove = ((EntitySculptor)this.getUser()).m_9236_().m_8055_(this.spawnPillarPos.m_7494_())).m_60828_((BlockGetter)((EntitySculptor)this.getUser()).m_9236_(), this.spawnPillarPos.m_7494_()) && !blockAbove.m_60795_();
            }
            return false;
        }

        @Override
        public void start() {
            super.start();
            this.playAnimation(TEST_START_ANIM);
            ((EntitySculptor)this.getUser()).prevPlayerPosition = Optional.empty();
            ((EntitySculptor)this.getUser()).prevPlayerVelY = Optional.empty();
        }

        public static void placeStartingBoulders(EntitySculptor sculptor) {
            if (sculptor.pillar == null) {
                return;
            }
            RandomSource rand = sculptor.m_217043_();
            int numStartBoulders = rand.m_216339_(2, 5);
            float angleOffset = rand.m_188501_() * ((float)Math.PI * 2);
            for (int i = 0; i < numStartBoulders; ++i) {
                float angleInc = (float)Math.PI * 2 / ((float)numStartBoulders * 2.0f);
                float angle = angleOffset + angleInc * (float)(i * 2) + rand.m_188501_() * angleInc;
                Vec3 spawnBoulderPos = sculptor.pillar.m_20182_().m_82549_(new Vec3((double)(rand.m_188501_() * 3.0f + 3.0f), 0.0, 0.0).m_82524_(angle));
                EntityBoulderSculptor boulderPlatform = new EntityBoulderSculptor((EntityType<? extends EntityBoulderSculptor>)((EntityType)EntityHandler.BOULDER_SCULPTOR.get()), sculptor.m_9236_(), (LivingEntity)sculptor, Blocks.f_50069_.m_49966_(), BlockPos.f_121853_, EntityGeomancyBase.GeomancyTier.MEDIUM);
                boulderPlatform.m_146884_(spawnBoulderPos.m_82520_(0.0, 1.0, 0.0));
                if (i == 0) {
                    boulderPlatform.setMainPath();
                }
                sculptor.m_9236_().m_7967_((Entity)boulderPlatform);
            }
            sculptor.numLivePaths = numStartBoulders;
        }

        @Override
        protected void beginSection(AbilitySection section) {
            super.beginSection(section);
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                ((EntitySculptor)this.getUser()).m_5496_((SoundEvent)MMSounds.ENTITY_SCULPTOR_TEST_START.get(), 1.0f, 1.0f);
            }
            if (!((EntitySculptor)this.getUser()).m_9236_().m_5776_() && section.sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.spawnPillarPos != null) {
                if (this.spawnPillarBlock == null || !EffectGeomancy.isBlockUseable(this.spawnPillarBlock)) {
                    this.spawnPillarBlock = Blocks.f_50069_.m_49966_();
                }
                ((EntitySculptor)this.getUser()).pillar = new EntityPillar.EntityPillarSculptor((EntityType<? extends EntityPillar.EntityPillarSculptor>)((EntityType)EntityHandler.PILLAR_SCULPTOR.get()), ((EntitySculptor)this.getUser()).m_9236_(), (LivingEntity)this.getUser(), Blocks.f_50069_.m_49966_(), this.spawnPillarPos);
                ((EntitySculptor)this.getUser()).pillar.setTier(EntityGeomancyBase.GeomancyTier.SMALL);
                ((EntitySculptor)this.getUser()).pillar.m_6034_((float)this.spawnPillarPos.m_123341_() + 0.5f, this.spawnPillarPos.m_123342_() + 1, (float)this.spawnPillarPos.m_123343_() + 0.5f);
                ((EntitySculptor)this.getUser()).pillar.setDoRemoveTimer(false);
                if (((EntitySculptor)this.getUser()).pillar.checkCanSpawn()) {
                    ((EntitySculptor)this.getUser()).m_9236_().m_7967_((Entity)((EntitySculptor)this.getUser()).pillar);
                }
                StartTestAbility.placeStartingBoulders((EntitySculptor)this.getUser());
            }
        }

        @Override
        public void tickUsing() {
            super.tickUsing();
            if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
                List<LivingEntity> livingEntities = ((EntitySculptor)this.getUser()).getEntityLivingBaseNearby(5.0, 5.0, 5.0, 5.0);
                for (LivingEntity livingEntity : livingEntities) {
                    Vec3 userPos = ((EntitySculptor)this.getUser()).m_20182_().m_82542_(1.0, 0.0, 1.0);
                    Vec3 entityPos = livingEntity.m_20182_().m_82542_(1.0, 0.0, 1.0);
                    Vec3 vec = userPos.m_82546_(entityPos).m_82541_().m_82490_(-Math.min(1.0 / userPos.m_82557_(entityPos), 2.0));
                    livingEntity.m_5997_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                }
            }
        }

        @Override
        public boolean canCancelActiveAbility() {
            return true;
        }
    }
}

