/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.server.block.ICopiedBlockProperties;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class EntityGeomancyBase
extends EntityMagicEffect
implements GeoEntity {
    private static final byte EXPLOSION_PARTICLES_ID = 69;
    protected static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.m_135353_(EntityGeomancyBase.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.m_135353_(EntityGeomancyBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DEATH_TIME = SynchedEntityData.m_135353_(EntityGeomancyBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean doRemoveTimer = true;

    public EntityGeomancyBase(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityGeomancyBase(EntityType<? extends EntityMagicEffect> type, Level worldIn, LivingEntity caster, BlockState blockState, BlockPos pos) {
        super(type, worldIn, caster);
        if (!worldIn.f_46443_ && blockState != null && EffectGeomancy.isBlockUseable(blockState)) {
            BlockState newBlock = this.changeBlock(blockState);
            this.setBlock(newBlock);
        }
    }

    @Override
    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public BlockState changeBlock(BlockState blockState) {
        ICopiedBlockProperties properties;
        Block baseBlock;
        if (!blockState.m_204336_(TagHandler.GEOMANCY_USEABLE) && (baseBlock = (properties = (ICopiedBlockProperties)blockState.m_60734_().f_60439_).getBaseBlock()) != null) {
            blockState = baseBlock.m_49966_();
        }
        if (blockState.m_60734_() == Blocks.f_50440_ || blockState.m_60734_() == Blocks.f_50195_ || blockState.m_60734_() == Blocks.f_50599_ || blockState.m_60734_() == Blocks.f_152481_) {
            blockState = Blocks.f_50493_.m_49966_();
        } else if (blockState.m_204336_(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE)) {
            blockState = Blocks.f_152550_.m_49966_();
        } else if (blockState.m_204336_(BlockTags.f_13077_)) {
            blockState = Blocks.f_50134_.m_49966_();
        } else if (blockState.m_204336_(Tags.Blocks.ORES_IN_GROUND_NETHERRACK)) {
            blockState = Blocks.f_50134_.m_49966_();
        } else if (blockState.m_204336_(Tags.Blocks.ORES_IN_GROUND_STONE)) {
            blockState = Blocks.f_50069_.m_49966_();
        } else if (blockState.m_204336_(Tags.Blocks.SAND_RED)) {
            blockState = Blocks.f_50394_.m_49966_();
        } else if (blockState.m_204336_(Tags.Blocks.SAND_COLORLESS)) {
            blockState = Blocks.f_50062_.m_49966_();
        } else if (blockState.m_60734_() == Blocks.f_50135_) {
            blockState = Blocks.f_50136_.m_49966_();
        }
        return blockState;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.doRemoveTimer()) {
            int newDeathTime = this.getDeathTime() - 1;
            this.setDeathTime(newDeathTime);
            if (newDeathTime < 0) {
                this.explode();
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BLOCK_STATE, (Object)Blocks.f_50493_.m_49966_());
        this.m_20088_().m_135372_(DEATH_TIME, (Object)1200);
        this.m_20088_().m_135372_(TIER, (Object)0);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    @Override
    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public boolean m_20067_() {
        return false;
    }

    public void m_5496_(SoundEvent soundIn, float volume, float pitch) {
        super.m_5496_(soundIn, volume, pitch + this.f_19796_.m_188501_() * 0.25f - 0.125f);
    }

    public boolean m_6128_() {
        return true;
    }

    protected void explode() {
        this.m_9236_().m_7605_((Entity)this, (byte)69);
        GeomancyTier tier = this.getTier();
        if (tier == GeomancyTier.NONE) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.5f, 1.0f);
        }
        if (tier == GeomancyTier.SMALL) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.5f, 1.0f);
        } else if (tier == GeomancyTier.MEDIUM) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.7f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_3.get(), 1.5f, 1.5f);
        } else if (tier == GeomancyTier.LARGE) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.0f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM_1.get(), 1.5f, 0.9f);
            EntityCameraShake.cameraShake(this.m_9236_(), this.m_20182_(), 15.0f, 0.05f, 0, 20);
            int i = 0;
            while ((float)i < 5.0f * this.fallingBlockCountMultiplier()) {
                Vec3 particlePos = new Vec3((double)(this.f_19796_.m_188501_() * 2.0f), 0.0, 0.0);
                particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82549_(new Vec3(0.0, (double)(this.m_20206_() / 4.0f), 0.0));
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.m_9236_(), 70, this.getBlock());
                fallingBlock.m_6034_(this.m_20185_() + particlePos.f_82479_, this.m_20186_() + 0.5 + particlePos.f_82480_, this.m_20189_() + particlePos.f_82481_);
                fallingBlock.m_20334_((float)particlePos.f_82479_ * 0.3f, 0.2f + this.f_19796_.m_188501_() * 0.6f, (float)particlePos.f_82481_ * 0.3f);
                this.m_9236_().m_7967_((Entity)fallingBlock);
                ++i;
            }
        } else if (tier == GeomancyTier.HUGE) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 0.5f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 1.5f, 0.5f);
            EntityCameraShake.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.05f, 0, 20);
            int i = 0;
            while ((float)i < 7.0f * this.fallingBlockCountMultiplier()) {
                Vec3 particlePos = new Vec3((double)(this.f_19796_.m_188501_() * 2.5f), 0.0, 0.0);
                particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82549_(new Vec3(0.0, (double)(this.m_20206_() / 4.0f), 0.0));
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.m_9236_(), 70, this.getBlock());
                fallingBlock.m_6034_(this.m_20185_() + particlePos.f_82479_, this.m_20186_() + 0.5 + particlePos.f_82480_, this.m_20189_() + particlePos.f_82481_);
                fallingBlock.m_20334_((float)particlePos.f_82479_ * 0.3f, 0.2f + this.f_19796_.m_188501_() * 0.6f, (float)particlePos.f_82481_ * 0.3f);
                this.m_9236_().m_7967_((Entity)fallingBlock);
                ++i;
            }
        }
        this.m_146870_();
    }

    protected float fallingBlockCountMultiplier() {
        return 1.0f;
    }

    protected void spawnExplosionParticles() {
        int i = 0;
        while ((float)i < 40.0f * this.m_20205_()) {
            Vec3 particlePos = new Vec3((double)this.f_19796_.m_188501_() * 0.7 * (double)this.m_20205_(), 0.0, 0.0);
            particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI));
            particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI));
            particlePos = particlePos.m_82520_(0.0, (double)this.m_20206_() / 2.0, 0.0);
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            boolean overrideLimiter = camera.m_90583_().m_82531_(this.m_20185_(), this.m_20186_(), this.m_20189_()) < 4096.0;
            this.m_9236_().m_6485_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.getBlock()), overrideLimiter, this.m_20185_() + particlePos.f_82479_, this.m_20186_() + 0.5 + particlePos.f_82480_, this.m_20189_() + particlePos.f_82481_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
            ++i;
        }
    }

    public void m_7822_(byte id) {
        if (id == 69) {
            this.spawnExplosionParticles();
        } else {
            super.m_7822_(id);
        }
    }

    public BlockState getBlock() {
        return (BlockState)this.m_20088_().m_135370_(BLOCK_STATE);
    }

    public void setBlock(BlockState block) {
        this.m_20088_().m_135381_(BLOCK_STATE, (Object)block);
    }

    public GeomancyTier getTier() {
        return GeomancyTier.values()[(Integer)this.f_19804_.m_135370_(TIER)];
    }

    public void setTier(GeomancyTier size) {
        this.f_19804_.m_135381_(TIER, (Object)size.ordinal());
    }

    public int getDeathTime() {
        return (Integer)this.f_19804_.m_135370_(DEATH_TIME);
    }

    public void setDeathTime(int deathTime) {
        this.f_19804_.m_135381_(DEATH_TIME, (Object)deathTime);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockState blockState = this.getBlock();
        if (blockState != null) {
            compound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        }
        if (this.doRemoveTimer()) {
            compound.m_128405_("deathTime", this.getDeathTime());
        }
        compound.m_128405_("tier", this.getTier().ordinal());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag blockStateCompound = compound.m_128423_("block");
        if (blockStateCompound != null) {
            BlockState blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)((CompoundTag)blockStateCompound));
            this.setBlock(blockState);
        }
        if (compound.m_128441_("deathTime")) {
            this.doRemoveTimer = true;
            this.setDeathTime(compound.m_128451_("deathTime"));
        } else {
            this.doRemoveTimer = false;
        }
        this.setTier(GeomancyTier.values()[compound.m_128451_("tier")]);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public boolean doRemoveTimer() {
        return this.doRemoveTimer;
    }

    public void setDoRemoveTimer(boolean doRemoveTimer) {
        this.doRemoveTimer = doRemoveTimer;
    }

    public static enum GeomancyTier {
        NONE(0),
        SMALL(1),
        MEDIUM(2),
        LARGE(3),
        HUGE(4);

        public final int index;

        private GeomancyTier(int i) {
            this.index = i;
        }
    }
}

