/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib.core.animation.Animation;

public class SpawnBoulderAbility
extends PlayerAbility {
    private static int MAX_CHARGE = 60;
    public static final double SPAWN_BOULDER_REACH = 5.0;
    public BlockPos spawnBoulderPos = new BlockPos(0, 0, 0);
    public Vec3 lookPos = new Vec3(0.0, 0.0, 0.0);
    private BlockState spawnBoulderBlock = Blocks.f_50493_.m_49966_();
    private int spawnBoulderCharge = 0;
    private EntityGeomancyBase.GeomancyTier boulderSize = EntityGeomancyBase.GeomancyTier.SMALL;
    private static final AbilitySection NO_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 5);
    private static final AbilitySection SMALL_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 8);
    private static final AbilitySection MEDIUM_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 8);
    private static final AbilitySection LARGE_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 8);
    private static final AbilitySection HUGE_CHARGE_SECTION = new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 20);

    public SpawnBoulderAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{NO_CHARGE_SECTION, SMALL_CHARGE_SECTION, MEDIUM_CHARGE_SECTION, LARGE_CHARGE_SECTION, HUGE_CHARGE_SECTION, new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 12)});
    }

    @Override
    public InteractionHand getActiveHand() {
        if (((Player)this.getUser()).m_21205_().m_150930_((Item)ItemHandler.EARTHREND_GAUNTLET.get())) {
            return InteractionHand.MAIN_HAND;
        }
        if (((Player)this.getUser()).m_21206_().m_150930_((Item)ItemHandler.EARTHREND_GAUNTLET.get())) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    @Override
    public void start() {
        super.start();
        this.boulderSize = EntityGeomancyBase.GeomancyTier.SMALL;
        if (this.getLevel().m_5776_()) {
            this.playAnimation("spawn_boulder_start", Animation.LoopType.DEFAULT, true, false);
            if (((Player)this.getUser()).m_7655_() == InteractionHand.MAIN_HAND) {
                this.heldItemMainHandVisualOverride = ((Player)this.getUser()).m_21211_();
            } else {
                this.heldItemOffHandVisualOverride = ((Player)this.getUser()).m_21211_();
            }
        }
    }

    @Override
    public boolean tryAbility() {
        Vec3 from = ((Player)this.getUser()).m_20299_(1.0f);
        Vec3 to = from.m_82549_(((Player)this.getUser()).m_20154_().m_82490_(5.0));
        BlockHitResult result = ((Player)this.getUser()).m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            this.lookPos = result.m_82450_();
        }
        this.spawnBoulderPos = result.m_82425_();
        this.spawnBoulderBlock = ((Player)this.getUser()).m_9236_().m_8055_(this.spawnBoulderPos);
        if (result.m_82434_() == Direction.DOWN) {
            return false;
        }
        BlockState blockAbove = ((Player)this.getUser()).m_9236_().m_8055_(this.spawnBoulderPos.m_7494_());
        if (blockAbove.m_280555_()) {
            return false;
        }
        return EffectGeomancy.isBlockUseable(this.spawnBoulderBlock);
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            int size;
            ++this.spawnBoulderCharge;
            if (this.spawnBoulderCharge > 2) {
                ((Player)this.getUser()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 3, 0, false, false));
            }
            if (this.spawnBoulderCharge == 1 && ((Player)this.getUser()).m_9236_().f_46443_) {
                MowziesMobs.PROXY.playBoulderChargeSound((LivingEntity)this.getUser());
            }
            if (this.spawnBoulderCharge == 45) {
                if (((Player)this.getUser()).m_9236_().f_46443_) {
                    AdvancedParticleBase.spawnParticle(((Player)this.getUser()).m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)((Player)this.getUser()).m_20185_(), (float)((Player)this.getUser()).m_20186_() + ((Player)this.getUser()).m_20206_() / 2.0f, (float)((Player)this.getUser()).m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 20.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 40.0f), false)});
                }
                ((Player)this.getUser()).m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.0f, 1.0f);
            }
            if ((size = this.getBoulderSize().index + 1) > 4) {
                size = 4;
            }
            EntityDimensions dim = EntityBoulderBase.SIZE_MAP.get((Object)EntityGeomancyBase.GeomancyTier.values()[size]);
            if (!((Player)this.getUser()).m_9236_().m_45772_(dim.m_20384_((double)((float)this.spawnBoulderPos.m_123341_() + 0.5f), (double)(this.spawnBoulderPos.m_123342_() + 2), (double)((float)this.spawnBoulderPos.m_123343_() + 0.5f))) || ((Player)this.getUser()).m_20275_((double)this.spawnBoulderPos.m_123341_(), (double)this.spawnBoulderPos.m_123342_(), (double)this.spawnBoulderPos.m_123343_()) > 36.0) {
                this.jumpToSection(5);
            }
        }
    }

    @Override
    protected void beginSection(AbilitySection section) {
        if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP && section != NO_CHARGE_SECTION && ((Player)this.getUser()).m_9236_().f_46443_) {
            float scale = 5.0f;
            if (section == MEDIUM_CHARGE_SECTION) {
                scale = 8.0f;
            } else if (section == LARGE_CHARGE_SECTION) {
                scale = 12.0f;
            } else if (section == HUGE_CHARGE_SECTION) {
                scale = 16.0f;
            }
            AdvancedParticleBase.spawnParticle(((Player)this.getUser()).m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)this.spawnBoulderPos.m_123341_() + 0.5f, (double)this.spawnBoulderPos.m_123342_() + 1.01, (float)this.spawnBoulderPos.m_123343_() + 0.5f, 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, scale, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false)});
        }
        if (section == MEDIUM_CHARGE_SECTION) {
            this.boulderSize = EntityGeomancyBase.GeomancyTier.MEDIUM;
        }
        if (section == LARGE_CHARGE_SECTION) {
            this.boulderSize = EntityGeomancyBase.GeomancyTier.LARGE;
        }
        if (section == HUGE_CHARGE_SECTION) {
            this.boulderSize = EntityGeomancyBase.GeomancyTier.HUGE;
        }
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            this.spawnBoulder();
        }
    }

    private EntityGeomancyBase.GeomancyTier getBoulderSize() {
        return this.boulderSize;
    }

    private void spawnBoulder() {
        if (this.spawnBoulderCharge <= 2) {
            this.playAnimation("spawn_boulder_instant", Animation.LoopType.DEFAULT, true, false);
        } else {
            this.playAnimation("spawn_boulder_end", Animation.LoopType.DEFAULT, true, false);
        }
        EntityBoulderProjectile boulder = new EntityBoulderProjectile((EntityType<? extends EntityBoulderProjectile>)((EntityType)EntityHandler.BOULDER_PROJECTILE.get()), ((Player)this.getUser()).m_9236_(), (LivingEntity)this.getUser(), this.spawnBoulderBlock, this.spawnBoulderPos, this.getBoulderSize());
        boulder.m_6034_((float)this.spawnBoulderPos.m_123341_() + 0.5f, this.spawnBoulderPos.m_123342_() + 2, (float)this.spawnBoulderPos.m_123343_() + 0.5f);
        if (!((Player)this.getUser()).m_9236_().f_46443_ && boulder.checkCanSpawn()) {
            ((Player)this.getUser()).m_9236_().m_7967_((Entity)boulder);
        }
        if (this.spawnBoulderCharge > 2) {
            Vec3 playerEyes = ((Player)this.getUser()).m_20299_(1.0f);
            Vec3 vec = playerEyes.m_82546_(this.lookPos).m_82541_();
            float yaw = (float)Math.atan2(vec.f_82481_, vec.f_82479_);
            float pitch = (float)Math.asin(vec.f_82480_);
            ((Player)this.getUser()).m_146922_((float)((double)(yaw * 180.0f) / Math.PI + 90.0));
            ((Player)this.getUser()).m_146926_((float)((double)(pitch * 180.0f) / Math.PI));
        }
        this.spawnBoulderCharge = 0;
    }

    @Override
    public void onRightMouseUp(Player player) {
        super.onRightMouseUp(player);
        if (this.isUsing() && this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP && this.getCurrentSection() != HUGE_CHARGE_SECTION) {
            if (player.m_20275_((double)this.spawnBoulderPos.m_123341_(), (double)this.spawnBoulderPos.m_123342_(), (double)this.spawnBoulderPos.m_123343_()) < 36.0) {
                this.jumpToSection(5);
            } else {
                this.spawnBoulderCharge = 0;
            }
        }
    }

    @Override
    public boolean canUse() {
        return EffectGeomancy.canUse(this.getUser()) && super.canUse();
    }

    @Override
    public void end() {
        this.spawnBoulderCharge = 0;
        super.end();
    }

    @Override
    public void readNBT(Tag nbt) {
        super.readNBT(nbt);
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            this.spawnBoulderCharge = this.getTicksInUse();
        }
    }

    @Override
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        super.onRightClickBlock(event);
        if (!event.getLevel().m_5776_()) {
            AbilityHandler.INSTANCE.sendAbilityMessage(event.getEntity(), AbilityHandler.SPAWN_BOULDER_ABILITY);
        }
    }

    @Override
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        super.onRightClickEmpty(event);
        AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SPAWN_BOULDER_ABILITY);
    }

    @Override
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        super.onRenderTick(event);
        if (this.isUsing() && this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP && this.getTicksInUse() > 1) {
            Vec3 playerEyes = ((Player)this.getUser()).m_20299_(Minecraft.m_91087_().m_91296_());
            Vec3 vec = playerEyes.m_82546_(this.lookPos).m_82541_();
            float yaw = (float)Math.atan2(vec.f_82481_, vec.f_82479_);
            float pitch = (float)Math.asin(vec.f_82480_);
            ((Player)this.getUser()).m_146922_((float)((double)(yaw * 180.0f) / Math.PI + 90.0));
            ((Player)this.getUser()).m_146926_((float)((double)(pitch * 180.0f) / Math.PI));
            ((Player)this.getUser()).f_20885_ = ((Player)this.getUser()).m_146908_();
            ((Player)this.getUser()).f_19859_ = ((Player)this.getUser()).m_146908_();
            ((Player)this.getUser()).f_19860_ = ((Player)this.getUser()).m_146909_();
            ((Player)this.getUser()).f_20886_ = ((Player)this.getUser()).f_20885_;
        }
    }
}

