/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.item.BaseItemKey;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBuildKey
extends BaseItemKey {
    public static final String REG_NAME = "item_key_build";
    public static final int BLOCKS_APART_PER_PLOT = 512;
    public static final float PLOT_ENTRANCE_OFFSET_X = 64.0f;
    public static final float PLOT_ENTRANCE_OFFSET_Z = 128.0f;

    public ItemBuildKey() {
        super(new Item.Properties().m_41497_(Rarity.COMMON));
    }

    public boolean isPlotBuilt(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("built")) {
            return stack.m_41783_().m_128471_("built");
        }
        return false;
    }

    public void setPlotBuilt(ItemStack stack) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128379_("built", true);
        }
    }

    @Override
    public float getWarpX(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_("dest_x")) {
            return (float)(itemData.m_128451_("dest_x") * 512 + 64) + 64.0f;
        }
        return -1.0f;
    }

    @Override
    public float getWarpZ(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_("dest_z")) {
            float z = (float)(itemData.m_128451_("dest_z") * 512 + 64) + 128.0f;
            return z;
        }
        return -1.0f;
    }

    @Override
    public long getDungeonTopLeftX(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_("dest_x")) {
            return itemData.m_128451_("dest_x") * 512;
        }
        return -1L;
    }

    @Override
    public long getDungeonTopLeftZ(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_("dest_z")) {
            return itemData.m_128451_("dest_z") * 512;
        }
        return -1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        if (this.isActivated(stack)) {
            return Component.m_237115_((String)"item.dimdungeons.item_build_key");
        }
        return Component.m_237115_((String)"item.dimdungeons.item_blank_build_key");
    }
}

