/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class ResistanceComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.shouldRenderArmor() || !ctx.config.bool(IConfig.BooleanOption.RESISTANCE_ENABLE) || ctx.config.bool(IConfig.BooleanOption.ARMOR_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("resistance");
        int armor = ctx.data.armor();
        int resistance = 0;
        if (ctx.data.isEffectActive(ctx.data.effects().resistance())) {
            resistance = 1 + ctx.data.getActiveEffect(ctx.data.effects().resistance()).amplifier();
        }
        if (ctx.data.isPotionCoreLoaded()) {
            resistance = (int)((double)resistance + (ctx.data.potionCore().resistance() - 1.0) * 5.0);
        }
        resistance = Math.min(resistance, 5);
        resistance = ctx.math.ceil((float)resistance * ctx.config.dec(IConfig.FloatOption.RESISTANCE_VALUE));
        if ((resistance = ctx.math.clamp(resistance, 0, 10)) <= 0) {
            return this.popReturn(ctx, false);
        }
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        int i = 0;
        while (i < 10 && i < resistance) {
            if (armor <= 0) {
                tex.drawOverlay(ctx, ctx.x + 8 * i, ctx.y, false, false, ITextureSheet.OverlaySprite.RESISTANCE_NONE);
            } else if (armor % 20 == 1) {
                tex.drawOverlay(ctx, ctx.x + 8 * i, ctx.y, false, false, ITextureSheet.OverlaySprite.RESISTANCE_HALF);
            } else {
                tex.drawOverlay(ctx, ctx.x + 8 * i, ctx.y, false, false, ITextureSheet.OverlaySprite.RESISTANCE_FULL);
            }
            ++i;
            armor -= 2;
        }
        return this.popReturn(ctx, true);
    }
}

