/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.RenderableText;
import dev.cheos.armorpointspp.core.adapter.IConfig;

public class HealthTextComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        int hpcol;
        if (!ctx.shouldRender() || !ctx.config.bool(IConfig.BooleanOption.HEALTH_TEXT_ENABLE) || ctx.config.bool(IConfig.BooleanOption.HEALTH_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("healthText");
        RenderableText text = new RenderableText("").withShadow(ctx.config.bool(IConfig.BooleanOption.TEXT_SHADOW));
        int freeze = Math.round(100.0f * ctx.data.percentFrozen());
        int maxHp = ctx.math.ceil(ctx.data.maxHealth());
        int absorb = ctx.math.ceil(ctx.data.absorption());
        int health = ctx.math.ceil(ctx.data.health());
        int n = ctx.data.isFullyFrozen() ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_FROSTBITE) : (ctx.data.isEffectActive(ctx.data.effects().poison()) ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_POISON) : (hpcol = ctx.data.isEffectActive(ctx.data.effects().wither()) ? ctx.config.hex(IConfig.HexOption.TEXT_COLOR_WITHER) : ctx.config.hex(IConfig.HexOption.TEXT_COLOR_HEART)));
        if (health > maxHp) {
            health = maxHp;
        }
        text.append(new RenderableText(health).padRight(1.0f).withColor(hpcol));
        if (health < maxHp) {
            text.append(new RenderableText("/").padRight(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_SEPARATOR)));
            text.append(new RenderableText(maxHp).padRight(1.0f).withColor(hpcol));
        }
        if (absorb > 0) {
            text.append(new RenderableText("+").padRight(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_SEPARATOR)));
            text.append(new RenderableText(absorb).padRight(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ABSORPTION)));
        }
        if (freeze > 0 && ctx.config.bool(IConfig.BooleanOption.FROSTBITE_TEXT_ENABLE)) {
            text.append(new RenderableText(",").padRight(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_SEPARATOR)));
            text.append(new RenderableText(freeze).padRight(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_FROSTBITE)));
            text.append(new RenderableText("%").padRight(1.0f).withColor(ctx.config.hex(IConfig.HexOption.TEXT_COLOR_SEPARATOR)));
        }
        if (ctx.config.bool(IConfig.BooleanOption.HEALTH_TEXT_CONFIG_ENABLE)) {
            text.withAlignment(ctx.config.enm(IConfig.EnumOption.HEALTH_TEXT_ALIGNMENT)).render(ctx.poseStack, ctx.renderer, ctx.config.dec(IConfig.FloatOption.HEALTH_TEXT_X), ctx.config.dec(IConfig.FloatOption.HEALTH_TEXT_Y));
        } else {
            text.withAlignment(RenderableText.Alignment.RIGHT).render(ctx.poseStack, ctx.renderer, ctx.x, (float)ctx.y + 0.5f);
        }
        return this.popReturn(ctx, true);
    }
}

