/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.RenderableText;
import dev.cheos.armorpointspp.core.adapter.IConfig;

public class DebugTextComponent
implements IRenderComponent {
    private static RenderableText right = new RenderableText("this should be left aligned and red with no shadow").withAlignment(RenderableText.Alignment.LEFT).withColor(0xFF0000).withShadow(false);
    private static RenderableText center = new RenderableText("this should be centered and green").withAlignment(RenderableText.Alignment.CENTER).withColor(65280);
    private static RenderableText left = new RenderableText("this should be right aligned and blue").withAlignment(RenderableText.Alignment.RIGHT).withColor(255);

    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.shouldRender() || !ctx.config.bool(IConfig.BooleanOption.DEBUG)) {
            return false;
        }
        ctx.profiler.push("appp.debugText");
        float maxHp = ctx.data.maxHealth();
        float absorb = ctx.data.absorption();
        int hpRows = ctx.math.ceil((maxHp + absorb) / 20.0f);
        ctx.renderer.text(ctx.poseStack, "armor should be here (vanilla)", ctx.x, ctx.y, 0xFF0000);
        ctx.renderer.text(ctx.poseStack, "hp: " + maxHp, 5.0f, 5.0f, 0xFFFFFF);
        ctx.renderer.text(ctx.poseStack, "rows: " + hpRows, 5.0f, 15.0f, 0xFFFFFF);
        ctx.renderer.text(ctx.poseStack, "armor = 0", ctx.x, ctx.y - 40, ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_0));
        ctx.renderer.text(ctx.poseStack, "armor < 25", ctx.x, ctx.y - 30, ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_LT25));
        ctx.renderer.text(ctx.poseStack, "armor = 25", ctx.x, ctx.y - 20, ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_EQ25));
        ctx.renderer.text(ctx.poseStack, "armor > 25", ctx.x, ctx.y - 10, ctx.config.hex(IConfig.HexOption.TEXT_COLOR_ARMOR_GT25));
        right.render(ctx.poseStack, ctx.renderer, ctx.x, ctx.y - 60);
        center.render(ctx.poseStack, ctx.renderer, ctx.x, ctx.y - 70);
        left.render(ctx.poseStack, ctx.renderer, ctx.x, ctx.y - 80);
        new RenderableText("R").withColor(0xFF0000).withAlignment(RenderableText.Alignment.CENTER).append(new RenderableText("G").withColor(65280).append(new RenderableText("B").withColor(255))).append(new RenderableText("A").withColor(0xFFFFFF).withShadow(false)).render(ctx.poseStack, ctx.renderer, ctx.x, ctx.y - 50);
        return this.popReturn(ctx, true);
    }
}

