/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;
import java.awt.Color;

public class ArmorComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.shouldRenderArmor() || !ctx.config.bool(IConfig.BooleanOption.ARMOR_ENABLE) || ctx.config.bool(IConfig.BooleanOption.ARMOR_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("armor");
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        int armor = Math.min(ctx.data.armor(), 240);
        if (!ctx.config.bool(IConfig.BooleanOption.DISABLE_EASTEREGGS) && armor == Math.min(137, ctx.data.maxArmor())) {
            this.renderRainbowArmor(ctx, ctx.x, ctx.y);
            return this.popReturn(ctx, true);
        }
        for (int i = 0; i < 10; ++i) {
            tex.drawArmor(ctx, ctx.x + 8 * i, ctx.y, (int)((float)(armor - 2 * (i + 1) + 20) * 0.05f), armor % 20 - 2 * i == 1);
        }
        return this.popReturn(ctx, true);
    }

    private void renderRainbowArmor(RenderContext ctx, int x, int y) {
        ITextureSheet tex = this.tex(ctx);
        ctx.poseStack.pushPose();
        long millis = ctx.data.millis() / 40L;
        int color = 0;
        for (int i = 0; i < 10; ++i) {
            color = Color.HSBtoRGB((float)((millis += 5L) % 360L) / 360.0f, 1.0f, 1.0f);
            ctx.renderer.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
            tex.drawArmor(ctx, x + 8 * i, y, 1, false);
        }
        ctx.poseStack.popPose();
    }
}

