/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core;

import java.lang.reflect.Field;

public class ReflectionHelper {
    public static <T, V> void setPrivateValue(String identifier, V value) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionHelper.setPrivateValue(identifier, null, value);
    }

    public static <T, V> void setPrivateValue(String identifier, T of, V value) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String[] parts = identifier.split("#", 2);
        ReflectionHelper.setPrivateValue(parts[0], parts[1], of, value);
    }

    public static <T, V> void setPrivateValue(String clazz, String name, V value) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionHelper.setPrivateValue(clazz, name, null, value);
    }

    public static <T, V> void setPrivateValue(String clazz, String name, T of, V value) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionHelper.setPrivateValue(Class.forName(clazz), name, of, value);
    }

    public static <T, V> void setPrivateValue(Class<T> clazz, String name, V value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionHelper.setPrivateValue(clazz, name, null, value);
    }

    public static <T, V> void setPrivateValue(Class<T> clazz, String name, T of, V value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionHelper.findField(clazz, name);
        boolean fin = ReflectionHelper.isFinal(field);
        if (fin) {
            ReflectionHelper.unfinalize(field);
        }
        field.set(of, value);
        if (fin) {
            ReflectionHelper.finalize(field);
        }
    }

    public static <T, V> V getPrivateValue(String identifier) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return ReflectionHelper.getPrivateValue(identifier, null);
    }

    public static <T, V> V getPrivateValue(String identifier, T of) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String[] parts = identifier.split("#", 2);
        return ReflectionHelper.getPrivateValue(parts[0], parts[1], of);
    }

    public static <T, V> V getPrivateValue(String clazz, String name) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return ReflectionHelper.getPrivateValue(clazz, name, null);
    }

    public static <T, V> V getPrivateValue(String clazz, String name, T of) throws ClassNotFoundException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return ReflectionHelper.getPrivateValue(Class.forName(clazz), name, of);
    }

    public static <T, V> V getPrivateValue(Class<T> clazz, String name) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return ReflectionHelper.getPrivateValue(clazz, name, null);
    }

    public static <T, V> V getPrivateValue(Class<T> clazz, String name, T of) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionHelper.findField(clazz, name);
        return (V)field.get(of);
    }

    public static <T, V> V getPrivateValueDirect(Class<T> clazz, String name) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return ReflectionHelper.getPrivateValueDirect(clazz, name, null);
    }

    public static <T, V> V getPrivateValueDirect(Class<T> clazz, String name, T of) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return (V)field.get(of);
    }

    public static Field findField(Class<?> clazz, String name) throws NoSuchFieldException, SecurityException {
        NoSuchFieldException ex = null;
        Field field = null;
        while (field == null) {
            try {
                field = clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (ex == null) {
                    ex = e;
                }
                if (clazz == Object.class) {
                    throw ex;
                }
                clazz = clazz.getSuperclass();
            }
        }
        field.setAccessible(true);
        return field;
    }

    public static Field unfinalize(Field field) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field modifiers = ReflectionHelper.findField(Field.class, "modifiers");
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        return field;
    }

    public static Field finalize(Field field) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field modifiers = ReflectionHelper.findField(Field.class, "modifiers");
        modifiers.setInt(field, field.getModifiers() | 0x10);
        return field;
    }

    public static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }
}

