/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.config;

import dev.cheos.armorpointspp.core.adapter.IConfig;
import net.minecraft.util.Mth;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ApppConfigValue<T, U> {
    protected final String name;
    protected final String[] comments;
    protected final T def;
    protected ForgeConfigSpec.ConfigValue<T> confValue;

    protected ApppConfigValue(String name, T def, String ... comments) {
        this.name = name;
        this.def = def;
        this.comments = comments;
    }

    public void define(ForgeConfigSpec.Builder builder) {
        builder.comment(this.comments);
        this.confValue = builder.define(this.name, this.def);
    }

    public U get() {
        return (U)this.confValue.get();
    }

    public static class EnumValue<T extends Enum<T>>
    extends ApppConfigValue<T, T> {
        public EnumValue(String name, T def, String[] comments) {
            super(name, def, comments);
        }

        @Override
        public void define(ForgeConfigSpec.Builder builder) {
            builder.comment(this.comments);
            this.confValue = builder.defineEnum(this.name, (Enum)this.def);
        }

        @Override
        public T get() {
            return (T)((Enum)this.confValue.get());
        }

        public static <T extends Enum<T>> EnumValue<T> of(IConfig.EnumOption<T> opt) {
            return new EnumValue<Object>(opt.key(), opt.def(), opt.comments());
        }
    }

    public static class FloatValue
    extends ApppConfigValue<Double, Float> {
        private final float min;
        private final float max;

        public FloatValue(String name, float def, String ... comments) {
            this(name, def, Float.MAX_VALUE, comments);
        }

        public FloatValue(String name, float def, float max, String ... comments) {
            this(name, def, 0.0f, max, comments);
        }

        public FloatValue(String name, float def, float min, float max, String ... comments) {
            super(name, Double.valueOf(Mth.m_14036_((float)def, (float)min, (float)max)), comments);
            this.min = min;
            this.max = max;
        }

        @Override
        public void define(ForgeConfigSpec.Builder builder) {
            builder.comment(this.comments);
            this.confValue = builder.defineInRange(this.name, ((Double)this.def).doubleValue(), (double)this.min, (double)this.max);
        }

        @Override
        public Float get() {
            return Float.valueOf(((Double)this.confValue.get()).floatValue());
        }
    }

    public static class StringValue
    extends ApppConfigValue<String, String> {
        public StringValue(String name, String def, String ... comments) {
            super(name, def, comments);
        }
    }

    public static class BoolValue
    extends ApppConfigValue<Boolean, Boolean> {
        public BoolValue(String name, Boolean def, String ... comments) {
            super(name, def, comments);
        }
    }

    public static class IntValue
    extends ApppConfigValue<Integer, Integer> {
        private final int min;
        private final int max;

        public IntValue(String name, int def, String ... comments) {
            this(name, def, Integer.MAX_VALUE, comments);
        }

        public IntValue(String name, int def, int max, String ... comments) {
            this(name, def, 0, max, comments);
        }

        public IntValue(String name, int def, int min, int max, String ... comments) {
            super(name, Mth.m_14045_((int)def, (int)min, (int)max), comments);
            this.min = min;
            this.max = max;
        }

        @Override
        public void define(ForgeConfigSpec.Builder builder) {
            builder.comment(this.comments);
            this.confValue = builder.defineInRange(this.name, ((Integer)this.def).intValue(), this.min, this.max);
        }
    }

    public static class HexValue
    extends ApppConfigValue<String, Integer> {
        public HexValue(String name, Integer def, String ... comments) {
            super(name, HexValue.hex(def, 6), comments);
        }

        @Override
        public Integer get() {
            return HexValue.fromHex((String)this.confValue.get());
        }

        private static String hex(int i, int minlen) {
            return String.format("0x%0" + minlen + "x", i);
        }

        private static int fromHex(String hex) {
            return Integer.parseInt(hex.substring(2), 16);
        }
    }
}

