/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp;

import com.google.common.base.Preconditions;
import dev.cheos.armorpointspp.config.ApppConfig;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.Side;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.adapter.IDataProvider;
import dev.cheos.armorpointspp.core.adapter.IMath;
import dev.cheos.armorpointspp.core.adapter.IProfiler;
import dev.cheos.armorpointspp.core.adapter.IRenderer;
import dev.cheos.armorpointspp.core.render.Components;
import dev.cheos.armorpointspp.impl.DataProviderImpl;
import dev.cheos.armorpointspp.impl.EnchantmentHelperImpl;
import dev.cheos.armorpointspp.impl.PoseStackImpl;
import dev.cheos.armorpointspp.impl.ProfilerImpl;
import dev.cheos.armorpointspp.impl.RendererImpl;
import dev.cheos.armorpointspp.mixin.IRegisterGuiOverlaysEventMixin;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="armorpointspp", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class Overlays {
    private static final IDataProvider DATA_PROVIDER = new DataProviderImpl();
    private static final IRenderer RENDERER = new RendererImpl();
    private static final IProfiler PROFILER = new ProfilerImpl();
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static int lastArmorY = 0;
    private static int lastHealthY = 0;
    private static int lastToughnessY = 0;
    public static final ResourceLocation MOUNT_HEALTH = new ResourceLocation("minecraft", "mount_health");
    public static final ResourceLocation PLAYER_HEALTH = new ResourceLocation("minecraft", "player_health");
    public static final ResourceLocation ABSORPTION = new ResourceLocation("armorpointspp", "absorption");
    public static final ResourceLocation ABSORPTION_OV = new ResourceLocation("armorpointspp", "absorption_ov");
    public static final ResourceLocation ARMOR_LEVEL = new ResourceLocation("minecraft", "armor_level");
    public static final ResourceLocation MAGIC_SHIELD = new ResourceLocation("armorpointspp", "pc_magic_shield");
    public static final ResourceLocation PROTECTION = new ResourceLocation("armorpointspp", "protection");
    public static final ResourceLocation RESISTANCE = new ResourceLocation("armorpointspp", "resistance");
    public static final ResourceLocation ARMOR_TOUGHNESS = new ResourceLocation("armorpointspp", "toughness");
    public static final ResourceLocation ARMOR_TOUGHNESS_OV = new ResourceLocation("armorpointspp", "toughness_ov");
    public static final ResourceLocation ARMOR_TEXT = new ResourceLocation("armorpointspp", "armor_text");
    public static final ResourceLocation HEALTH_TEXT = new ResourceLocation("armorpointspp", "health_text");
    public static final ResourceLocation TOUGHNESS_TEXT = new ResourceLocation("armorpointspp", "toughness_text");
    public static final ResourceLocation ITEM_NAME = new ResourceLocation("minecraft", "item_name");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void register(RegisterGuiOverlaysEvent event) {
        MissedFunctionality missedFunctionality = new MissedFunctionality(event);
        missedFunctionality.unregister(ARMOR_LEVEL);
        missedFunctionality.registerOverriding(PLAYER_HEALTH, Overlays::playerHealth);
        event.registerAbove(PLAYER_HEALTH, ABSORPTION.m_135815_(), Overlays::absorption);
        event.registerAbove(ABSORPTION, ABSORPTION_OV.m_135815_(), Overlays::absorptionOv);
        missedFunctionality.registerArbitraryAbove(ABSORPTION_OV, ARMOR_LEVEL, Overlays::armorLevel);
        event.registerAbove(ARMOR_LEVEL, MAGIC_SHIELD.m_135815_(), Overlays::magicShield);
        event.registerAbove(MAGIC_SHIELD, RESISTANCE.m_135815_(), Overlays::resistance);
        event.registerAbove(RESISTANCE, PROTECTION.m_135815_(), Overlays::protection);
        event.registerAbove(MOUNT_HEALTH, ARMOR_TOUGHNESS.m_135815_(), Overlays::armorToughness);
        event.registerAbove(PROTECTION, ARMOR_TOUGHNESS_OV.m_135815_(), Overlays::armorToughnessOv);
        event.registerAbove(ITEM_NAME, ARMOR_TEXT.m_135815_(), Overlays::armorText);
        event.registerAbove(ITEM_NAME, HEALTH_TEXT.m_135815_(), Overlays::healthText);
        event.registerAbove(ITEM_NAME, TOUGHNESS_TEXT.m_135815_(), Overlays::toughnessText);
        event.registerAboveAll("debug", Overlays::debug);
    }

    private static void playerHealth(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        lastHealthY = Overlays.baseY(gui, screenHeight);
        if (!ApppConfig.instance().bool(IConfig.BooleanOption.HEALTH_ENABLE)) {
            if (!Overlays.minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                gui.renderHealth(screenWidth, screenHeight, graphics);
            }
        } else if (Components.HEALTH.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastHealthY))) {
            gui.leftHeight += 10;
        }
    }

    private static void absorption(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.ABSORPTION.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastHealthY));
    }

    private static void absorptionOv(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.ABSORPTION_OVER.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastHealthY));
    }

    private static void armorLevel(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        lastArmorY = Overlays.baseY(gui, screenHeight);
        RenderContext ctx = Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY);
        boolean flag = false;
        flag = !ApppConfig.instance().bool(IConfig.BooleanOption.ARMOR_ENABLE) ? Components.VANILLA_ARMOR.render(ctx) : Components.ARMOR.render(ctx);
        if (flag) {
            gui.leftHeight += 10;
        }
    }

    private static void armorToughness(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Side side = ApppConfig.instance().enm(IConfig.EnumOption.TOUGHNESS_SIDE);
        lastToughnessY = Overlays.baseY(gui, screenHeight, side);
        if (Components.TOUGHNESS.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth, side), lastToughnessY))) {
            switch (side) {
                case LEFT: {
                    gui.leftHeight += 10;
                    break;
                }
                case RIGHT: {
                    gui.rightHeight += 10;
                }
            }
        }
    }

    private static void resistance(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.RESISTANCE.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY));
    }

    private static void protection(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.PROTECTION.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY));
    }

    private static void armorToughnessOv(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.TOUGHNESS_OVER.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY));
    }

    private static void magicShield(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.MAGIC_SHIELD.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY));
    }

    private static void armorText(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.ARMOR_TEXT.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY));
    }

    private static void healthText(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.HEALTH_TEXT.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastHealthY));
    }

    private static void toughnessText(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Components.TOUGHNESS_TEXT.render(Overlays.ctx(graphics, Overlays.baseX(screenWidth, ApppConfig.instance().enm(IConfig.EnumOption.TOUGHNESS_SIDE)), lastToughnessY));
    }

    private static void debug(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        RenderContext ctx = Overlays.ctx(graphics, Overlays.baseX(screenWidth), lastArmorY);
        Components.DEBUG.render(ctx);
        Components.DEBUG_TEXT.render(ctx);
    }

    public static RenderContext ctx(GuiGraphics graphics, int x, int y) {
        return new RenderContext(ApppConfig.instance(), DATA_PROVIDER, EnchantmentHelperImpl.INSTANCE, IMath.INSTANCE, RENDERER, new PoseStackImpl(graphics), PROFILER, x, y);
    }

    private static int baseX(int width) {
        return Overlays.baseX(width, Side.LEFT);
    }

    private static int baseX(int width, Side side) {
        int n = width / 2;
        return n + (switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.LEFT -> -91;
            case Side.RIGHT -> 10;
        });
    }

    private static int baseY(ForgeGui gui, int height) {
        return Overlays.baseY(gui, height, Side.LEFT);
    }

    private static int baseY(ForgeGui gui, int height, Side side) {
        return height - (switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.LEFT -> gui.leftHeight;
            case Side.RIGHT -> gui.rightHeight;
        });
    }

    public static final class MissedFunctionality {
        private final IRegisterGuiOverlaysEventMixin event;
        private final Map<ResourceLocation, IGuiOverlay> overlays;
        private final List<ResourceLocation> orderedOverlays;

        public MissedFunctionality(RegisterGuiOverlaysEvent event) {
            this.event = (IRegisterGuiOverlaysEventMixin)event;
            this.overlays = this.event.getOverlays();
            this.orderedOverlays = this.event.getOrderedOverlays();
        }

        public void registerOverriding(ResourceLocation id, IGuiOverlay overlay) {
            Preconditions.checkArgument((boolean)this.overlays.containsKey(id), (Object)("Overlay not registered: " + id));
            this.event.getOverlays().put(id, overlay);
        }

        public void unregister(ResourceLocation id) {
            Preconditions.checkArgument((boolean)this.overlays.containsKey(id), (Object)("Overlay not registered: " + id));
            this.overlays.remove(id);
            this.orderedOverlays.remove(id);
        }

        public void registerArbitraryAbove(ResourceLocation other, ResourceLocation id, IGuiOverlay overlay) {
            Preconditions.checkArgument((!this.overlays.containsKey(id) ? 1 : 0) != 0, (Object)("Overlay already registered: " + id));
            int idx = this.overlays.size();
            if (other != null) {
                idx = this.orderedOverlays.indexOf(other) + 1;
                Preconditions.checkState((idx > 0 ? 1 : 0) != 0, (Object)"Attempted to order against an unregistered overlay. Only order against vanilla's and your own.");
            }
            this.overlays.put(id, overlay);
            this.orderedOverlays.add(idx, id);
        }
    }
}

