/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostsouls.data.CustomRegistries;
import mcjty.lostsouls.data.LostChunkData;
import mcjty.lostsouls.data.MobSettings;
import mcjty.lostsouls.setup.Config;
import mcjty.lostsouls.varia.ChunkCoord;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LostSoulData
extends SavedData {
    public static final String NAME = "LostSoulData";
    private final Map<ChunkCoord, LostChunkData> lostChunkDataMap = new HashMap<ChunkCoord, LostChunkData>();
    private Map<ResourceLocation, MobSettings> buildingSettings = null;
    private Map<ResourceLocation, MobSettings> multiBuildingSettings = null;

    @Nonnull
    public static LostSoulData getData(Level world) {
        if (world.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        return (LostSoulData)storage.m_164861_(LostSoulData::new, LostSoulData::new, NAME);
    }

    public LostSoulData() {
    }

    public LostSoulData(CompoundTag tag) {
        this.load(tag);
    }

    @Nonnull
    public static LostChunkData getSoulData(Level world, int chunkX, int chunkZ, @Nullable ILostCityInformation lost) {
        LostSoulData data = LostSoulData.getData(world);
        ChunkCoord cc = new ChunkCoord((ResourceKey<Level>)world.m_46472_(), chunkX, chunkZ);
        return data.getSoulData((ServerLevel)world, cc, lost);
    }

    private void calculateSettingCache(ServerLevel level) {
        if (this.buildingSettings == null) {
            this.buildingSettings = new HashMap<ResourceLocation, MobSettings>();
            this.multiBuildingSettings = new HashMap<ResourceLocation, MobSettings>();
            Registry registry = level.m_9598_().m_175515_(CustomRegistries.BUILDING_REGISTRY_KEY);
            for (MobSettings r : registry) {
                r.getBuildings().forEach(b -> this.buildingSettings.put((ResourceLocation)b, r));
                r.getMultiBuildings().forEach(b -> this.multiBuildingSettings.put((ResourceLocation)b, r));
            }
        }
    }

    private MobSettings getSettingsForBuilding(ServerLevel level, ResourceLocation building) {
        this.calculateSettingCache(level);
        return this.buildingSettings.get(building);
    }

    private MobSettings getSettingsForMultiBuilding(ServerLevel level, ResourceLocation building) {
        this.calculateSettingCache(level);
        return this.multiBuildingSettings.get(building);
    }

    @Nonnull
    public MobSettings getSettingsForChunk(ServerLevel world, ChunkCoord cc, @Nullable ILostCityInformation lost) {
        if (lost == null) {
            return Config.getDefaultSettings();
        }
        ILostSphere sphere = lost.getSphere(cc.chunkX() << 4, cc.chunkZ() << 4);
        if (sphere != null) {
            return Config.getDefaultSphereSettings();
        }
        ILostChunkInfo chunkInfo = lost.getChunkInfo(cc.chunkX(), cc.chunkZ());
        ILostChunkInfo.MultiBuildingInfo mb = chunkInfo.getMultiBuildingInfo();
        if (mb == null) {
            ResourceLocation buildingType = chunkInfo.getBuildingId();
            MobSettings mobSettings = this.getSettingsForBuilding(world, buildingType);
            mobSettings = mobSettings == null ? Config.getDefaultSettings() : MobSettings.merge(Config.getDefaultSettings(), mobSettings);
            return mobSettings;
        }
        float chunks = mb.w() * mb.h();
        MobSettings defaultMultiSettings = Config.getDefaultMultiSettings(chunks);
        MobSettings mobSettings = this.getSettingsForMultiBuilding(world, mb.buildingType());
        mobSettings = mobSettings == null ? defaultMultiSettings : MobSettings.merge(defaultMultiSettings, mobSettings);
        return mobSettings;
    }

    private LostChunkData getSoulData(ServerLevel world, ChunkCoord cc, @Nullable ILostCityInformation lost) {
        if (!this.lostChunkDataMap.containsKey(cc)) {
            LostChunkData data = new LostChunkData();
            if (lost == null) {
                data.initialize(world, cc, Config.getDefaultSettings());
                this.lostChunkDataMap.put(cc, data);
            } else {
                MobSettings settings = this.getSettingsForChunk(world, cc, lost);
                data.initialize(world, cc, settings);
                ILostChunkInfo chunkInfo = lost.getChunkInfo(cc.chunkX(), cc.chunkZ());
                ILostChunkInfo.MultiBuildingInfo mb = chunkInfo.getMultiBuildingInfo();
                if (mb != null) {
                    ChunkCoord topleft = cc.offset(-mb.offsetX(), -mb.offsetZ());
                    for (int x = 0; x < mb.w(); ++x) {
                        for (int z = 0; z < mb.h(); ++z) {
                            this.lostChunkDataMap.put(topleft.offset(x, z), data);
                        }
                    }
                } else {
                    this.lostChunkDataMap.put(cc, data);
                }
            }
            this.m_77762_();
        }
        return this.lostChunkDataMap.get(cc);
    }

    private void load(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("chunks", 10);
        for (Tag tag : list) {
            CompoundTag tc = (CompoundTag)tag;
            ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tc.m_128461_("dim")));
            int x = tc.m_128451_("x");
            int z = tc.m_128451_("z");
            LostChunkData data = new LostChunkData();
            data.readFromNBT(tc);
            this.lostChunkDataMap.put(new ChunkCoord((ResourceKey<Level>)dim, x, z), data);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<ChunkCoord, LostChunkData> entry : this.lostChunkDataMap.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.m_128359_("dim", entry.getKey().dimension().m_135782_().toString());
            tc.m_128405_("x", entry.getKey().chunkX());
            tc.m_128405_("z", entry.getKey().chunkZ());
            entry.getValue().writeToNBT(tc);
            list.add((Object)tc);
        }
        compound.m_128365_("chunks", (Tag)list);
        return compound;
    }
}

