/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityGuardianBlade
extends EntityMagicEffects {
    public final ControlledAnimation controlled = new ControlledAnimation(30);
    private boolean moveOffset;
    private float damage = 1.0f;
    private static final float[][] BLOCK_OFFSETS = new float[][]{{-0.5f, -0.5f}, {-0.5f, 0.5f}, {0.5f, 0.5f}, {0.5f, -0.5f}};

    public EntityGuardianBlade(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public EntityGuardianBlade(Level level, LivingEntity caster, double x, double y, double z, float yRot, boolean moveOffset) {
        this((EntityType)EntityInit.GUARDIAN_BLADE.get(), level);
        this.damage = (float)caster.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44833_((ItemStack)caster.m_21205_(), (MobType)caster.m_6336_());
        this.m_146922_(yRot * 57.295776f - 90.0f);
        this.moveOffset = moveOffset;
        this.caster = caster;
        this.m_6034_(x, y, z);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.controlled.updatePrevTimer();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.controlled.isStop()) {
            Vec3 lookAngle = this.m_20154_();
            float speed = 1.35f;
            if (this.moveOffset) {
                speed += this.f_19796_.m_188501_() * 0.5f;
            }
            this.shoot(lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, speed);
            this.controlled.increaseTimer(1);
        } else if (this.controlled.increaseTimerChain().getTimer() % 5 == 0) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        }
        if (this.controlled.isEnd() || this.f_19797_ > this.controlled.getDuration() * 2) {
            this.m_146870_();
        } else {
            this.breakBlockEffect();
            this.doHurtTarget();
        }
    }

    private void shoot(double x, double y, double z, double speed) {
        this.m_20334_(x * speed, y * speed, z * speed);
    }

    private void doHurtTarget() {
        if (!this.m_9236_().f_46443_) {
            float progress = 1.0f - this.controlled.getAnimationFraction();
            List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
            for (LivingEntity target : entities) {
                if (target == this.caster) continue;
                if (this.caster instanceof EntityNamelessGuardian) {
                    this.damage += target.m_21233_() * 0.05f;
                }
                this.damage = Math.max(1.0f, this.damage * progress);
                this.damage = ModEntityUtils.actualDamageIsCalculatedBasedOnArmor(this.damage, target.m_21230_(), (float)target.m_21133_(Attributes.f_22285_), 1.0f);
                target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.caster), this.damage);
            }
        }
    }

    private void breakBlockEffect() {
        if (this.m_9236_().f_46443_) {
            double theta = Math.toRadians(this.m_146908_());
            double x = this.m_20185_() + Math.cos(theta + 1.5707963267948966);
            double y = this.m_20191_().f_82289_ + 0.1;
            double z = this.m_20189_() + Math.sin(theta + 1.5707963267948966);
            int count = (int)Math.floor(15.0f * Math.max(1.0f - (this.controlled.getAnimationFraction() + 0.2f), 0.0f));
            ModParticleUtils.generateParticleEffects(this.m_9236_(), x, y, z, theta, count, BLOCK_OFFSETS, pos -> this.m_9236_().m_8055_(pos), 1.0);
            if (count > 3 && this.controlled.getTimer() % 2 == 0) {
                Vec3 movement = this.m_20184_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleInit.GUARDIAN_SPARK.get(), this.m_20208_(0.25), this.m_20187_(), this.m_20262_(0.25), movement.f_82479_ * 0.25, (double)(this.f_19796_.m_188501_() * 0.05f), movement.f_82481_ * 0.25);
            }
        }
    }
}

