/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.message;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.animation.EMAnimatedEntity;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AnimationMessage {
    private int entityID;
    private int animationsIndex;

    public AnimationMessage() {
    }

    public AnimationMessage(int entityID, int animationsIndex) {
        this.entityID = entityID;
        this.animationsIndex = animationsIndex;
    }

    public static void serialize(AnimationMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityID);
        buf.m_130130_(message.animationsIndex);
    }

    public static AnimationMessage deserialize(FriendlyByteBuf buf) {
        AnimationMessage message = new AnimationMessage();
        message.entityID = buf.m_130242_();
        message.animationsIndex = buf.m_130242_();
        return message;
    }

    public static class Handler
    implements BiConsumer<AnimationMessage, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(AnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                Entity entity;
                if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID)) instanceof EMAnimatedEntity) {
                    EMAnimatedEntity animationEntity = (EMAnimatedEntity)entity;
                    if (!animationEntity.getAnimation().isSuperposition()) {
                        animationEntity.getAnimation().m_216973_();
                    }
                    if (message.animationsIndex == -1) {
                        animationEntity.setAnimation(EMAnimatedEntity.NO_ANIMATION);
                    } else {
                        Animation animation = animationEntity.getAnimations()[message.animationsIndex];
                        animationEntity.setAnimation(animation);
                        animation.m_216982_(entity.f_19797_);
                    }
                    animationEntity.setAnimationTick(0);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

