/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.ai.animation;

import com.eeeab.animate.server.ai.animation.AnimationMelee;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AnimationAreaMelee<T extends EEEABMobLibrary>
extends AnimationMelee<T> {
    private final float attackArc;
    private final float leftAttackArc;
    private final float rightAttackArc;
    private final float attackHeight;
    private final boolean faceTarget;
    private Consumer<LivingEntity> consumer;

    public AnimationAreaMelee(T entity, Supplier<Animation> animationSupplier, int damageKeyframes, float attackDistance, float applyDamage, float applyKnockBack, float attackArc, float attackHeight, boolean faceTarget) {
        super(entity, animationSupplier, damageKeyframes, attackDistance, applyDamage, applyKnockBack);
        this.leftAttackArc = this.attackArc = attackArc;
        this.rightAttackArc = this.attackArc;
        this.attackHeight = attackHeight;
        this.faceTarget = faceTarget;
        this.consumer = null;
    }

    public AnimationAreaMelee(T entity, Supplier<Animation> animationSupplier, int damageKeyframes, float attackDistance, float applyDamage, float applyKnockBack, float leftAttackArc, float rightAttackArc, float attackHeight, boolean faceTarget) {
        super(entity, animationSupplier, damageKeyframes, attackDistance, applyDamage, applyKnockBack);
        this.rightAttackArc = rightAttackArc;
        this.leftAttackArc = leftAttackArc;
        this.attackArc = rightAttackArc + leftAttackArc;
        this.attackHeight = attackHeight;
        this.faceTarget = faceTarget;
    }

    public AnimationAreaMelee<T> setCustomHitMethod(Consumer<LivingEntity> entityConsumer) {
        this.consumer = entityConsumer;
        return this;
    }

    @Override
    public void m_8037_() {
        if (this.faceTarget && this.entity.getAnimationTick() < this.damageKeyframes && this.attackTarget != null) {
            this.entity.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
        } else if (this.entity.getAnimationTick() == this.damageKeyframes) {
            List<LivingEntity> entitiesHit = this.entity.getNearByLivingEntities(this.attackDistance, this.attackHeight, this.attackDistance, this.attackDistance);
            for (LivingEntity entityHit : entitiesHit) {
                float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, entityHit);
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.entity.m_20189_()) * (entityHit.m_20189_() - this.entity.m_20189_()) + (entityHit.m_20185_() - this.entity.m_20185_()) * (entityHit.m_20185_() - this.entity.m_20185_())) - entityHit.m_20205_() / 2.0f;
                if (!(entityHitDistance <= this.attackDistance && entityRelativeAngle <= this.rightAttackArc / 2.0f && entityRelativeAngle >= -this.leftAttackArc / 2.0f || entityRelativeAngle >= 360.0f - this.attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.attackArc / 2.0f)) continue;
                if (this.consumer != null) {
                    this.consumer.accept(entityHit);
                } else {
                    this.entity.doHurtTarget((Entity)entityHit, this.damageMultiplier, this.knockBackMultiplier);
                }
                this.onAttack(this.entity, entityHit, this.damageMultiplier, this.knockBackMultiplier);
            }
        }
    }
}

