/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.client.gui;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.animation.EMAnimatedEntity;
import com.eeeab.animate.server.inventory.AnimationControllerMenu;
import com.eeeab.animate.server.message.PlayAnimationMessage;
import com.eeeab.eeeabsmobs.EEEABMobs;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class AnimationControllerScreen
extends AbstractContainerScreen<AnimationControllerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/screens/animation_controller.png");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+");
    private final Entity animationEntity;
    private final Component chatComponent;
    EditBox animationIndexEdit;
    Button playButton;

    public AnimationControllerScreen(AnimationControllerMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 80;
        this.f_97727_ = 83;
        this.chatComponent = text;
        this.animationEntity = container.animationEntity;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.animationIndexEdit.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        RenderSystem.disableBlend();
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            return this.close();
        }
        if (this.animationIndexEdit.m_93696_()) {
            return this.animationIndexEdit.m_7933_(key, b, c);
        }
        return super.m_7933_(key, b, c);
    }

    public void m_181908_() {
        super.m_181908_();
        this.animationIndexEdit.m_94120_();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.chatComponent, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.chatComponent) / 2, 6, 0x404040, false);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.animationIndexEdit = new EditBox(this.f_96547_, this.f_97735_ + 9, this.f_97736_ + 32, 61, 18, (Component)Component.m_237119_()){

            public void m_94192_(int pos) {
                super.m_94192_(pos);
                this.doSuggestionMsg();
            }

            public void m_94164_(@NotNull String text) {
                super.m_94164_(text);
                this.doSuggestionMsg();
            }

            private void doSuggestionMsg() {
                EMAnimatedEntity animatedEntity;
                int length = -1;
                Entity entity = AnimationControllerScreen.this.animationEntity;
                if (entity instanceof EMAnimatedEntity && (animatedEntity = (EMAnimatedEntity)entity).getAnimations() != null) {
                    length = animatedEntity.getAnimations().length;
                }
                this.m_94167_(this.m_94155_().isEmpty() ? Component.m_237113_((String)(length > 0 ? "index[0-" + length + ")" : "index[0]")).getString() : null);
            }
        };
        this.animationIndexEdit.m_94199_(4);
        this.m_7787_((GuiEventListener)this.animationIndexEdit);
        this.playButton = Button.m_253074_((Component)Component.m_237113_((String)"play"), e -> {
            Entity patt4480$temp = this.animationEntity;
            if (patt4480$temp instanceof EMAnimatedEntity) {
                Animation animation;
                int index;
                EMAnimatedEntity animatedEntity = (EMAnimatedEntity)patt4480$temp;
                String value = this.animationIndexEdit.m_94155_();
                Animation[] animations = animatedEntity.getAnimations();
                if (animations != null && AnimationControllerScreen.isInteger(value) && (index = Integer.parseInt(value)) >= 0 && index < animations.length && (animation = animations[index]) != null && EMAnimatedEntity.NO_ANIMATION == animatedEntity.getAnimation()) {
                    EEEABMobs.NETWORK.sendToServer((Object)new PlayAnimationMessage(this.animationEntity.m_19879_(), ArrayUtils.indexOf((Object[])animations, (Object)((Object)animation))));
                    this.close();
                }
                e.m_7435_(Minecraft.m_91087_().m_91106_());
            }
        }).m_252987_(this.f_97735_ + 17, this.f_97736_ + 57, 46, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.playButton);
    }

    private boolean close() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return false;
    }

    private static boolean isInteger(String str) {
        return str != null && NUMBER_PATTERN.matcher(str).matches();
    }
}

