/*
 * Decompiled with CFR 0.152.
 */
package net.kaikk.mc.serverredirect.forge;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.kaikk.mc.serverredirect.forge.PacketHandler;
import net.kaikk.mc.serverredirect.forge.event.ClientFallbackEvent;
import net.kaikk.mc.serverredirect.forge.event.ClientRedirectEvent;
import net.kaikk.mc.serverredirect.forge.event.PlayerFallbackEvent;
import net.kaikk.mc.serverredirect.forge.event.PlayerRedirectEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="serverredirect")
public class ServerRedirect {
    public static final String MODID = "serverredirect";
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final Set<UUID> players = Collections.synchronizedSet(new HashSet());
    @OnlyIn(value=Dist.CLIENT)
    public static volatile String fallbackServerAddress;
    @OnlyIn(value=Dist.CLIENT)
    public static boolean connected;

    public ServerRedirect() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"redirect").requires(cs -> cs.m_6761_(2))).redirect((CommandNode)event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MODID).requires(cs -> cs.m_6761_(2))).then(this.commandAddress(ServerRedirect::sendTo)))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fallback").requires(cs -> cs.m_6761_(2))).redirect((CommandNode)event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fallbackserver").requires(cs -> cs.m_6761_(2))).then(this.commandAddress(ServerRedirect::sendFallbackTo)))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ifplayercanredirect").requires(cs -> cs.m_6761_(2))).then(this.commandIfPlayerRedirect(false)));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ifplayercannotredirect").requires(cs -> cs.m_6761_(2))).then(this.commandIfPlayerRedirect(true)));
    }

    private ArgumentBuilder<CommandSourceStack, ?> commandAddress(BiConsumer<ServerPlayer, String> consumer) {
        return Commands.m_82129_((String)"Player(s)", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"Server Address", (ArgumentType)StringArgumentType.greedyString()).executes(cs -> {
            try {
                String addr = (String)cs.getArgument("Server Address", String.class);
                if (!PacketHandler.ADDRESS_PREVALIDATOR.matcher(addr).matches()) {
                    ((CommandSourceStack)cs.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid Server Address"));
                    return 0;
                }
                ((EntitySelector)cs.getArgument("Player(s)", EntitySelector.class)).m_121166_((CommandSourceStack)cs.getSource()).forEach(p -> {
                    try {
                        consumer.accept((ServerPlayer)p, addr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    private ArgumentBuilder<CommandSourceStack, ?> commandIfPlayerRedirect(boolean not) {
        return Commands.m_82129_((String)"Player(s)", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"Command...", (ArgumentType)StringArgumentType.greedyString()).executes(cs -> {
            try {
                String command = (String)cs.getArgument("Command...", String.class);
                ((EntitySelector)cs.getArgument("Player(s)", EntitySelector.class)).m_121166_((CommandSourceStack)cs.getSource()).forEach(p -> {
                    try {
                        if (ServerRedirect.isUsingServerRedirect(p) != not) {
                            ((CommandSourceStack)cs.getSource()).m_81377_().m_129892_().m_230957_((CommandSourceStack)cs.getSource(), command.replace("%PlayerName", p.m_36316_().getName()).replace("%PlayerId", p.m_20149_()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (connected != (mc.f_91073_ != null)) {
            boolean bl = connected = mc.f_91073_ != null;
            if (connected) {
                PacketHandler.ANNOUNCE_CHANNEL.sendToServer(PacketHandler.EMPTY_OBJECT);
            }
        } else if (fallbackServerAddress != null) {
            if (mc.f_91080_ instanceof DisconnectedScreen) {
                String addr = fallbackServerAddress;
                fallbackServerAddress = null;
                ServerRedirect.redirect(addr);
            } else if (mc.f_91080_ instanceof TitleScreen || mc.f_91080_ instanceof JoinMultiplayerScreen) {
                fallbackServerAddress = null;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        players.remove(event.getEntity().m_20148_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void redirect(String serverAddress) {
        if (!Minecraft.m_91087_().m_18695_()) {
            throw new IllegalStateException("Not in the main thread");
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new ClientRedirectEvent(serverAddress))) {
            return;
        }
        LOGGER.info("Connecting to " + serverAddress);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            mc.f_91073_.m_7462_();
        }
        if (mc.m_91090_()) {
            mc.m_91320_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"menu.savingLevel")));
        } else {
            mc.m_91399_();
        }
        mc.m_91152_((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()));
        ConnectScreen.m_278792_((Screen)mc.f_91080_, (Minecraft)mc, (ServerAddress)ServerAddress.m_171864_((String)serverAddress), (ServerData)new ServerData(serverAddress, serverAddress, false), (boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getFallbackServerAddress() {
        return fallbackServerAddress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setFallbackServerAddress(String fallbackServerAddress) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ClientFallbackEvent(fallbackServerAddress))) {
            return;
        }
        ServerRedirect.fallbackServerAddress = fallbackServerAddress;
    }

    public static boolean sendTo(ServerPlayer player, String serverAddress) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlayerRedirectEvent(player, serverAddress))) {
            return false;
        }
        PacketHandler.REDIRECT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        return true;
    }

    public static void sendToAll(String serverAddress) {
        PlayerList pl = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (ServerPlayer player : pl.m_11314_()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerRedirectEvent(player, serverAddress))) continue;
            PacketHandler.REDIRECT_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        }
    }

    public static boolean sendFallbackTo(ServerPlayer player, String serverAddress) {
        if (MinecraftForge.EVENT_BUS.post((Event)new PlayerFallbackEvent(player, serverAddress))) {
            return false;
        }
        PacketHandler.FALLBACK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        return true;
    }

    public static void sendFallbackToAll(String serverAddress) {
        PlayerList pl = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (ServerPlayer player : pl.m_11314_()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerFallbackEvent(player, serverAddress))) continue;
            PacketHandler.FALLBACK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)serverAddress);
        }
    }

    public static boolean isUsingServerRedirect(ServerPlayer player) {
        return ServerRedirect.isUsingServerRedirect(player.m_20148_());
    }

    public static boolean isUsingServerRedirect(UUID playerId) {
        return players.contains(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachPlayerUsingServerRedirect(Consumer<UUID> consumer) {
        Set<UUID> set = players;
        synchronized (set) {
            for (UUID playerId : players) {
                consumer.accept(playerId);
            }
        }
    }

    public static Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(new HashSet<UUID>(players));
    }
}

