/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound.decorator;

import com.github.elenterius.biomancy.util.random.FastNoiseLite;
import com.github.elenterius.biomancy.world.mound.Chamber;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberDecorator;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PillarsDecorator
implements ChamberDecorator {
    private final FastNoiseLite simplexNoise;
    private final BlockState[] materials;
    private final Set<BlockState> materialsSet;

    public PillarsDecorator(BlockState ... materials) {
        this.materials = materials;
        this.materialsSet = Arrays.stream(materials).collect(Collectors.toUnmodifiableSet());
        this.simplexNoise = this.initNoise();
    }

    protected FastNoiseLite initNoise() {
        FastNoiseLite noise = new FastNoiseLite();
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(0.1f);
        return noise;
    }

    @Override
    public ChamberDecorator.PartOfDecorationResult isBlockPartOfDecoration(Chamber chamber, Level level, BlockPos pos, BlockState state) {
        return ChamberDecorator.PartOfDecorationResult.of(this.isPosInsideAnyPillar(chamber, pos), this.materialsSet.contains(state));
    }

    @Override
    public boolean canPlace(Chamber chamber, Level level, BlockPos pos, Direction axisDirection) {
        return this.isPosInsideAnyPillar(chamber, pos);
    }

    @Override
    public boolean place(Chamber chamber, Level level, BlockPos pos, Direction axisDirection) {
        int i = level.m_213780_().m_216339_(0, this.materials.length);
        return level.m_7731_(pos, this.materials[i], 2);
    }

    protected float pillarThreshold(float y) {
        float fx = (y - 0.5f) * (y - 0.5f) * 4.0f * -1.0f + 1.0f;
        return 0.42f + fx * 0.2f;
    }

    protected boolean isPosInsideAnyPillar(Chamber chamber, BlockPos pos) {
        Vec3 center = chamber.center();
        float x = (float)(center.f_82479_ - ((double)pos.m_123341_() + 0.5));
        float z = (float)(center.f_82481_ - ((double)pos.m_123343_() + 0.5));
        AABB aabb = chamber.getAABB();
        float yNormalized = PillarsDecorator.normalize(pos.m_123342_(), aabb.f_82289_, aabb.f_82292_);
        float threshold = this.pillarThreshold(yNormalized);
        this.simplexNoise.SetSeed(chamber.seed());
        return this.simplexNoise.GetNoise(x, 0.0f, z) >= threshold;
    }

    private static float normalize(double value, double min, double max) {
        float rescaled = (float)((value - min) / (max - min));
        return Mth.m_14036_((float)rescaled, (float)0.0f, (float)1.0f);
    }
}

